/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common;

import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.exception.ConfigException;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.exception.NewObjectException;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.exception.UnsupportedException;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.util.XmlUtil;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ObjFactory {
    private static final String T_Node = "Node";
    private static final String A_type = "type";
    private static final String A_class = "class";
    private Map type2class;

    public void loadTypesConfig(String filePath) {
        try {
            Element xmlNodes = XmlUtil.readXmlFile(filePath);
            this.parseTypes(xmlNodes);
        }
        catch (Exception ex) {
            ConfigException.makeException("Types defined error", ex);
        }
    }

    public void loadTypesConfig(InputStream in) {
        if (in == null) {
            throw new ConfigException("Types stream is null");
        }
        try {
            Element xmlNodes = XmlUtil.readXmlStream(in);
            this.parseTypes(xmlNodes);
        }
        catch (Exception ex) {
            ConfigException.makeException("Types defined error", ex);
        }
    }

    public void parseTypes(Element xmlNodes) {
        this.type2class = new HashMap();
        NodeList nl = xmlNodes.getElementsByTagName(T_Node);
        int z = nl.getLength();
        for (int i = 0; i < z; ++i) {
            Element xmlNode = (Element)nl.item(i);
            String type = xmlNode.getAttribute(A_type);
            String clsName = xmlNode.getAttribute(A_class);
            this.type2class.put(type, clsName);
        }
    }

    public boolean isType(String type) {
        if (this.type2class == null) {
            return false;
        }
        return this.type2class.containsKey(type);
    }

    public Object newObject(String type) {
        if (this.type2class == null) {
            throw new ConfigException("Types config not loaded!");
        }
        Object v = this.type2class.get(type);
        if (v == null) {
            throw new UnsupportedException("Undefined type:" + type);
        }
        try {
            Class<?> cls;
            if (v instanceof String) {
                cls = Class.forName((String)v);
                this.type2class.put(type, cls);
            } else {
                cls = (Class<?>)v;
            }
            return cls.newInstance();
        }
        catch (Exception ex) {
            throw NewObjectException.makeException("Type:" + type, ex);
        }
    }
}

