/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common;

import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.AutoGrowGrid;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.MergingGrid;
import java.util.Iterator;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class TestGridIterator
extends TestCase {
    private static final int COL_COUNT = 4;
    private static final int ROW_COUNT = 5;

    public static void main(String[] args) {
        TestRunner.run(TestGridIterator.class);
    }

    private void initGrid(AutoGrowGrid grid) {
        int i;
        grid.setColCount(4);
        grid.setRowCount(5);
        TestGridIterator.assertTrue((4 == grid.getColCount() ? 1 : 0) != 0);
        TestGridIterator.assertTrue((5 == grid.getRowCount() ? 1 : 0) != 0);
        for (i = 0; i < 4; ++i) {
            grid.setCol(i, String.valueOf((char)(65 + i)));
        }
        for (i = 0; i < 5; ++i) {
            grid.setRow(i, new Integer(i));
        }
        for (i = 0; i < 5; ++i) {
            for (int j = 0; j < 4; ++j) {
                String s = i + String.valueOf((char)(65 + j));
                grid.setCell(i, j, s);
            }
        }
    }

    public void testIterateCells() {
        AutoGrowGrid grid = new AutoGrowGrid();
        this.initGrid(grid);
        int colIdx = 0;
        Iterator i = grid.iterateCols();
        while (i.hasNext()) {
            TestGridIterator.assertTrue((((String)i.next()).charAt(0) == 65 + colIdx ? 1 : 0) != 0);
            ++colIdx;
        }
        int rowIdx = 0;
        Iterator i2 = grid.iterateRows();
        while (i2.hasNext()) {
            TestGridIterator.assertTrue(((Integer)i2.next() == rowIdx ? 1 : 0) != 0);
            ++rowIdx;
        }
        StringBuffer sb = new StringBuffer();
        AutoGrowGrid.CellsIterator i3 = grid.iterateCells();
        while (i3.hasNext()) {
            sb.append(i3.next());
            sb.append(",");
        }
        TestGridIterator.assertEquals((String)sb.toString(), (String)"0A,0B,0C,0D,1A,1B,1C,1D,2A,2B,2C,2D,3A,3B,3C,3D,4A,4B,4C,4D,");
    }

    private void assertMergingGrid(MergingGrid mgrid, String asserts) {
        StringBuffer sb = new StringBuffer();
        MergingGrid.MergingCellsIterator i = mgrid.iterateMergingCells();
        while (i.hasNext()) {
            sb.append(i.next());
            sb.append(",");
        }
        TestGridIterator.assertEquals((String)sb.toString(), (String)asserts);
    }

    public void testItreateMerging() {
        MergingGrid mg = new MergingGrid();
        this.initGrid(mg);
        mg.merge(0, 0, 2, 1);
        mg.setCell(0, 0, mg.getCell(0, 0) + "-2x1");
        mg.merge(1, 1, 1, 2);
        mg.setCell(1, 1, mg.getCell(1, 1) + "-1x2");
        mg.merge(2, 0, 1, 4);
        mg.setCell(2, 0, mg.getCell(2, 0) + "-1x4");
        mg.merge(3, 2, 2, 2);
        mg.setCell(3, 2, mg.getCell(3, 2) + "-2x2");
    }

    public void testItreateMerging3() {
        MergingGrid mg = new MergingGrid();
        this.initGrid(mg);
        mg.merge(0, 1, 5, 3);
        mg.setCell(0, 1, mg.getCell(0, 1) + "-5x3");
        this.assertMergingGrid(mg, "0A,0B-5x3,1A,2A,3A,4A,");
    }

    public void testItreateMerging2() {
        MergingGrid mg = new MergingGrid();
        this.initGrid(mg);
        mg.merge(0, 0, 5, 4);
        mg.setCell(0, 0, mg.getCell(0, 0) + "-4x5");
        this.assertMergingGrid(mg, "0A-4x5,");
    }
}

