/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common;

import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.AEnum;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.Constant;
import java.math.BigDecimal;
import java.text.DateFormat;

public class ValueType
extends AEnum {
    private static final int IS_NUMBER = 4096;
    private static final int IS_OBJECT = 8192;
    public static ValueType NULL = new ValueType("null", 0, 0);
    public static ValueType OBJECT = new ValueType("object", 8193, 2000);
    public static ValueType INTEGER = new ValueType("integer", 4098, 4);
    public static ValueType LONG = new ValueType("long", 4099, -5);
    public static ValueType DOUBLE = new ValueType("double", 4100, 8);
    public static ValueType DECIMAL = new ValueType("decimal", 12293, 3);
    public static ValueType STRING = new ValueType("string", 8198, 12);
    public static ValueType DATE = new ValueType("date", 8199, 91);
    private int jdbcType;

    private ValueType(String name, int code, int jdbcType) {
        super(name);
        this.jdbcType = jdbcType;
    }

    public final int getJdbcType() {
        return this.jdbcType;
    }

    public final boolean isObject() {
        return (this.getCode() & 0x2000) != 0;
    }

    public final boolean isNumber() {
        return (this.getCode() & 0x1000) != 0;
    }

    public static ValueType fromName(String name) {
        return (ValueType)AEnum.getEnum(ValueType.class, name);
    }

    public static ValueType fromJdbcType(int jdbcType) {
        switch (jdbcType) {
            case -7: 
            case -6: 
            case 4: 
            case 5: 
            case 16: {
                return INTEGER;
            }
            case -5: {
                return LONG;
            }
            case 6: 
            case 7: 
            case 8: {
                return DOUBLE;
            }
            case 2: 
            case 3: {
                return DECIMAL;
            }
            case 1: 
            case 12: {
                return STRING;
            }
            case 91: {
                return DATE;
            }
            case 0: {
                return NULL;
            }
        }
        return OBJECT;
    }

    public static ValueType typeofText(String s) {
        try {
            BigDecimal dec = new BigDecimal(s);
            int scale = dec.scale();
            if (scale > 0) {
                return DOUBLE;
            }
            if (dec.compareTo(Constant.MAX_INT_DECIMAL) > 0) {
                if (dec.compareTo(Constant.MAX_LONG_DECIMAL) > 0) {
                    return DECIMAL;
                }
                return LONG;
            }
            if (dec.compareTo(Constant.MIN_INT_DECIMAL) < 0) {
                if (dec.compareTo(Constant.MIN_LONG_DECIMAL) < 0) {
                    return DECIMAL;
                }
                return LONG;
            }
            return INTEGER;
        }
        catch (Throwable throwable) {
            try {
                DateFormat.getInstance().parse(s);
                return DATE;
            }
            catch (Throwable throwable2) {
                return STRING;
            }
        }
    }
}

