/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.xml;

import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.xml.EscapeStrategy;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.xml.Format;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.util.StringUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class XMLOutputter
implements Cloneable {
    private static final String NS_XML_PREFIX = "xml";
    private static final String NS_XML_URI = "http://www.w3.org/XML/1998/namespace";
    private Format userFormat;
    protected static final Format preserveFormat = Format.getRawFormat();
    protected Format currentFormat;
    private boolean escapeOutput;
    static final String EMPTY_STRING = "";

    private static boolean isNoNamespace(String nsPrefix, String nsURI) {
        return StringUtil.isEmpty(nsPrefix) && StringUtil.isEmpty(nsURI);
    }

    private static boolean isXmlNamespace(String nsPrefix, String nsURI) {
        return NS_XML_PREFIX.equals(nsPrefix) && NS_XML_URI.equals(nsURI);
    }

    public XMLOutputter() {
        this.currentFormat = this.userFormat = Format.getRawFormat();
        this.escapeOutput = true;
    }

    public XMLOutputter(Format format) {
        this.currentFormat = this.userFormat = Format.getRawFormat();
        this.escapeOutput = true;
        this.currentFormat = this.userFormat = (Format)format.clone();
    }

    public XMLOutputter(XMLOutputter that) {
        this.currentFormat = this.userFormat = Format.getRawFormat();
        this.escapeOutput = true;
        this.currentFormat = this.userFormat = (Format)that.userFormat.clone();
    }

    public void setFormat(Format newFormat) {
        this.currentFormat = this.userFormat = (Format)newFormat.clone();
    }

    public Format getFormat() {
        return (Format)this.userFormat.clone();
    }

    public void output(Document doc, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(doc, writer);
    }

    public void output(DocumentType doctype, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(doctype, writer);
    }

    public void output(Element element, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(element, writer);
    }

    public void outputElementContent(Element element, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.outputElementContent(element, writer);
    }

    public void output(NodeList list, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(list, writer);
    }

    public void output(CDATASection cdata, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(cdata, writer);
    }

    public void output(Text text, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(text, writer);
    }

    public void output(Comment comment, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(comment, writer);
    }

    public void output(ProcessingInstruction pi, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(pi, writer);
    }

    public void output(EntityReference entity, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(entity, writer);
    }

    private Writer makeWriter(OutputStream out) throws UnsupportedEncodingException {
        return XMLOutputter.makeWriter(out, this.userFormat.encoding);
    }

    private static Writer makeWriter(OutputStream out, String enc) throws UnsupportedEncodingException {
        if ("UTF-8".equals(enc)) {
            enc = "UTF8";
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(out), enc));
        return writer;
    }

    public void output(Document doc, Writer out) throws IOException {
        this.printDeclaration(out, doc, this.userFormat.encoding);
        NodeList content = doc.getChildNodes();
        int size = content.getLength();
        for (int i = 0; i < size; ++i) {
            Node obj = content.item(i);
            if (obj instanceof Element) {
                this.printElement(out, doc.getDocumentElement(), 0, this.createNamespaceStack());
            } else if (obj instanceof Comment) {
                this.printComment(out, (Comment)obj);
            } else if (obj instanceof ProcessingInstruction) {
                this.printProcessingInstruction(out, (ProcessingInstruction)obj);
            } else if (obj instanceof DocumentType) {
                this.printDocType(out, doc.getDoctype());
                out.write(this.currentFormat.lineSeparator);
            }
            this.newline(out);
            this.indent(out, 0);
        }
        out.write(this.currentFormat.lineSeparator);
        out.flush();
    }

    public void output(DocumentType doctype, Writer out) throws IOException {
        this.printDocType(out, doctype);
        out.flush();
    }

    public void output(Element element, Writer out) throws IOException {
        this.printElement(out, element, 0, this.createNamespaceStack());
        out.flush();
    }

    public void outputElementContent(Element element, Writer out) throws IOException {
        NodeList content = element.getChildNodes();
        this.printContentRange(out, content, 0, content.getLength(), 0, this.createNamespaceStack());
        out.flush();
    }

    public void output(NodeList list, Writer out) throws IOException {
        this.printContentRange(out, list, 0, list.getLength(), 0, this.createNamespaceStack());
        out.flush();
    }

    public void output(CDATASection cdata, Writer out) throws IOException {
        this.printCDATA(out, cdata);
        out.flush();
    }

    public void output(Text text, Writer out) throws IOException {
        this.printText(out, text);
        out.flush();
    }

    public void output(Comment comment, Writer out) throws IOException {
        this.printComment(out, comment);
        out.flush();
    }

    public void output(ProcessingInstruction pi, Writer out) throws IOException {
        boolean currentEscapingPolicy = this.currentFormat.ignoreTrAXEscapingPIs;
        this.currentFormat.setIgnoreTrAXEscapingPIs(true);
        this.printProcessingInstruction(out, pi);
        this.currentFormat.setIgnoreTrAXEscapingPIs(currentEscapingPolicy);
        out.flush();
    }

    public void output(EntityReference entity, Writer out) throws IOException {
        this.printEntityRef(out, entity);
        out.flush();
    }

    public String outputString(Document doc) {
        StringWriter out = new StringWriter();
        try {
            this.output(doc, (Writer)out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public String outputString(DocumentType doctype) {
        StringWriter out = new StringWriter();
        try {
            this.output(doctype, (Writer)out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public String outputString(Element element) {
        StringWriter out = new StringWriter();
        try {
            this.output(element, (Writer)out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public String outputString(NodeList list) {
        StringWriter out = new StringWriter();
        try {
            this.output(list, (Writer)out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public String outputString(CDATASection cdata) {
        StringWriter out = new StringWriter();
        try {
            this.output(cdata, (Writer)out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public String outputString(Text text) {
        StringWriter out = new StringWriter();
        try {
            this.output(text, (Writer)out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public String outputString(Comment comment) {
        StringWriter out = new StringWriter();
        try {
            this.output(comment, (Writer)out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public String outputString(ProcessingInstruction pi) {
        StringWriter out = new StringWriter();
        try {
            this.output(pi, (Writer)out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public String outputString(EntityReference entity) {
        StringWriter out = new StringWriter();
        try {
            this.output(entity, (Writer)out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    protected void printDeclaration(Writer out, Document doc, String encoding) throws IOException {
        if (!this.userFormat.omitDeclaration) {
            out.write("<?xml version=\"1.0\"");
            if (!this.userFormat.omitEncoding) {
                out.write(" encoding=\"" + encoding + "\"");
            }
            out.write("?>");
            out.write(this.currentFormat.lineSeparator);
        }
    }

    protected void printDocType(Writer out, DocumentType docType) throws IOException {
        String publicID = docType.getPublicId();
        String systemID = docType.getSystemId();
        String internalSubset = docType.getInternalSubset();
        boolean hasPublic = false;
        out.write("<!DOCTYPE ");
        out.write(docType.getNodeName());
        if (publicID != null) {
            out.write(" PUBLIC \"");
            out.write(publicID);
            out.write("\"");
            hasPublic = true;
        }
        if (systemID != null) {
            if (!hasPublic) {
                out.write(" SYSTEM");
            }
            out.write(" \"");
            out.write(systemID);
            out.write("\"");
        }
        if (internalSubset != null && !internalSubset.equals(EMPTY_STRING)) {
            out.write(" [");
            out.write(this.currentFormat.lineSeparator);
            out.write(docType.getInternalSubset());
            out.write("]");
        }
        out.write(">");
    }

    protected void printComment(Writer out, Comment comment) throws IOException {
        out.write("<!--");
        out.write(comment.getNodeValue());
        out.write("-->");
    }

    protected void printProcessingInstruction(Writer out, ProcessingInstruction pi) throws IOException {
        String target = pi.getTarget();
        boolean piProcessed = false;
        if (!this.currentFormat.ignoreTrAXEscapingPIs) {
            if (target.equals("javax.xml.transform.disable-output-escaping")) {
                this.escapeOutput = false;
                piProcessed = true;
            } else if (target.equals("javax.xml.transform.enable-output-escaping")) {
                this.escapeOutput = true;
                piProcessed = true;
            }
        }
        if (!piProcessed) {
            String rawData = pi.getData();
            if (!EMPTY_STRING.equals(rawData)) {
                out.write("<?");
                out.write(target);
                out.write(" ");
                out.write(rawData);
                out.write("?>");
            } else {
                out.write("<?");
                out.write(target);
                out.write("?>");
            }
        }
    }

    protected void printEntityRef(Writer out, EntityReference entity) throws IOException {
        out.write("&");
        out.write(entity.getLocalName());
        out.write(";");
    }

    protected void printCDATA(Writer out, CDATASection cdata) throws IOException {
        String str = this.currentFormat.mode == Format.TextMode.NORMALIZE ? XMLOutputter.normalizeString(cdata.getNodeValue()) : (this.currentFormat.mode == Format.TextMode.TRIM ? cdata.getNodeValue().trim() : cdata.getNodeValue());
        out.write("<![CDATA[");
        out.write(str);
        out.write("]]>");
    }

    protected void printText(Writer out, Text text) throws IOException {
        String str = this.currentFormat.mode == Format.TextMode.NORMALIZE ? XMLOutputter.normalizeString(text.getNodeValue()) : (this.currentFormat.mode == Format.TextMode.TRIM ? text.getNodeValue().trim() : text.getNodeValue());
        out.write(this.escapeElementEntities(str));
    }

    private void printString(Writer out, String str) throws IOException {
        if (this.currentFormat.mode == Format.TextMode.NORMALIZE) {
            str = XMLOutputter.normalizeString(str);
        } else if (this.currentFormat.mode == Format.TextMode.TRIM) {
            str = str.trim();
        }
        out.write(this.escapeElementEntities(str));
    }

    protected void printElement(Writer out, Element element, int level, NamespaceStack namespaces) throws IOException {
        int size;
        int start;
        NamedNodeMap attributes = element.getAttributes();
        NodeList content = element.getChildNodes();
        String space = null;
        if (attributes != null) {
            space = element.getAttributeNS(NS_XML_URI, "space");
        }
        Format previousFormat = this.currentFormat;
        if ("default".equals(space)) {
            this.currentFormat = this.userFormat;
        } else if ("preserve".equals(space)) {
            this.currentFormat = preserveFormat;
        }
        out.write("<");
        this.printQualifiedName(out, element);
        int previouslyDeclaredNamespaces = namespaces.size();
        this.printElementNamespace(out, element, namespaces);
        this.printAdditionalNamespaces(out, element, namespaces);
        if (attributes != null) {
            this.printAttributes(out, attributes, element, namespaces);
        }
        if ((start = this.skipLeadingWhite(content, 0)) >= (size = content.getLength())) {
            if (this.currentFormat.expandEmptyElements) {
                out.write("></");
                this.printQualifiedName(out, element);
                out.write(">");
            } else {
                out.write(" />");
            }
        } else {
            out.write(">");
            if (XMLOutputter.nextNonText(content, start) < size) {
                this.newline(out);
                this.printContentRange(out, content, start, size, level + 1, namespaces);
                this.newline(out);
                this.indent(out, level);
            } else {
                this.printTextRange(out, content, start, size);
            }
            out.write("</");
            this.printQualifiedName(out, element);
            out.write(">");
        }
        while (namespaces.size() > previouslyDeclaredNamespaces) {
            namespaces.pop();
        }
        this.currentFormat = previousFormat;
    }

    private void printContentRange(Writer out, NodeList content, int start, int end, int level, NamespaceStack namespaces) throws IOException {
        int index = start;
        while (index < end) {
            boolean firstNode = index == start;
            Node next = content.item(index);
            if (next instanceof Text || next instanceof EntityReference) {
                int first = this.skipLeadingWhite(content, index);
                if (first >= (index = XMLOutputter.nextNonText(content, first))) continue;
                if (!firstNode) {
                    this.newline(out);
                }
                this.indent(out, level);
                this.printTextRange(out, content, first, index);
                continue;
            }
            if (!firstNode) {
                this.newline(out);
            }
            this.indent(out, level);
            if (next instanceof Comment) {
                this.printComment(out, (Comment)next);
            } else if (next instanceof Element) {
                this.printElement(out, (Element)next, level, namespaces);
            } else if (next instanceof ProcessingInstruction) {
                this.printProcessingInstruction(out, (ProcessingInstruction)next);
            }
            ++index;
        }
    }

    private void printTextRange(Writer out, NodeList content, int start, int end) throws IOException {
        int size;
        String previous = null;
        if ((start = this.skipLeadingWhite(content, start)) < (size = content.getLength())) {
            end = this.skipTrailingWhite(content, end);
            for (int i = start; i < end; ++i) {
                String next;
                Node node = content.item(i);
                if (node instanceof Text) {
                    next = ((Text)node).getNodeValue();
                } else if (node instanceof EntityReference) {
                    next = "&" + ((EntityReference)node).getNodeValue() + ";";
                } else {
                    throw new IllegalStateException("Should see only CDATA, Text, or EntityReference");
                }
                if (next == null || EMPTY_STRING.equals(next)) continue;
                if (previous != null && (this.currentFormat.mode == Format.TextMode.NORMALIZE || this.currentFormat.mode == Format.TextMode.TRIM) && (this.endsWithWhite(previous) || this.startsWithWhite(next))) {
                    out.write(" ");
                }
                if (node instanceof CDATASection) {
                    this.printCDATA(out, (CDATASection)node);
                } else if (node instanceof EntityReference) {
                    this.printEntityRef(out, (EntityReference)node);
                } else {
                    this.printString(out, next);
                }
                previous = next;
            }
        }
    }

    private void printNamespace(Writer out, String nsPrefix, String nsURI, NamespaceStack namespaces) throws IOException {
        if (nsURI.equals(namespaces.getURI(nsPrefix))) {
            return;
        }
        out.write(" xmlns");
        if (!nsPrefix.equals(EMPTY_STRING)) {
            out.write(":");
            out.write(nsPrefix);
        }
        out.write("=\"");
        out.write(nsURI);
        out.write("\"");
        namespaces.push(nsPrefix, nsURI);
    }

    protected void printAttributes(Writer out, NamedNodeMap attributes, Element parent, NamespaceStack namespaces) throws IOException {
        int z = attributes.getLength();
        for (int i = 0; i < z; ++i) {
            String nsURI;
            Attr attribute = (Attr)attributes.item(i);
            String nsPrefix = attribute.getPrefix();
            if (!XMLOutputter.isNoNamespace(nsPrefix, nsURI = attribute.getNamespaceURI()) && !XMLOutputter.isXmlNamespace(nsPrefix, nsURI)) {
                this.printNamespace(out, nsPrefix, nsURI, namespaces);
            }
            out.write(" ");
            this.printQualifiedName(out, attribute);
            out.write("=");
            out.write("\"");
            String attVal = attribute.getValue();
            if (attVal != null) {
                out.write(this.escapeAttributeEntities(attVal));
            }
            out.write("\"");
        }
    }

    private void printElementNamespace(Writer out, Element element, NamespaceStack namespaces) throws IOException {
        String nsURI;
        String nsPrefix = element.getPrefix();
        if (XMLOutputter.isXmlNamespace(nsPrefix, nsURI = element.getNamespaceURI())) {
            return;
        }
        if (!XMLOutputter.isNoNamespace(nsPrefix, nsURI)) {
            this.printNamespace(out, nsPrefix, nsURI, namespaces);
        }
    }

    private void printAdditionalNamespaces(Writer out, Element element, NamespaceStack namespaces) throws IOException {
    }

    private void newline(Writer out) throws IOException {
        if (this.currentFormat.indent != null) {
            out.write(this.currentFormat.lineSeparator);
        }
    }

    private void indent(Writer out, int level) throws IOException {
        if (this.currentFormat.indent == null || this.currentFormat.indent.equals(EMPTY_STRING)) {
            return;
        }
        for (int i = 0; i < level; ++i) {
            out.write(this.currentFormat.indent);
        }
    }

    private int skipLeadingWhite(NodeList content, int start) {
        int index;
        if (start < 0) {
            start = 0;
        }
        int size = content.getLength();
        if (this.currentFormat.mode == Format.TextMode.TRIM_FULL_WHITE || this.currentFormat.mode == Format.TextMode.NORMALIZE || this.currentFormat.mode == Format.TextMode.TRIM) {
            for (index = start; index < size; ++index) {
                if (this.isAllWhitespace(content.item(index))) continue;
                return index;
            }
        }
        return index;
    }

    private int skipTrailingWhite(NodeList content, int start) {
        int index;
        int size = content.getLength();
        if (start > size) {
            start = size;
        }
        if (this.currentFormat.mode == Format.TextMode.TRIM_FULL_WHITE || this.currentFormat.mode == Format.TextMode.NORMALIZE || this.currentFormat.mode == Format.TextMode.TRIM) {
            for (index = start; index >= 0 && this.isAllWhitespace(content.item(index - 1)); --index) {
            }
        }
        return index;
    }

    private static int nextNonText(List content, int start) {
        if (start < 0) {
            start = 0;
        }
        int size = content.size();
        for (int index = start; index < size; ++index) {
            Object node = content.get(index);
            if (node instanceof Text || node instanceof EntityReference) continue;
            return index;
        }
        return size;
    }

    private boolean isAllWhitespace(Object obj) {
        String str = null;
        if (obj instanceof String) {
            str = (String)obj;
        } else if (obj instanceof Text) {
            str = ((Text)obj).getNodeValue();
            if (str == null) {
                return true;
            }
        } else {
            if (obj instanceof EntityReference) {
                return false;
            }
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (XMLOutputter.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private boolean startsWithWhite(String str) {
        return str != null && str.length() > 0 && XMLOutputter.isWhitespace(str.charAt(0));
    }

    private boolean endsWithWhite(String str) {
        return str != null && str.length() > 0 && XMLOutputter.isWhitespace(str.charAt(str.length() - 1));
    }

    private static boolean isWhitespace(char c) {
        return c == ' ' || c == '\n' || c == '\t' || c == '\r';
    }

    public String escapeAttributeEntities(String str) {
        EscapeStrategy strategy = this.currentFormat.escapeStrategy;
        StringBuffer buffer = null;
        for (int i = 0; i < str.length(); ++i) {
            String entity;
            char ch = str.charAt(i);
            switch (ch) {
                case '<': {
                    entity = "&lt;";
                    break;
                }
                case '>': {
                    entity = "&gt;";
                    break;
                }
                case '\"': {
                    entity = "&quot;";
                    break;
                }
                case '&': {
                    entity = "&amp;";
                    break;
                }
                case '\r': {
                    entity = "&#xD;";
                    break;
                }
                case '\t': {
                    entity = "&#x9;";
                    break;
                }
                case '\n': {
                    entity = "&#xA;";
                    break;
                }
                default: {
                    entity = strategy.shouldEscape(ch) ? "&#x" + Integer.toHexString(ch) + ";" : null;
                }
            }
            if (buffer == null) {
                if (entity == null) continue;
                buffer = new StringBuffer(str.length() + 20);
                buffer.append(str.substring(0, i));
                buffer.append(entity);
                continue;
            }
            if (entity == null) {
                buffer.append(ch);
                continue;
            }
            buffer.append(entity);
        }
        return buffer == null ? str : buffer.toString();
    }

    public String escapeElementEntities(String str) {
        if (!this.escapeOutput) {
            return str;
        }
        EscapeStrategy strategy = this.currentFormat.escapeStrategy;
        StringBuffer buffer = null;
        for (int i = 0; i < str.length(); ++i) {
            String entity;
            char ch = str.charAt(i);
            switch (ch) {
                case '<': {
                    entity = "&lt;";
                    break;
                }
                case '>': {
                    entity = "&gt;";
                    break;
                }
                case '&': {
                    entity = "&amp;";
                    break;
                }
                case '\r': {
                    entity = "&#xD;";
                    break;
                }
                case '\n': {
                    entity = this.currentFormat.lineSeparator;
                    break;
                }
                default: {
                    entity = strategy.shouldEscape(ch) ? "&#x" + Integer.toHexString(ch) + ";" : null;
                }
            }
            if (buffer == null) {
                if (entity == null) continue;
                buffer = new StringBuffer(str.length() + 20);
                buffer.append(str.substring(0, i));
                buffer.append(entity);
                continue;
            }
            if (entity == null) {
                buffer.append(ch);
                continue;
            }
            buffer.append(entity);
        }
        return buffer == null ? str : buffer.toString();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        block5: for (int i = 0; i < this.userFormat.lineSeparator.length(); ++i) {
            char ch = this.userFormat.lineSeparator.charAt(i);
            switch (ch) {
                case '\r': {
                    buffer.append("\\r");
                    continue block5;
                }
                case '\n': {
                    buffer.append("\\n");
                    continue block5;
                }
                case '\t': {
                    buffer.append("\\t");
                    continue block5;
                }
                default: {
                    buffer.append("[" + ch + "]");
                }
            }
        }
        return "XMLOutputter[omitDeclaration = " + this.userFormat.omitDeclaration + ", encoding = " + this.userFormat.encoding + ", omitEncoding = " + this.userFormat.omitEncoding + ", indent = '" + this.userFormat.indent + "', expandEmptyElements = " + this.userFormat.expandEmptyElements + ", lineSeparator = '" + buffer.toString() + "', textMode = " + this.userFormat.mode + "]";
    }

    private NamespaceStack createNamespaceStack() {
        return new NamespaceStack();
    }

    private void printQualifiedName(Writer out, Element e) throws IOException {
        String nsPrefix = e.getPrefix();
        if (StringUtil.isEmpty(nsPrefix)) {
            out.write(e.getTagName());
        } else {
            out.write(nsPrefix);
            out.write(58);
            out.write(e.getTagName());
        }
    }

    private void printQualifiedName(Writer out, Attr a2) throws IOException {
        String nsPrefix = a2.getPrefix();
        if (!StringUtil.isEmpty(nsPrefix)) {
            out.write(nsPrefix);
            out.write(58);
            out.write(a2.getName());
        } else {
            out.write(a2.getName());
        }
    }

    public static String normalizeString(String str) {
        if (str == null) {
            return EMPTY_STRING;
        }
        char[] c = str.toCharArray();
        char[] n = new char[c.length];
        boolean white = true;
        int pos = 0;
        for (int i = 0; i < c.length; ++i) {
            if (" \t\n\r".indexOf(c[i]) != -1) {
                if (white) continue;
                n[pos++] = 32;
                white = true;
                continue;
            }
            n[pos++] = c[i];
            white = false;
        }
        if (white && pos > 0) {
            --pos;
        }
        return new String(n, 0, pos);
    }

    private static int nextNonText(NodeList content, int start) {
        if (start < 0) {
            start = 0;
        }
        int size = content.getLength();
        for (int index = start; index < size; ++index) {
            Node node = content.item(index);
            if (node instanceof Text || node instanceof EntityReference) continue;
            return index;
        }
        return size;
    }

    protected class NamespaceStack
    extends com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.xml.NamespaceStack {
        protected NamespaceStack() {
        }
    }
}

