/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.engine.x.formats.csv;

import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.formats.csv.CsvFormat;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;

public class CsvReader {
    private Reader reader;
    private CsvFormat format;
    private int lastChar = 0;
    private static final int STATE0 = 0;
    private static final int BRACKET1 = 2;
    private static final int BRACKET2 = 4;

    public CsvReader(Reader reader) {
        this(reader, CsvFormat.DEFAULT);
    }

    public CsvReader(Reader reader, CsvFormat format) {
        this.reader = reader;
        this.format = format;
    }

    public final void seekToRowEnd() throws IOException {
        int c;
        while (10 != (c = this.reader.read()) && -1 != c) {
        }
    }

    public final boolean isEnd() {
        return this.lastChar == -1;
    }

    public final boolean onRowEnd() {
        return this.lastChar == 10 || this.lastChar == -1;
    }

    public final String[] readRow() throws IOException {
        ArrayList<String> cellList = new ArrayList<String>();
        do {
            cellList.add(this.readCell());
        } while (!this.onRowEnd());
        String[] cells = new String[cellList.size()];
        cellList.toArray(cells);
        return cells;
    }

    public final int readRow(String[] cells) throws IOException {
        int i = 0;
        while (i < cells.length) {
            cells[i++] = this.readCell();
            if (!this.onRowEnd()) continue;
            if (i == 1 && cells[0] == null) {
                i = 0;
            }
            for (int j = i; j < cells.length; ++j) {
                cells[j] = null;
            }
            return i;
        }
        this.seekToRowEnd();
        return cells.length + 1;
    }

    public final String readCell() throws IOException {
        StringBuffer sb = new StringBuffer();
        int state = 0;
        while (true) {
            this.lastChar = this.reader.read();
            if (this.format.cellSplit == this.lastChar || 10 == this.lastChar) {
                if (2 != state) break;
                sb.append((char)this.lastChar);
                continue;
            }
            if (this.format.dataBracket == this.lastChar) {
                if (2 == state) {
                    state = 4;
                    continue;
                }
                if (4 == state) {
                    sb.append((char)this.lastChar);
                    state = 2;
                    continue;
                }
                state = 2;
                continue;
            }
            if (-1 == this.lastChar) break;
            if (32 > this.lastChar) {
                if (4 == state) {
                    state = 0;
                }
                if (2 != state) continue;
                sb.append((char)this.lastChar);
                continue;
            }
            if (4 == state) {
                state = 0;
            }
            sb.append((char)this.lastChar);
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return 4 == state ? "" : null;
    }
}

