/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.engine.x.formats.csv;

import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.formats.csv.CsvReader;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.formats.csv.CsvWriter;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.util.ArrayUtil;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class TestCsvIO
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run(TestCsvIO.class);
    }

    private void readCsv(String csv, String out) throws IOException {
        TestCsvIO.assertEquals((String)new CsvReader(new StringReader(csv)).readCell(), (String)out);
    }

    public void testReadCell() throws IOException {
        this.readCsv("", null);
        this.readCsv(",", null);
        this.readCsv("\n", null);
        this.readCsv(",\n", null);
        this.readCsv("A\n", "A");
        this.readCsv("A,\n", "A");
        this.readCsv("\"", null);
        this.readCsv("\",", ",");
        this.readCsv("\"\n", "\n");
        this.readCsv("\"A", "A");
        this.readCsv("\"\"", "");
        this.readCsv("A\"\"", "A");
        this.readCsv("\"A\"", "A");
        this.readCsv("\"\"A", "A");
        this.readCsv("A\"\"B", "AB");
        this.readCsv("A\"B\"", "AB");
        this.readCsv("\"A\"B", "AB");
        this.readCsv("A\"B\"C", "ABC");
        this.readCsv("\"\"\"", "\"");
        this.readCsv("A\"\"\"", "A\"");
        this.readCsv("\"A\"\"", "A\"");
        this.readCsv("\"\"A\"", "A");
        this.readCsv("\"\"\"A", "\"A");
        this.readCsv("\"\"\"\"", "\"");
    }

    public void testReadRow() throws IOException {
        String csv = "0A,0B\n1A,1B,1C\n2A,2B";
        Object[] row0 = new String[]{"0A", "0B"};
        Object[] row1 = new String[]{"1A", "1B", "1C"};
        Object[] row2 = new String[]{"2A", "2B"};
        CsvReader cr = new CsvReader(new StringReader(csv));
        Object[] r0 = cr.readRow();
        TestCsvIO.assertTrue((boolean)ArrayUtil.equals(r0, row0));
        Object[] r1 = cr.readRow();
        TestCsvIO.assertTrue((boolean)ArrayUtil.equals(r1, row1));
        Object[] r2 = cr.readRow();
        TestCsvIO.assertTrue((boolean)ArrayUtil.equals(r2, row2));
    }

    public void testReadRow2() throws IOException {
        String csv = "0A,0B\n1A,1B,1C\n2A,2B";
        Object[] row0 = new String[]{"0A", "0B"};
        Object[] row1 = new String[]{"1A", "1B"};
        Object[] row2 = new String[]{"2A", "2B"};
        CsvReader cr = new CsvReader(new StringReader(csv));
        Object[] r = new String[2];
        TestCsvIO.assertTrue((2 == cr.readRow((String[])r) ? 1 : 0) != 0);
        TestCsvIO.assertTrue((boolean)ArrayUtil.equals(r, row0));
        TestCsvIO.assertTrue((3 == cr.readRow((String[])r) ? 1 : 0) != 0);
        TestCsvIO.assertTrue((boolean)ArrayUtil.equals(r, row1));
        TestCsvIO.assertTrue((2 == cr.readRow((String[])r) ? 1 : 0) != 0);
        TestCsvIO.assertTrue((boolean)ArrayUtil.equals(r, row2));
    }

    public void testReadRow3() throws IOException {
        String csv = "0A,0B\n1A,1B,1C\n2A,2B";
        Object[] row0 = new String[]{"0A", "0B", null};
        Object[] row1 = new String[]{"1A", "1B", "1C"};
        Object[] row2 = new String[]{"2A", "2B", null};
        CsvReader cr = new CsvReader(new StringReader(csv));
        Object[] r = new String[3];
        TestCsvIO.assertTrue((2 == cr.readRow((String[])r) ? 1 : 0) != 0);
        TestCsvIO.assertTrue((boolean)ArrayUtil.equals(r, row0));
        TestCsvIO.assertTrue((3 == cr.readRow((String[])r) ? 1 : 0) != 0);
        TestCsvIO.assertTrue((boolean)ArrayUtil.equals(r, row1));
        TestCsvIO.assertTrue((2 == cr.readRow((String[])r) ? 1 : 0) != 0);
        TestCsvIO.assertTrue((boolean)ArrayUtil.equals(r, row2));
    }

    public void testReadRow4() throws IOException {
        String csv = "0\"A\",0B\n1\"\"A,1\"B,1C\"\n2\"\"\"\"A,2\"B\n2C";
        Object[] row0 = new String[]{"0A", "0B"};
        Object[] row1 = new String[]{"1A", "1B,1C"};
        Object[] row2 = new String[]{"2\"A", "2B\n2C"};
        CsvReader cr = new CsvReader(new StringReader(csv));
        Object[] r0 = cr.readRow();
        TestCsvIO.assertTrue((boolean)ArrayUtil.equals(r0, row0));
        Object[] r1 = cr.readRow();
        TestCsvIO.assertTrue((boolean)ArrayUtil.equals(r1, row1));
        Object[] r2 = cr.readRow();
        TestCsvIO.assertTrue((boolean)ArrayUtil.equals(r2, row2));
    }

    private void csvIO(String s) throws IOException {
        StringWriter sw = new StringWriter();
        CsvWriter cw = new CsvWriter(sw);
        cw.writeData(s);
        StringReader sr = new StringReader(sw.getBuffer().toString());
        CsvReader cr = new CsvReader(sr);
        String s2 = cr.readCell();
        TestCsvIO.assertEquals((String)s2, (String)s);
    }
}

