/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.engine.x.util;

import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.AEnum;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.exception.XError;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.xml.Format;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.xml.XMLOutputter;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.util.BeanProperty;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.util.BeanUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.Writer;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlUtil {
    private static SAXParserFactory saxParserFactory;
    private static DocumentBuilderFactory domBuilderFactory;

    private XmlUtil() {
    }

    public static Element getFirstChild(Element parentXml, String childTag) {
        NodeList childs = parentXml.getElementsByTagName(childTag);
        if (childs.getLength() > 0) {
            return (Element)childs.item(0);
        }
        return null;
    }

    public static String getNodeText(Element node) {
        Node xmlText = node.getFirstChild();
        if (xmlText != null) {
            return xmlText.getNodeValue();
        }
        return null;
    }

    public static void setNodeText(Document doc, Element node, String text) {
        if (text != null) {
            Text xmlText = -1 != text.indexOf(60) || -1 != text.indexOf(62) ? doc.createCDATASection(text) : doc.createTextNode(text);
            node.appendChild(xmlText);
        }
    }

    public static SAXParser newSAXParser() throws SAXException {
        if (saxParserFactory == null) {
            saxParserFactory = SAXParserFactory.newInstance();
        }
        try {
            return saxParserFactory.newSAXParser();
        }
        catch (ParserConfigurationException ex) {
            throw XError.makeError("XML-SAX\u89e3\u6790\u5668\u914d\u7f6e\u9519\u8bef", ex);
        }
    }

    public static Document newDocument() {
        return XmlUtil.newDOMBuilder().newDocument();
    }

    private static DocumentBuilder newDOMBuilder() {
        if (domBuilderFactory == null) {
            domBuilderFactory = DocumentBuilderFactory.newInstance();
        }
        try {
            return domBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw XError.makeError("XML-DOM\u89e3\u6790\u5668\u914d\u7f6e\u9519\u8bef", ex);
        }
    }

    public static void parseXml(InputSource xml, DefaultHandler handler) throws SAXException, IOException, ParserConfigurationException, FactoryConfigurationError {
        XmlUtil.newSAXParser().parse(xml, handler);
    }

    public static Element readXmlFile(String filePath) throws SAXException, IOException {
        File f = new File(filePath);
        return XmlUtil.newDOMBuilder().parse(f).getDocumentElement();
    }

    public static Element readXmlStream(InputStream in) throws SAXException, IOException {
        return XmlUtil.newDOMBuilder().parse(in).getDocumentElement();
    }

    public static Element readXmlText(String s) throws SAXException, IOException {
        StringReader sr = new StringReader(s);
        return XmlUtil.newDOMBuilder().parse(new InputSource(sr)).getDocumentElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeXmlFile(Element xml, String filePath) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filePath);
            XmlUtil.writeXmlStream(xml, fos);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void writeXmlStream(Element xml, OutputStream out) throws IOException {
        XMLOutputter xmlWriter = new XMLOutputter(Format.getPrettyFormat());
        xmlWriter.output(xml, out);
    }

    public static String writeXmlText(Element xml) throws IOException {
        XMLOutputter xmlOutput = new XMLOutputter(Format.getPrettyFormat());
        return xmlOutput.outputString(xml);
    }

    public static Element writeObject(Document doc, Object obj) {
        Class<?> cls = obj.getClass();
        Element xml = doc.createElement("Bean");
        xml.setAttribute("class", cls.getName());
        BeanProperty[] props = BeanUtil.makeProperties(cls);
        for (int i = 0; i < props.length; ++i) {
            XmlUtil.writeProperty(obj, props[i], xml);
        }
        return xml;
    }

    public static void writeProperty(Object obj, BeanProperty prop, Element xml) {
        Class type = prop.getType();
        Object val = prop.getValue(obj);
        if (val == null) {
            xml.setAttribute(prop.getName(), "null");
        }
        if (String.class.equals((Object)type)) {
            xml.setAttribute(prop.getName(), (String)val);
        } else if (Integer.TYPE.equals(type) || Integer.class.equals((Object)type)) {
            xml.setAttribute(prop.getName(), ((Integer)val).toString());
        } else if (Short.TYPE.equals(type) || Short.class.equals((Object)type)) {
            xml.setAttribute(prop.getName(), ((Short)val).toString());
        } else if (Byte.TYPE.equals(type) || Byte.class.equals((Object)type)) {
            xml.setAttribute(prop.getName(), ((Byte)val).toString());
        } else if (Long.TYPE.equals(type) || Long.class.equals((Object)type)) {
            xml.setAttribute(prop.getName(), ((Long)val).toString());
        } else if (Double.TYPE.equals(type) || Double.class.equals((Object)type)) {
            xml.setAttribute(prop.getName(), ((Double)val).toString());
        } else if (Float.TYPE.equals(type) || Float.class.equals((Object)type)) {
            xml.setAttribute(prop.getName(), ((Float)val).toString());
        } else if (Boolean.TYPE.equals(type) || Boolean.class.equals((Object)type)) {
            xml.setAttribute(prop.getName(), ((Boolean)val).toString());
        } else if (Date.class.equals((Object)type)) {
            xml.setAttribute(prop.getName(), ((Date)val).toString());
        } else if (type.isAssignableFrom(AEnum.class)) {
            xml.setAttribute(prop.getName(), ((AEnum)val).getName());
        }
    }

    public static void writeAttribute(Writer wr, String name, String val) throws IOException {
        if (val != null) {
            wr.write(" ");
            wr.write(name);
            wr.write("=\"");
            wr.write(val);
            wr.write("\"");
        }
    }

    public static void escapeText(StringBuffer sb, char[] ch, int start, int length) {
        int z = start + length;
        block6: for (int i = start; i < z; ++i) {
            char c = ch[i];
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
    }

    public static String escapeText(String s) {
        StringBuffer sb = null;
        String esc = null;
        int z = s.length();
        for (int i = 0; i < z; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    esc = "&lt;";
                    break;
                }
                case '>': {
                    esc = "&gt;";
                    break;
                }
                case '&': {
                    esc = "&amp;";
                    break;
                }
                case '\"': {
                    esc = "&quot;";
                    break;
                }
            }
            if (esc != null) {
                if (sb == null) {
                    sb = new StringBuffer();
                    if (i > 0) {
                        sb.append(s.substring(0, i));
                    }
                }
                sb.append(esc);
                esc = null;
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        return sb != null ? sb.toString() : s;
    }
}

