/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.barcode;

import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.print.util.KDPrinterUtils;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.PageContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.renderer.AbstractObjectRenderer;
import com.kingdee.bos.ctrl.reportone.r1.print.barcode.BarcodeBindSource;
import com.kingdee.bos.ctrl.reportone.r1.print.barcode.BarcodeObject;
import com.kingdee.bos.ctrl.reportone.r1.print.barcode.painter.BarcodeUtils;
import com.kingdee.bos.ctrl.reportone.r1.print.common.R1PrintStringRender;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BarcodeRenderer
extends AbstractObjectRenderer {
    private BarcodeObject barcodeObject;

    @Override
    public void setReportObject(IReportObject obj) {
        this.barcodeObject = (BarcodeObject)obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(Graphics graphics, PageContainer c) {
        Rectangle rect = new Rectangle(this.barcodeObject.getX(), this.barcodeObject.getY(), this.barcodeObject.getWidth(), this.barcodeObject.getHeight());
        StyleAttributes sa = this.barcodeObject.getStyleAttribute() == null ? Styles.getDefaultSA() : Styles.getSA((StyleAttributes)this.barcodeObject.getStyleAttribute());
        sa.setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        sa.setVerticalAlign(Styles.VerticalAlignment.MIDDLE);
        Style style = Styles.getStyle((ShareStyleAttributes)sa);
        if (this.barcodeObject.isShowSample() && graphics instanceof Graphics2D) {
            Map config = this.generateConfig();
            double dpi = this.barcodeObject.getDpi();
            double scale = dpi / (double)KDPrinterUtils.SCREEN_RESOLUTION;
            Graphics2D g2 = (Graphics2D)graphics;
            g2.translate(BarcodeRenderer.floor(rect.getX()), BarcodeRenderer.floor(rect.getY()));
            g2.scale(1.0 / scale, 1.0 / scale);
            try {
                int width = BarcodeRenderer.floor(rect.getWidth() * scale);
                int height = BarcodeRenderer.floor(rect.getHeight() * scale);
                config.put("width", width);
                config.put("height", height);
                BarcodeUtils.paintBarcode(graphics, width, height, config);
            }
            finally {
                g2.scale(scale, scale);
                g2.translate(-BarcodeRenderer.floor(rect.getX()), -BarcodeRenderer.floor(rect.getY()));
            }
        } else {
            R1PrintStringRender r1Render = R1PrintStringRender.getKeepClipInstance();
            List<BarcodeBindSource> list = this.barcodeObject.getFields();
            for (int i = 0; i < list.size(); ++i) {
                BarcodeBindSource bbs = list.get(i);
                String text = bbs.toDrawString();
                if (i * 15 >= this.barcodeObject.getHeight()) continue;
                rect = new Rectangle(this.barcodeObject.getX(), this.barcodeObject.getY() - this.barcodeObject.getHeight() / 2 + 5 + i * 15, this.barcodeObject.getWidth(), this.barcodeObject.getHeight());
                r1Render.drawText(graphics, rect, text, style, text);
            }
        }
        BarcodeRenderer.drawDashBorder(graphics, rect);
        this.drawBorder(graphics, rect, style);
    }

    private Map generateConfig() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("barcode", this.barcodeObject.getSampleTxt());
        config.put("dpi", this.barcodeObject.getDpi());
        config.put("modelWidth", this.barcodeObject.getModelWidth());
        config.put("barHeight", this.barcodeObject.getBarHeight());
        config.put("shape", this.barcodeObject.getShape());
        if (this.barcodeObject.getScale() == 3) {
            config.put("autoMatch", true);
        } else {
            config.put("autoMatch", false);
        }
        config.put("barcodeType", this.barcodeObject.getBarcodeType());
        config.put("showSample", true);
        config.put("fontSize", this.barcodeObject.getFontSize());
        return config;
    }

    private static int floor(Double d) {
        return (int)Math.floor(d);
    }

    static void drawDashBorder(Graphics g, Rectangle rect) {
        int offsetY;
        int offsetX;
        Color oldColor = g.getColor();
        g.setColor(Color.GRAY);
        if (rect.width < rect.height) {
            offsetX = 10;
            offsetY = 10;
        } else {
            offsetX = 10;
            offsetY = 10;
        }
        int x1 = rect.x;
        int y1 = rect.y;
        int x2 = rect.x + rect.width - 1;
        int y2 = rect.y + rect.height - 1;
        g.drawLine(x1, y1, x1 + offsetX, y1);
        g.drawLine(x1, y1, x1, y1 + offsetY);
        g.drawLine(x2, y1, x2 - offsetX, y1);
        g.drawLine(x2, y1, x2, y1 + offsetY);
        g.drawLine(x1, y2, x1, y2 - offsetY);
        g.drawLine(x1, y2, x1 + offsetX, y2);
        g.drawLine(x2, y2, x2 - offsetX, y2);
        g.drawLine(x2, y2, x2, y2 - offsetY);
        int x3 = x1 + (rect.width - offsetX - 1) / 2;
        int y3 = y1 + (rect.height - offsetY - 1) / 2;
        g.drawLine(x3, y1, x3 + offsetX, y1);
        g.drawLine(x3, y2, x3 + offsetX, y2);
        g.drawLine(x1, y3, x1, y3 + offsetY);
        g.drawLine(x2, y3, x2, y3 + offsetY);
        g.setColor(oldColor);
    }
}

