/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.barcode;

import com.kingdee.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.krysalis.barcode4j.impl.AbstractBarcodeBean;
import org.krysalis.barcode4j.impl.code128.EAN128Bean;
import org.krysalis.barcode4j.impl.upcean.EAN13Bean;
import org.krysalis.barcode4j.impl.upcean.EAN8Bean;
import org.krysalis.barcode4j.output.CanvasProvider;
import org.krysalis.barcode4j.output.bitmap.BitmapCanvasProvider;
import org.krysalis.barcode4j.tools.UnitConv;

public class EAN128Util {
    public static byte[] generate(String msg, String type, Map config) {
        ByteArrayOutputStream ous = new ByteArrayOutputStream();
        EAN128Util.generate(msg, type, ous, config);
        return ous.toByteArray();
    }

    public static void generate(String msg, String type, OutputStream ous, Map config) {
        EAN128Bean bean;
        EAN128Bean obj = null;
        if (StringUtils.isEmpty((String)msg) || ous == null) {
            return;
        }
        if (type.equals("ean-128")) {
            obj = bean = new EAN128Bean();
        } else if (type.equals("ean-13")) {
            obj = bean = new EAN13Bean();
        } else if (type.equals("ean-8")) {
            obj = bean = new EAN8Bean();
        }
        int dpi = (Integer)config.get("dpi");
        double moduleWidth = UnitConv.in2mm((double)(2.0f / (float)dpi));
        ((AbstractBarcodeBean)obj).setModuleWidth(moduleWidth);
        ((AbstractBarcodeBean)obj).doQuietZone(false);
        String format = "image/png";
        try {
            BitmapCanvasProvider canvas = new BitmapCanvasProvider(ous, format, dpi, 12, false, 0);
            ((AbstractBarcodeBean)obj).generateBarcode((CanvasProvider)canvas, msg);
            canvas.finish();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

