/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.common;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StreamUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.util.BMPReader;
import com.kingdee.util.Base64Encoder;
import java.awt.Image;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class ImageUtil {
    public static final Logger log = LogUtil.getLogger(ImageUtil.class);

    public static Image getImage(String str) {
        byte[] bytes = ImageUtil.getImageByteContent(str);
        if (bytes != null) {
            return ImageUtil.makeImage(bytes);
        }
        return null;
    }

    public static final Image makeImage(byte[] data) {
        if (data.length > 1 && data[0] == 66 && data[1] == 77) {
            return BMPReader.loadBitMap((byte[])data);
        }
        return new ImageIcon(data).getImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getImageByteContent(String str) {
        if (!StringUtil.isEmptyString((String)str)) {
            if (str.startsWith("data:image")) {
                return Base64Encoder.base64ToByteArray((String)str.substring(str.indexOf("base64,") + 7));
            }
            String filePath = str;
            if (str.startsWith("file://")) {
                filePath = str.substring(7);
            }
            InputStream in = null;
            byte[] content = null;
            try {
                in = new FileInputStream(new File(filePath));
                byte[] byArray = content = StreamUtil.readInputStream((InputStream)in);
                return byArray;
            }
            catch (FileNotFoundException e) {
                log.error((Object)("The file below is not found: " + filePath), (Throwable)e);
                byte[] byArray = null;
                return byArray;
            }
            catch (IOException e1) {
                log.error((Object)"Read Picture I/O error.", (Throwable)e1);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return null;
        }
        return null;
    }
}

