/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid;

import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.Field;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.IBind;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ICompositeContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ICompositeObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IElement;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IPropertyUnsupported;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractCell;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractColumn;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.IGridsFactory;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractDataGrid;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractDetailRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractGroupRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractNormalRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.CellField;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.StatField;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.Text;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.merge.MergeBlock;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.exception.R1DesignerRuntimeException;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.property.check.ReportEleErrorInfo;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.ruler.IR1Ruler;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.renderer.IReportObjectRenderer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.renderer.selection.GridElementSelectionRenderer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.renderer.selection.ICompositeSelectionRenderer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.ContainerUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.Util;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.util.GridLayoutUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.data.R1PrintBindDataSource;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGridCell;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGridDetailRow;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGridFactory;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.IDataGridRow;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.IDisplayEveryPage;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.icon.R1PrintIcons;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.renderer.DataGridRenderer;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.R1PrintConstant;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;

public class DataGrid
extends AbstractDataGrid
implements ICompositeContainer,
IPropertyUnsupported {
    public DataGrid() {
        this.setPrint(true);
    }

    @Override
    protected IReportObjectRenderer createRenderer() {
        return new DataGridRenderer();
    }

    @Override
    public boolean isSubElementCanRemove(IElement ele) {
        if (ele instanceof AbstractColumn && this.getColumnsCount() < 2) {
            return false;
        }
        if (ele instanceof AbstractRow) {
            if (this.getRowsCount() < 2) {
                return false;
            }
            if (((IDataGridRow)((Object)ele)).isBackwardForward()) {
                return true;
            }
            if (ele instanceof AbstractDetailRow) {
                return this.isMoreThanOneDetailRow();
            }
            if (ele instanceof AbstractGroupRow) {
                return true;
            }
            return true;
        }
        return super.isSubElementCanRemove(ele);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean removeSubElement(IElement ele) {
        if (!(ele instanceof AbstractRow)) return super.removeSubElement(ele);
        if (((IDataGridRow)((Object)ele)).isBackwardForward()) {
            return this.removeRow((AbstractRow)ele);
        }
        if (ele instanceof AbstractDetailRow) {
            if (!this.isMoreThanOneDetailRow()) return false;
            return this.removeRow((AbstractRow)ele);
        }
        if (!(ele instanceof AbstractGroupRow)) return this.removeRow((AbstractRow)ele);
        return this.deleteGroupRow((AbstractGroupRow)ele);
    }

    private boolean deleteGroupRow(AbstractGroupRow row) {
        int endLoop;
        int startLoop;
        if (this.isNextRowSameGroup(row)) {
            return this.removeRow(row);
        }
        int idx = this.getIndexOfRow(row);
        int idxDetail = this.getIndexOfDetailRow();
        boolean isDeleted = false;
        if (idx > idxDetail) {
            startLoop = idxDetail - 1;
            endLoop = 0;
        } else {
            int symmetryGroupLastIdx = -1;
            int c = this.getRowsCount();
            for (int i = idxDetail + 1; i < c; ++i) {
                if (this.isSameGroup(row, this.getRow(i))) {
                    symmetryGroupLastIdx = i;
                    continue;
                }
                if (symmetryGroupLastIdx != -1) break;
            }
            startLoop = symmetryGroupLastIdx;
            endLoop = idxDetail + 1;
        }
        for (int i = startLoop; i >= endLoop; --i) {
            if (!this.isSameGroup(row, this.getRow(i))) continue;
            this.removeRow(this.getRow(i));
            isDeleted = true;
        }
        if (isDeleted) {
            this.removeRow(row);
            return true;
        }
        return false;
    }

    public int getIndexOfDetailRow() {
        for (int i = 0; i < this.getRowsCount(); ++i) {
            AbstractRow row = this.getRow(i);
            if (!(row instanceof AbstractDetailRow) || ((IDataGridRow)((Object)row)).isBackwardForward()) continue;
            return i;
        }
        throw new R1DesignerRuntimeException("The DataGrid has no DetailRow. It's invalid.");
    }

    private boolean isNextRowSameGroup(AbstractGroupRow groupRow) {
        int idx = this.getIndexOfRow(groupRow);
        if (idx > 0 && this.isSameGroup(groupRow, this.getRow(idx - 1))) {
            return true;
        }
        return idx < this.getRowsCount() - 1 && this.isSameGroup(groupRow, this.getRow(idx + 1));
    }

    private boolean isSameGroup(AbstractGroupRow targetRow, AbstractRow compareRow) {
        if (compareRow instanceof AbstractGroupRow) {
            return targetRow.getGroup() == ((AbstractGroupRow)compareRow).getGroup();
        }
        return false;
    }

    private boolean isMoreThanOneDetailRow() {
        return false;
    }

    @Override
    public int[] locateDetailRow() {
        int[] ab = new int[2];
        ab[1] = -1;
        boolean isBefore = true;
        int c = this.getRowsCount();
        for (int i = 0; i < c; ++i) {
            if (isBefore && this.getRow(i) instanceof AbstractDetailRow) {
                ab[0] = i;
                isBefore = false;
                continue;
            }
            if (isBefore || this.getRow(i) instanceof AbstractDetailRow) continue;
            ab[1] = i;
            break;
        }
        if (ab[1] < 0) {
            ab[1] = c;
        }
        return ab;
    }

    @Override
    public IBind.IBindDataSource getDataSource() {
        if (this._bindDs == null) {
            this._bindDs = new R1PrintBindDataSource();
        }
        return this._bindDs;
    }

    @Override
    public String getType() {
        return R1PrintConstant.Node_DataGrid;
    }

    @Override
    public boolean isDraggedCanBind(MetaClass mc, MetaField mf, IElement subElement) {
        return mc != null && mf != null && subElement instanceof DataGridCell;
    }

    @Override
    public void bindDraggedData(String dsName, MetaField mf, IElement subElement, JComponent ctrl, String promptTitle, MouseEvent mouseEvent) {
        if (!StringUtil.isEmptyString((String)this.getDataSource().getDs()) && !StringUtil.equals((String)this.getDataSource().getDs(), (String)dsName)) {
            StringBuffer sb = new StringBuffer();
            sb.append(MultiLanguageUtil.getMLS("datagrid.DataGrid.yesOrNo1", ""));
            sb.append(this.getDataSource().getDs());
            sb.append(MultiLanguageUtil.getMLS("datagrid.DataGrid.yesOrNo2", ""));
            sb.append(dsName);
            sb.append("\uff0c");
            sb.append(MultiLanguageUtil.getMLS("datagrid.DataGrid.yesOrNo3", ""));
            sb.append(MultiLanguageUtil.getMLS("datagrid.DataGrid.yesOrNo4", ""));
            boolean result = WindowUtil.msgboxYesNo((Component)ctrl, (Object)sb.toString(), (String)promptTitle);
            if (!result) {
                return;
            }
        }
        DataGridCell cell = (DataGridCell)subElement;
        this.getDataSource().setDs(dsName);
        if (mouseEvent.isControlDown()) {
            StatField stat = new StatField();
            if (DataType.isNumberType((DataType)mf.getType())) {
                stat.setType(1);
            } else {
                stat.setType(5);
            }
            stat.setField(Field.fromMetaField(mf));
            cell.setValue(stat);
        } else if (mouseEvent.isShiftDown()) {
            cell.setValue(new Text(mf.getAliasName()));
        } else {
            cell.setValue(CellField.create(Field.fromMetaField(mf)));
        }
    }

    @Override
    public String getIdPrefix() {
        return "dataGrid";
    }

    @Override
    public void initTreeNode(DefaultKingdeeTreeNode node) {
        node.setCustomIcon((Icon)R1PrintIcons.SEC_GRID);
    }

    @Override
    public String getTypePrompt() {
        return MultiLanguageUtil.getMLS("datagrid.DataGrid.typePrompt", "");
    }

    @Override
    public int getHeightLom() {
        return Util.pixel2Lom(this.getFeatHeight());
    }

    @Override
    public int getFeatHeight() {
        return this.addRowHeight(0, this.getRowsCount());
    }

    private int addRowHeight(int fromIdx, int toIdx) {
        int h = 0;
        for (int i = fromIdx; i < toIdx; ++i) {
            AbstractRow row = this.getRow(i);
            h += row.getFeatHeight() * this.getRowDrawingTimes(row);
        }
        return h;
    }

    @Override
    public int getRowDrawingTimes(AbstractRow row) {
        if (row instanceof DataGridDetailRow) {
            int times = ((DataGridDetailRow)row).getRepeatTimes();
            if (times == 0) {
                return 1;
            }
            AbstractRow[] bfRows = this.getBackwardForwardRow();
            if (bfRows[0] instanceof DataGridDetailRow) {
                --times;
            }
            if (bfRows[1] instanceof DataGridDetailRow) {
                --times;
            }
            return times > 0 ? times : 1;
        }
        return 1;
    }

    @Override
    public void setHeightLom(int height) {
        int old = this._heightLom;
        this._heightLom = height;
        GridLayoutUtil.layoutPrintGridHeight(this, this._heightLom);
        this.firePropertyChange("heightLom", old, height);
    }

    @Override
    public int getWidthLom() {
        int w = 0;
        int colCnt = this.getColumnsCount();
        for (int j = 0; j < colCnt; ++j) {
            w += this.getColumn(j).getFeatWidth();
        }
        return Util.pixel2Lom(w);
    }

    @Override
    public void setWidthLom(int width) {
        int old = this._widthLom;
        this._widthLom = width;
        GridLayoutUtil.layoutWidth(this, this._widthLom);
        this.firePropertyChange("widthLom", old, width);
    }

    @Override
    public Point getRelativePosition(IElement ele) {
        Point rowColIdx = new Point(0, 0);
        if (ele instanceof AbstractCell) {
            rowColIdx = this.getIndexOfCell((AbstractCell)ele);
        } else if (ele instanceof AbstractRow) {
            rowColIdx.x = this.getIndexOfRow((AbstractRow)ele);
        } else if (ele instanceof AbstractColumn) {
            rowColIdx.y = this.getIndexOfColumn((AbstractColumn)ele);
        }
        int y = this.addRowHeight(0, rowColIdx.x);
        int x = 0;
        for (int j = 0; j < rowColIdx.y; ++j) {
            x += this.getColumn(j).getFeatWidth();
        }
        return new Point(x + this.getOffsetX(), y + this.getOffsetY());
    }

    @Override
    public Rectangle getSubElementRectangle(IElement ele) {
        Rectangle rect = new Rectangle();
        Point pt = this.getRelativePosition(ele);
        if (ele instanceof AbstractCell) {
            Point rowColIdx = this.getIndexOfCell((AbstractCell)ele);
            rect.x = pt.x;
            rect.y = pt.y;
            MergeBlock mb = ((AbstractCell)ele).getMergeBlock();
            if (mb != null && mb.isFirstCell(rowColIdx.x, rowColIdx.y)) {
                rect.width = mb.getBlockWidth(this);
                rect.height = mb.getBlockHeight(this);
            } else {
                rect.width = this.getColumn(rowColIdx.y).getFeatWidth();
                rect.height = this.getRow(rowColIdx.x).getFeatHeight();
            }
        } else if (ele instanceof AbstractRow) {
            int r = this.getIndexOfRow((AbstractRow)ele);
            rect.x = this.getOffsetX();
            rect.y = pt.y;
            rect.width = this.getFeatWidth();
            rect.height = this.getRow(r).getFeatHeight();
        } else if (ele instanceof AbstractColumn) {
            int c = this.getIndexOfColumn((AbstractColumn)ele);
            rect.x = pt.x;
            rect.y = this.getOffsetY();
            rect.width = this.getColumn(c).getFeatWidth();
            rect.height = this.getFeatHeight();
        }
        return rect;
    }

    protected int getIndexOfRowByPoint(int pixelYAtGrid) {
        if (pixelYAtGrid < 0) {
            return -1;
        }
        int h = this.getOffsetY();
        int rowCnt = this.getRowsCount();
        for (int i = 0; i < rowCnt; ++i) {
            AbstractRow row = this.getRow(i);
            if (pixelYAtGrid >= (h += row.getFeatHeight() * this.getRowDrawingTimes(row))) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected int getIndexOfColumnByPoint(int pixelXAtGrid) {
        if (pixelXAtGrid < 0) {
            return -1;
        }
        int w = this.getOffsetX();
        int colCnt = this.getColumnsCount();
        for (int j = 0; j < colCnt; ++j) {
            if (pixelXAtGrid >= (w += this.getColumn(j).getFeatWidth())) continue;
            return j;
        }
        return -1;
    }

    @Override
    public boolean mouseMoved(MouseEvent evt, Point ptAtPage) {
        int colIdx;
        int rowIdx;
        Point gridAtPage = ContainerUtil.getPointAtPage(this);
        Point ptAtGrid = new Point(ptAtPage);
        ptAtGrid.translate(-gridAtPage.x, -gridAtPage.y);
        if (this.isNearEnough(ptAtGrid.x, 0) && (rowIdx = this.getIndexOfRowByPoint(ptAtGrid.y)) >= 0) {
            this._gridMouseOperateState.setOperate(48);
            this._gridMouseOperateState.setTargetLineIdx(rowIdx);
            return true;
        }
        if (this.isNearEnough(ptAtGrid.y, 0) && (colIdx = this.getIndexOfColumnByPoint(ptAtGrid.x)) >= 0) {
            this._gridMouseOperateState.setOperate(64);
            this._gridMouseOperateState.setTargetLineIdx(colIdx);
            return true;
        }
        if (ptAtGrid.y < Math.min(this.getOffsetY() + this.getFeatHeight(), this.getFeatHeight()) && ptAtGrid.y > 0) {
            int w = this.getOffsetX();
            int colCnt = this.getColumnsCount();
            if (this.isKeepParentSize(true, evt.isControlDown())) {
                --colCnt;
            }
            for (int j = 0; j < colCnt; ++j) {
                if (!this.isNearEnough(ptAtGrid.x, w += this.getColumn(j).getFeatWidth())) continue;
                this._gridMouseOperateState.setOperate(16);
                this._gridMouseOperateState.setTargetLineIdx(j + 1);
                return true;
            }
        }
        if (ptAtGrid.x < Math.min(this.getOffsetX() + this.getFeatWidth(), this.getFeatWidth()) && ptAtGrid.x > 0) {
            int h = this.getOffsetY();
            int rowCnt = this.getRowsCount();
            if (this.isKeepParentSize(false, evt.isControlDown())) {
                --rowCnt;
            }
            for (int i = 0; i < rowCnt; ++i) {
                AbstractRow row = this.getRow(i);
                if (i > 0 && this.getRow(i - 1) instanceof DataGridDetailRow) {
                    DataGridDetailRow dRow = (DataGridDetailRow)this.getRow(i - 1);
                    h += (this.getRowDrawingTimes(dRow) - 1) * dRow.getFeatHeight() + row.getFeatHeight();
                } else {
                    h += row.getFeatHeight();
                }
                if (!this.isNearEnough(ptAtGrid.y, h)) continue;
                this._gridMouseOperateState.setOperate(32);
                this._gridMouseOperateState.setTargetLineIdx(i + 1);
                return true;
            }
        }
        this._gridMouseOperateState.setOperate(0);
        return false;
    }

    @Override
    protected Rectangle getAdjustingLine(Point delta, boolean isKeepParentSize) {
        int idx = this._gridMouseOperateState.getTargetLineIdx();
        if (this._gridMouseOperateState.isHorizontalAdjust()) {
            int w = 0;
            for (int j = 0; j < idx; ++j) {
                w += this.getColumn(j).getFeatWidth();
            }
            int rectW = 0;
            if (!isKeepParentSize) {
                rectW = this.getFeatWidth() - w;
            }
            return new Rectangle(w + delta.x + this.getOffsetX(), this.getOffsetY(), rectW, this.getHeight());
        }
        if (this._gridMouseOperateState.isVerticalAdjust()) {
            int h = 0;
            for (int i = 0; i < idx; ++i) {
                AbstractRow row = this.getRow(i);
                if (i > 0 && this.getRow(i - 1) instanceof DataGridDetailRow) {
                    DataGridDetailRow dRow = (DataGridDetailRow)this.getRow(i - 1);
                    h += (this.getRowDrawingTimes(dRow) - 1) * dRow.getFeatHeight() + row.getFeatHeight();
                    continue;
                }
                h += this.getRow(i).getFeatHeight();
            }
            int rectH = 0;
            if (!isKeepParentSize) {
                rectH = this.getHeight() - h;
            }
            return new Rectangle(this.getOffsetX(), h + delta.y + this.getOffsetY(), this.getFeatWidth(), rectH);
        }
        return null;
    }

    @Override
    public void mouseDragged(Graphics g, MouseEvent evt, Point dragStartPoint, IR1Ruler hRuler, IR1Ruler vRuler) {
        if (this._gridMouseOperateState.isHorizontalAdjust() || this._gridMouseOperateState.isVerticalAdjust()) {
            this.adjustLine(g, dragStartPoint, evt.getPoint(), false, evt.isControlDown(), hRuler, vRuler);
        }
    }

    @Override
    protected IGridsFactory getGridsFactory() {
        return DataGridFactory.getPrintDataGridFactory();
    }

    @Override
    public ICompositeSelectionRenderer getInnerSelectionRenderer() {
        GridElementSelectionRenderer r = new GridElementSelectionRenderer();
        r.setCompositeObject(this);
        return r;
    }

    public AbstractRow[] getBackwardForwardRow() {
        AbstractRow[] rows = new AbstractRow[2];
        boolean isBeforeDetail = true;
        int c = this.getRowsCount();
        for (int i = 0; i < c; ++i) {
            AbstractRow row = this.getRow(i);
            if (((IDataGridRow)((Object)row)).isBackwardForward()) {
                if (isBeforeDetail) {
                    rows[0] = row;
                    continue;
                }
                rows[1] = row;
                break;
            }
            if (!(row instanceof AbstractDetailRow)) continue;
            isBeforeDetail = false;
        }
        return rows;
    }

    @Override
    public String[] getPropertyPanelKeys(ICompositeObject co) {
        return new String[]{"dataGrid", "style", "border", "objectCommon"};
    }

    @Override
    public void layoutAllSubContainer() {
        IContainer[] subContainers = this.getSubContainers();
        for (int i = 0; i < subContainers.length; ++i) {
            IContainer c = subContainers[i];
            if (c.getChildrenCount() <= 0) continue;
            for (IReportObject ro : c.getChildren()) {
                if (ro.isHorizontalFill()) {
                    ro.setXLom(0);
                    ro.setWidthLom(this.getSubContainerInsetsWidthLom(c));
                }
                if (ro.isVerticalFill()) {
                    ro.setYLom(0);
                    ro.setHeightLom(this.getSubContainerInsetsHeightLom(c));
                }
                if (ro instanceof IContainer) {
                    ((IContainer)((Object)ro)).layout();
                    continue;
                }
                if (!(ro instanceof ICompositeContainer)) continue;
                ((ICompositeContainer)((Object)ro)).layoutAllSubContainer();
            }
        }
    }

    @Override
    public IContainer[] getSubContainers() {
        return this.getCellsList().toArray(new IContainer[0]);
    }

    @Override
    public void addChild(IContainer subElement, IReportObject child) {
        if (!(subElement instanceof AbstractCell)) {
            throw new IllegalArgumentException("SubElement must be Cell");
        }
        subElement.addChild(child, null);
        ElementPath elementPath = this.makeElementPath((AbstractCell)((Object)subElement));
        child.setParent(elementPath);
    }

    @Override
    public void removeChild(IContainer subElement, IReportObject child) {
        subElement.removeChild(child);
        child.setParent(null);
    }

    @Override
    public int getSubContainerInsetsWidthLom(IContainer subElement) {
        AbstractCell cell = (AbstractCell)((Object)subElement);
        int w = this.getCellWidthLom(cell);
        Style style = cell.getStyle();
        if (style != null) {
            return w - style.getPadding().getLeft() - style.getPadding().getRight();
        }
        return w;
    }

    @Override
    public int getSubContainerInsetsHeightLom(IContainer subElement) {
        AbstractCell cell = (AbstractCell)((Object)subElement);
        int h = this.getCellHeightLom(cell);
        Style style = cell.getStyle();
        if (style != null) {
            return h - style.getPadding().getTop() - style.getPadding().getBottom();
        }
        return h;
    }

    private int getCellHeightLom(AbstractCell cell) {
        MergeBlock mb = cell.getMergeBlock();
        if (mb != null) {
            return mb.getBlockHeightLom(this);
        }
        int rowIdx = this.getIndexOfCell((AbstractCell)cell).x;
        return this.getRow(rowIdx).getHeightLom();
    }

    private int getCellWidthLom(AbstractCell cell) {
        MergeBlock mb = cell.getMergeBlock();
        if (mb != null) {
            return mb.getBlockWidthLom(this);
        }
        int colIdx = this.getIndexOfCell((AbstractCell)cell).y;
        return this.getColumn(colIdx).getWidthLom();
    }

    @Override
    protected int getRowChildrenMinRemain(int rowIdx) {
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < this.getColumnsCount(); ++i) {
            DataGridCell cell = (DataGridCell)this.getCell(rowIdx, i);
            MergeBlock mb = cell.getMergeBlock();
            if (mb != null && !mb.isFirstCell(rowIdx, i)) {
                cell = (DataGridCell)this.getCell(mb.getTop(), mb.getLeft());
            }
            int bottom = ContainerUtil.searchChildrenMaxBottom(cell);
            int remain = this.getSubContainerInsetsHeightLom(cell) - bottom;
            if (remain >= min) continue;
            min = remain;
        }
        if (min == Integer.MAX_VALUE) {
            min = this.getRow(rowIdx).getHeightLom();
        }
        return min;
    }

    @Override
    protected int getColumnChildrenMinRemain(int colIdx) {
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < this.getRowsCount(); ++i) {
            DataGridCell cell = (DataGridCell)this.getCell(i, colIdx);
            MergeBlock mb = cell.getMergeBlock();
            if (mb != null && !mb.isFirstCell(i, colIdx)) {
                cell = (DataGridCell)this.getCell(mb.getTop(), mb.getLeft());
            }
            int right = ContainerUtil.searchChildrenMaxRight(cell);
            int remain = this.getSubContainerInsetsWidthLom(cell) - right;
            if (remain >= min) continue;
            min = remain;
        }
        if (min == Integer.MAX_VALUE) {
            min = this.getColumn(colIdx).getWidthLom();
        }
        return min;
    }

    @Override
    public void afterAdjusted() {
        this.layoutAllSubContainer();
    }

    @Override
    public List getUnsupportedPropertyKeys() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("noprint");
        return result;
    }

    @Override
    public boolean isVerticalResizable() {
        return false;
    }

    @Override
    public ReportEleErrorInfo checkProperty() {
        ReportEleErrorInfo info = super.checkProperty() != null ? super.checkProperty() : new ReportEleErrorInfo(this);
        if (((DataGridDetailRow)this.getRow(this.getIndexOfDetailRow())).getRepeatTimes() != 0) {
            int c = this.getRowsCount();
            for (int i = 0; i < c; ++i) {
                AbstractRow row = this.getRow(i);
                if (!(row instanceof IDisplayEveryPage) || ((IDisplayEveryPage)((Object)row)).isDisplayEveryPage()) continue;
                if (row instanceof AbstractGroupRow) {
                    info.addInfo(MultiLanguageUtil.getMLS("datagrid.DataGrid.info1", "") + row.getId() + MultiLanguageUtil.getMLS("datagrid.DataGrid.info2", ""));
                    continue;
                }
                if (!(row instanceof AbstractNormalRow)) continue;
                info.addInfo(MultiLanguageUtil.getMLS("datagrid.DataGrid.info3", "") + row.getId() + MultiLanguageUtil.getMLS("datagrid.DataGrid.info2", ""));
            }
        }
        if (info.getInfosSize() > 0) {
            return info;
        }
        return null;
    }
}

