/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.property;

import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.DataExtend;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.Field;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.IBind;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.IR1DataManager;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.ComboPanel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.property.AbstractPropertyPanel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.common.ImageUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.PictureObject;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDOptionPane;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;

public class PanelPicture
extends AbstractPropertyPanel {
    private IR1DataManager dm;
    private KDRadioButton radBind;
    private KDRadioButton radCustom;
    private KDComboBox cmbBindDs;
    private KDComboBox cmbBindField;
    private KDWorkButton btnPicSource;
    private KDLabel labPicSource;
    private KDComboBox cmbScale;
    private boolean isPicSourceEdited;

    public PanelPicture() {
        this.init();
        this.installListener();
    }

    protected void init() {
        this.radBind = new KDRadioButton(MultiLanguageUtil.getMLS("property.PanelPicture.bind", "\u7ed1\u5b9a"));
        this.radCustom = new KDRadioButton(MultiLanguageUtil.getMLS("property.PanelPicture.selfDefine", "\u81ea\u5b9a\u4e49"));
        ButtonGroup bg = new ButtonGroup();
        bg.add((AbstractButton)this.radBind);
        bg.add((AbstractButton)this.radCustom);
        this.cmbBindDs = new KDComboBox();
        this.cmbBindField = new KDComboBox();
        KDLabelContainer lbcBindData = CtrlSwingUtilities.createLabelContainer((JComponent)this.cmbBindDs, (String)MultiLanguageUtil.getMLS("property.PanelPicture.dataSource", "\u6570\u636e\u6e90"), (int)100);
        KDLabelContainer lbcBindFiled = CtrlSwingUtilities.createLabelContainer((JComponent)this.cmbBindField, (String)MultiLanguageUtil.getMLS("property.PanelPicture.field", "\u5b57\u6bb5"), (int)100);
        this.btnPicSource = new KDWorkButton(MultiLanguageUtil.getMLS("property.PanelPicture.choosePicture", "\u9009\u62e9\u56fe\u7247"));
        this.labPicSource = new KDLabel();
        this.cmbScale = new KDComboBox((Object[])new String[]{MultiLanguageUtil.getMLS("property.PanelPicture.noZoom", "\u539f\u59cb\u5927\u5c0f"), MultiLanguageUtil.getMLS("property.PanelPicture.zoomByScale", "\u6309\u6bd4\u4f8b\u7f29\u653e")});
        KDLabelContainer lbcScale = CtrlSwingUtilities.createLabelContainer((JComponent)this.cmbScale, (String)MultiLanguageUtil.getMLS("property.PanelPicture.zoom", "\u7f29\u653e"), (int)100);
        TableLayout tl = TableLayout.split((int)6, (int)1);
        tl.style().setMargin(10, 20, 10, 10);
        tl.rowStyle(0).setHeight(19);
        tl.rowStyle(0).setMarginBottom(6);
        tl.rowStyle(1).setHeight(19);
        tl.rowStyle(1).setMarginLeft(20);
        tl.rowStyle(1).setMarginBottom(3);
        tl.rowStyle(2).setHeight(19);
        tl.rowStyle(2).setMarginLeft(20);
        tl.rowStyle(2).setMarginBottom(10);
        tl.rowStyle(3).setHeight(19);
        tl.rowStyle(3).setMarginBottom(6);
        tl.rowStyle(4).setHeight(21);
        tl.rowStyle(4).setMarginLeft(20);
        tl.rowStyle(5).setPriY(1);
        Table rowPicSource = tl.cell(4, 0).splitCol(2);
        rowPicSource.colStyle(0).setWidth(100);
        rowPicSource.colStyle(0).setMarginRight(10);
        rowPicSource.colStyle(1).setPriX(1);
        KDPanel panData = new KDPanel((LayoutManager)tl);
        panData.setBorder((Border)BorderFactory.createTitledBorder(MultiLanguageUtil.getMLS("property.PanelPicture.data", "\u6570\u636e")));
        panData.add((Component)this.radBind, (Object)tl.cell(0));
        panData.add((Component)lbcBindData, (Object)tl.cell(1));
        panData.add((Component)lbcBindFiled, (Object)tl.cell(2));
        panData.add((Component)this.radCustom, (Object)tl.cell(3));
        panData.add((Component)this.btnPicSource, (Object)rowPicSource.cell(0));
        panData.add((Component)this.labPicSource, (Object)rowPicSource.cell(1));
        TableLayout tlOwner = TableLayout.split((int)3, (int)1);
        tlOwner.rowStyle(0).setHeight(160);
        tlOwner.rowStyle(1).setHeight(20);
        tlOwner.rowStyle(1).setMargin(0, 6, 250, 0);
        tlOwner.rowStyle(2).setPriY(1);
        KDPanel panOwner = new KDPanel((LayoutManager)tlOwner);
        panOwner.add((Component)panData, (Object)tlOwner.cell(0));
        panOwner.add((Component)lbcScale, (Object)tlOwner.cell(1));
        this.setLayout(new BorderLayout());
        this.add((Component)panOwner, "Center");
    }

    private void installListener() {
        this.radBind.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelPicture.this.syncCtrlEnabled();
            }
        });
        this.radCustom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelPicture.this.syncCtrlEnabled();
            }
        });
        this.cmbBindDs.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object item = PanelPicture.this.cmbBindDs.getSelectedItem();
                String dsName = null;
                if (item instanceof DataExtend) {
                    dsName = ((DataExtend)((Object)item)).getName();
                }
                PanelPicture.this.prepareFieldSupplyValue(dsName);
            }
        });
        this.btnPicSource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int result;
                KDFileChooser fc = new KDFileChooser();
                fc.setMultiSelectionEnabled(false);
                fc.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        if (f.isDirectory()) {
                            return true;
                        }
                        String name = f.getName();
                        String ext = name.substring(name.lastIndexOf(".") + 1);
                        return "jpg".equalsIgnoreCase(ext) || "jpeg".equalsIgnoreCase(ext) || "bmp".equalsIgnoreCase(ext) || "dib".equalsIgnoreCase(ext) || "rle".equalsIgnoreCase(ext) || "gif".equalsIgnoreCase(ext) || "png".equalsIgnoreCase(ext);
                    }

                    @Override
                    public String getDescription() {
                        return "All supported image files (*.jpg;*.bmp;*.gif;*.png)";
                    }
                });
                if (!StringUtil.isEmptyString((String)PanelPicture.this.labPicSource.getText())) {
                    fc.setSelectedFile(new File(PanelPicture.this.labPicSource.getText()));
                }
                if ((result = fc.showOpenDialog((Component)((Object)PanelPicture.this))) == 0) {
                    byte[] image = ImageUtil.getImageByteContent(fc.getSelectedFile().getAbsolutePath());
                    if (image.length > 51200) {
                        Object[] options = new Object[]{MultiLanguageUtil.getMLS("property.PanelPicture.OK", "\u786e\u5b9a")};
                        KDOptionPane.showOptionDialog((Component)fc, (Object)MultiLanguageUtil.getMLS("property.PanelPicture.info", "\u56fe\u7247\u5927\u4e8e50Kb,\u5efa\u8bae\u4f7f\u7528\u5c0f\u4e8e50Kb\u7684\u56fe\u7247"), (String)MultiLanguageUtil.getMLS("property.PanelPicture.warning", "\u8b66\u544a"), (int)-1, (int)2, null, (Object[])options, (Object)options[0]);
                    }
                    PanelPicture.this.isPicSourceEdited = true;
                    PanelPicture.this.labPicSource.setText(fc.getSelectedFile().getAbsolutePath());
                }
            }
        });
    }

    private void syncCtrlEnabled() {
        this.cmbBindDs.setEnabled(this.radBind.isSelected());
        this.cmbBindField.setEnabled(this.radBind.isSelected());
        this.btnPicSource.setEnabled(this.radCustom.isSelected());
    }

    @Override
    protected void updateElementValue(ElementPath elePath) {
        PictureObject ro = (PictureObject)elePath.getLastPathComponent();
        if (this.radBind.isSelected()) {
            if (this.cmbBindDs.getSelectedIndex() >= 0) {
                DataExtend ext = (DataExtend)((Object)this.cmbBindDs.getSelectedItem());
                ro.getDataSource().setDs(ext.getName());
            }
            if (this.cmbBindField.getSelectedIndex() >= 0) {
                ro.getBindField().setField((Field)this.cmbBindField.getSelectedItem());
            }
        }
        if (this.radCustom.isSelected() && this.isPicSourceEdited) {
            if (!StringUtil.equals((String)ro.getImageExpression(), (String)this.labPicSource.getText())) {
                ro.setImageExpression(this.labPicSource.getText());
            }
            ro.getDataSource().setDs(null);
            ro.getBindField().setField(null);
        }
        if (this.cmbScale.getSelectedIndex() >= 0) {
            ro.setScale(this.cmbScale.getSelectedIndex() == 0 ? 0 : 3);
        }
    }

    @Override
    public String getTitle() {
        return MultiLanguageUtil.getMLS("property.PanelPicture.picture", "\u56fe\u7247");
    }

    @Override
    public void prepareCtrlValue(ElementPath[] eps) {
        this.isPicSourceEdited = false;
        this.labPicSource.setText(null);
        PictureObject ro = (PictureObject)eps[0].getLastPathComponent();
        boolean isBindData = ro.isBindData();
        String dsName = ro.getDataSource().getDs();
        Field field = ro.getBindField().getField();
        int scale = ro.getScale();
        boolean isBindDataUnsure = false;
        boolean isDsUnsure = false;
        boolean isFieldUnsure = false;
        boolean isScaleUnsure = false;
        for (int i = 1; i < eps.length; ++i) {
            ro = (PictureObject)eps[i].getLastPathComponent();
            if (!isBindDataUnsure && isBindData != ro.isBindData()) {
                isBindDataUnsure = true;
            }
            if (!isDsUnsure && !StringUtil.equals((String)dsName, (String)ro.getDataSource().getDs())) {
                isDsUnsure = true;
            }
            if (!isFieldUnsure && !Field.equals(field, ro.getBindField().getField())) {
                isFieldUnsure = true;
            }
            if (isScaleUnsure || scale == ro.getScale()) continue;
            isScaleUnsure = true;
        }
        if (isBindDataUnsure) {
            this.radBind.setSelected(false);
            this.radCustom.setSelected(false);
            this.cmbBindDs.setSelectedIndex(-1);
            this.cmbBindField.setSelectedIndex(-1);
        } else {
            this.radBind.setSelected(isBindData);
            this.radCustom.setSelected(!isBindData);
            if (isDsUnsure) {
                this.cmbBindDs.setSelectedIndex(-1);
                this.cmbBindField.setSelectedIndex(-1);
            } else {
                this.cmbBindDs.setSelectedItem((Object)this.dm.getDataExtend(dsName));
                this.prepareFieldSupplyValue(dsName);
                if (isFieldUnsure) {
                    this.cmbBindField.setSelectedIndex(-1);
                } else {
                    this.cmbBindField.setSelectedItem((Object)field);
                }
            }
        }
        if (isScaleUnsure) {
            this.cmbScale.setSelectedIndex(-1);
        } else {
            this.cmbScale.setSelectedIndex(scale == 0 ? 0 : 1);
        }
        this.syncCtrlEnabled();
    }

    @Override
    public void prepareSupplyValue(ComboPanel core, ElementPath[] eles) {
        this.dm = core.getModel().getDataManager();
        PictureObject ro = (PictureObject)eles[0].getLastPathComponent();
        IBind.IBindDataSource bindDS = ro.getDataSource();
        this.cmbBindDs.removeAllItems();
        DataExtend[] exts = this.dm.getAllDataExtends(new String[]{"param.context"});
        for (int i = 0; i < exts.length; ++i) {
            DataExtend ext = exts[i];
            MetaClass mc = (MetaClass)this.dm.getObject(ext.getName());
            if (mc == null || !bindDS.isTypeSupproted(mc.getType())) continue;
            this.cmbBindDs.addItem((Object)ext);
        }
        this.cmbBindDs.setSelectedIndex(-1);
    }

    private void prepareFieldSupplyValue(String dsName) {
        Object objDs = this.dm.getObject(dsName);
        this.cmbBindField.removeAllItems();
        if (objDs instanceof MetaClass) {
            for (MetaField mf : ((MetaClass)objDs).getFields()) {
                Field field = Field.fromMetaField(mf);
                this.cmbBindField.addItem((Object)field);
            }
        }
        this.cmbBindField.setSelectedIndex(-1);
    }
}

