/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.util;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class Language {
    private static final Logger log = LogUtil.getPackageLogger(Language.class);
    private String _alias;
    private Locale _loacle;
    public static final Language zh_CN = new Language(Locale.SIMPLIFIED_CHINESE, MultiLanguageUtil.getMLS("util.Language.simChinese", ""));
    public static final Language en = new Language(Locale.ENGLISH, MultiLanguageUtil.getMLS("util.Language.english", ""));
    public static final Language zh_TW = new Language(Locale.TRADITIONAL_CHINESE, MultiLanguageUtil.getMLS("util.Language.traChinese", ""));
    private static HashMap language = new HashMap();
    public static Language[] SUPPORT_LANGUAGES = new Language[]{zh_CN, zh_TW, en};

    public Language(Locale loacle, String alias) {
        this._loacle = loacle;
        this._alias = alias;
    }

    public static Language getLanguage(Locale locale) {
        Language l;
        String language;
        if (locale != null && (language = locale.getLanguage()) != null) {
            if ("zh_cn".equalsIgnoreCase(language)) {
                locale = Locale.SIMPLIFIED_CHINESE;
            } else if ("zh_tw".equalsIgnoreCase(language)) {
                locale = Locale.TRADITIONAL_CHINESE;
            } else if ("en".equalsIgnoreCase(language)) {
                locale = Locale.ENGLISH;
            }
        }
        if ((l = (Language)Language.language.get(locale)) == null) {
            log.error((Object)("Currency capital read not support language:" + locale.toString()));
        }
        return l;
    }

    public String getAlias() {
        return this._alias;
    }

    public Locale getLocale() {
        return this._loacle;
    }

    public String toString() {
        return this._alias;
    }

    static {
        language.put(Locale.SIMPLIFIED_CHINESE, zh_CN);
        language.put(Locale.TRADITIONAL_CHINESE, zh_TW);
        language.put(Locale.ENGLISH, en);
    }
}

