/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.model.xmltrans;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.R1Exception;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.Field;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.factory.IAnObjectFactory;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.CellField;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.ICellValue;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.loop.LoopArea;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.loop.LoopContainer;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.loop.TransposeDataModel;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.model.xmltrans.AbstractR1PrintXmlTrans;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class LoopAreaXmlTrans
extends AbstractR1PrintXmlTrans {
    public LoopAreaXmlTrans(IAnObjectFactory factory) {
        super(factory);
    }

    @Override
    protected boolean isMatch(Element node) {
        return "DynamicList".equalsIgnoreCase(node.getName());
    }

    @Override
    protected IReportObject fromXml(Element node) throws R1Exception {
        LoopArea loopArea = (LoopArea)this.getFactory().create();
        this.loadObjectCommon(node, loopArea);
        LoopAreaXmlTrans.loadTranspose(node, loopArea);
        String orientation = node.getAttributeValue("orientation");
        loopArea.setRepeatHorizontal("horizontal".equals(orientation));
        loopArea.setAdjustHeight("true".equals(node.getAttributeValue("adjustHeight")));
        loopArea.setUseOutWidth("true".equals(node.getAttributeValue("useOutWidth")));
        loopArea.setBlankRowStrategy("true".equals(node.getAttributeValue("blankRowStrategy")));
        Element nodeUnit = node.getChild("DynamicUnit");
        this.loadUnit(nodeUnit, loopArea);
        return loopArea;
    }

    @Override
    protected Element loadDataNode(Element nodeRo, IReportObject ro) {
        Element nodeData = super.loadDataNode(nodeRo, ro);
        LoopAreaXmlTrans.loadTranspose(nodeData, (LoopArea)ro);
        return nodeData;
    }

    private static void loadTranspose(Element nodeParent, LoopArea loopArea) {
        Element nodeTranspose = nodeParent.getChild("Transpose");
        if (nodeTranspose == null) {
            return;
        }
        TransposeDataModel model = loopArea.getTransposeModel();
        model.setExceptZero("true".equals(nodeTranspose.getAttributeValue("exceptZero")));
        List children = nodeTranspose.getChildren("Field");
        int count = children.size();
        Field[] fields = new Field[count];
        for (int i = 0; i < count; ++i) {
            Element nodeField = (Element)children.get(i);
            String name = nodeField.getAttributeValue("name");
            String alias = nodeField.getAttributeValue("alias");
            fields[i] = Field.valueOf(name, alias);
        }
        model.setTransposeFields(fields);
    }

    private void loadUnit(Element nodeUnit, LoopArea loopArea) throws R1Exception {
        LoopContainer loopContainer = loopArea.getLoopContainer();
        this.loadElementCommon(nodeUnit, loopContainer);
        loopContainer.setWidthLom(Integer.parseInt(nodeUnit.getAttributeValue("width")));
        loopContainer.setHeightLom(Integer.parseInt(nodeUnit.getAttributeValue("height")));
        LoopAreaXmlTrans.loadCellValue(nodeUnit, loopContainer);
        this._r1Reader.loadContainer(this._r1Reader, nodeUnit, loopArea, loopContainer);
    }

    private static void loadCellValue(Element nodeUnit, LoopContainer loopContainer) {
        Element nodeValue = nodeUnit.getChild("Value");
        if (nodeValue != null) {
            CellField cellValue = null;
            String type = nodeValue.getAttributeValue("type");
            if (StringUtil.equals((String)type, (String)"field")) {
                String content = nodeValue.getTextTrim();
                cellValue = CellField.create(content, null);
            }
            loopContainer.setValue(cellValue);
        }
    }

    @Override
    protected boolean isMatch(IReportObject ro) {
        return ro instanceof LoopArea;
    }

    @Override
    protected Element toXml(IReportObject ro) {
        LoopArea loopArea = (LoopArea)ro;
        Element node = new Element("DynamicList");
        this.saveObjectCommon(ro, node);
        node.setAttribute("orientation", loopArea.isRepeatHorizontal() ? "horizontal" : "vertical");
        if (loopArea.isAdjustHeight()) {
            node.setAttribute("adjustHeight", "true");
        }
        if (loopArea.isUseOutWidth()) {
            node.setAttribute("useOutWidth", "true");
        }
        if (loopArea.isBlankRowStrategy()) {
            node.setAttribute("blankRowStrategy", "true");
        }
        this.saveUnit(loopArea, node);
        return node;
    }

    @Override
    protected Element saveDataNode(IReportObject ro, Element node) {
        Element nodeData = super.saveDataNode(ro, node);
        LoopAreaXmlTrans.saveTranspose(((LoopArea)ro).getTransposeModel(), nodeData);
        return nodeData;
    }

    private static void saveTranspose(TransposeDataModel model, Element nodeParent) {
        if (!model.isValid()) {
            return;
        }
        Element node = new Element("Transpose");
        nodeParent.addContent((Content)node);
        if (model.isExceptZero()) {
            node.setAttribute("exceptZero", "true");
        }
        Field[] fields = model.getTransposeFields();
        for (int i = 0; i < fields.length; ++i) {
            Element nodeField = new Element("Field");
            node.addContent((Content)nodeField);
            nodeField.setAttribute("name", fields[i].getName());
            if (StringUtil.isEmptyString((String)fields[i].getAlias())) continue;
            nodeField.setAttribute("alias", fields[i].getAlias());
        }
    }

    private void saveUnit(LoopArea loopArea, Element node) {
        LoopContainer loopContainer = loopArea.getLoopContainer();
        Element nodeUnit = new Element("DynamicUnit");
        node.addContent((Content)nodeUnit);
        this.saveElementCommon(loopContainer, nodeUnit);
        nodeUnit.setAttribute("width", Integer.toString(loopContainer.getWidthLom()));
        nodeUnit.setAttribute("height", Integer.toString(loopContainer.getHeightLom()));
        LoopAreaXmlTrans.saveCellValue(loopContainer, nodeUnit);
        this._r1Writer.saveContainer(this._r1Writer, loopContainer, nodeUnit);
    }

    private static void saveCellValue(LoopContainer loopContainerl, Element nodeUnit) {
        ICellValue value = loopContainerl.getValue();
        if (value != null) {
            Element nodeValue = new Element("Value");
            switch (value.getCellType()) {
                case 2: {
                    nodeValue.setAttribute("type", "field");
                    Field field = (Field)((Object)value);
                    String content = field.getName();
                    nodeValue.addContent(content);
                    break;
                }
            }
            nodeUnit.addContent((Content)nodeValue);
        }
    }
}

