/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.model.xmltrans;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.util.Base64;
import com.kingdee.bos.ctrl.reportone.r1.common.R1Exception;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.factory.IAnObjectFactory;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.PictureObject;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.model.xmltrans.AbstractR1PrintXmlTrans;
import org.jdom2.Element;

public class PictureXmlTrans
extends AbstractR1PrintXmlTrans {
    public PictureXmlTrans(IAnObjectFactory factory) {
        super(factory);
    }

    @Override
    protected boolean isMatch(Element node) {
        return "Picture".equalsIgnoreCase(node.getName());
    }

    @Override
    protected IReportObject fromXml(Element node) throws R1Exception {
        PictureObject picObj = (PictureObject)this.getFactory().create();
        this.loadObjectCommon(node, picObj);
        if ("scale".equals(node.getAttributeValue("zoom"))) {
            picObj.setScale(3);
        } else {
            picObj.setScale(0);
        }
        return picObj;
    }

    @Override
    protected Element loadDataNode(Element nodeRo, IReportObject ro) {
        PictureObject picObj = (PictureObject)ro;
        Element nodeData = super.loadDataNode(nodeRo, ro);
        if (nodeData != null && !picObj.isBindData()) {
            String expr = nodeData.getAttributeValue("link");
            if (expr != null) {
                picObj.setLinked(true);
                picObj.setImageExpression(expr);
            } else {
                picObj.setLinked(false);
                String content = nodeData.getTextTrim();
                if (!StringUtil.isEmptyString((String)content)) {
                    picObj.setImageContent(Base64.decode((String)content));
                }
            }
        }
        return nodeData;
    }

    @Override
    protected boolean isMatch(IReportObject ro) {
        return ro instanceof PictureObject;
    }

    @Override
    protected Element toXml(IReportObject ro) {
        Element node = new Element("Picture");
        PictureObject picObj = (PictureObject)ro;
        this.saveObjectCommon(ro, node);
        if (picObj.getScale() == 3) {
            node.setAttribute("zoom", "scale");
        }
        return node;
    }

    @Override
    protected Element saveDataNode(IReportObject ro, Element node) {
        PictureObject picObj = (PictureObject)ro;
        Element nodeData = super.saveDataNode(ro, node);
        if (!picObj.isBindData()) {
            if (picObj.isLinked()) {
                if (null != picObj.getImageExpression()) {
                    nodeData.setAttribute("link", picObj.getImageExpression());
                }
            } else if (picObj.getImageContent() != null) {
                nodeData.setText(Base64.encodeBytes((byte[])picObj.getImageContent()));
            }
        }
        return nodeData;
    }
}

