/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.engine.data;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.reportone.r1.print.data.AbstractDataProcessor;
import com.kingdee.bos.ctrl.reportone.r1.print.data.AbstractPrintDataProvider;
import com.kingdee.bos.ctrl.reportone.r1.print.data.SystemR1PrintDataParameter;
import com.kingdee.bos.ctrl.reportone.r1.print.data.SystemR1PrintDataSource;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.data.AbstractInteriorDataProviderFactory;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.data.MultiCursorRowSet;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintDataException;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintRuntimeException;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class R1PDataVisitor {
    private static final Logger log = LogUtil.getPackageLogger(R1PDataVisitor.class);
    private SystemR1PrintDataSource _ds;
    private AbstractPrintDataProvider _dataProvider;
    private AbstractInteriorDataProviderFactory _interiorDataProviderFactory;
    private MultiCursorRowSet _multiCursorRowSet;
    private ArrayList _relativeDatas;
    private Variant previousValue;
    private Variant currentValue;
    private boolean _dataChanged;

    public R1PDataVisitor(SystemR1PrintDataSource ds) {
        this._ds = ds;
        this._dataChanged = true;
    }

    private R1PDataVisitor() {
    }

    public static R1PDataVisitor create(IRowSet rowSet) throws R1PrintDataException {
        R1PDataVisitor dataVisitor = new R1PDataVisitor();
        dataVisitor._multiCursorRowSet = new MultiCursorRowSet(rowSet);
        dataVisitor._dataChanged = false;
        return dataVisitor;
    }

    public void reInitialize() {
        this._dataChanged = true;
    }

    public void setDelegate(AbstractPrintDataProvider dataProvider) {
        this._dataProvider = dataProvider;
        this._dataChanged = true;
    }

    public void setInteriorImpl(AbstractInteriorDataProviderFactory dataProviderFactory) {
        this._interiorDataProviderFactory = dataProviderFactory;
        this._dataChanged = true;
    }

    public boolean isDataChanged() {
        return this._dataChanged;
    }

    private boolean init() throws R1PrintDataException {
        if (this._dataChanged) {
            this._dataChanged = false;
            this.execute();
            return true;
        }
        return false;
    }

    private void execute() throws R1PrintDataException {
        AbstractPrintDataProvider dataProvider = null;
        if (this._interiorDataProviderFactory != null) {
            dataProvider = this._interiorDataProviderFactory.getUsableDataProvider(this._ds, this._dataProvider);
        }
        if (dataProvider == null) {
            dataProvider = this._dataProvider;
        }
        if (dataProvider != null) {
            IRowSet rowSet;
            StringBuffer sbInfo = new StringBuffer("DataProvider execute. ");
            sbInfo.append(this._ds.getLogString());
            log.info((Object)sbInfo.toString());
            log.error((Object)("DataProvider is: " + dataProvider.getClass().getName()));
            long time = System.currentTimeMillis();
            try {
                rowSet = dataProvider.getData(this._ds);
            }
            catch (Exception e) {
                throw new R1PrintDataException("R1Print getData from DataProvider error: \u4e1a\u52a1\u5355\u636e\u6570\u636e\u6e90\u672a\u88ab\u5904\u7406,\u8bf7\u4e1a\u52a1\u5206\u6790\u6570\u636e\u6e90\u5904\u7406\u5668(DataProvider).", e);
            }
            time = System.currentTimeMillis() - time;
            sbInfo.insert(0, "After ");
            sbInfo.append(", Used time: ");
            sbInfo.append(time);
            log.info((Object)sbInfo.toString());
            if (this._interiorDataProviderFactory != null) {
                AbstractDataProcessor dp = this._interiorDataProviderFactory.getSpecialDataProcessor(this._ds);
                rowSet = this.process(rowSet, dp);
                dp = this._interiorDataProviderFactory.getDataProcessor(this._ds);
                rowSet = this.process(rowSet, dp);
            }
            if (rowSet == null) {
                throw new R1PrintDataException("R1Print getData from DataProvider error: \u4e1a\u52a1\u5355\u636e\u6570\u636e\u6e90\u672a\u88ab\u5904\u7406,\u8bf7\u4e1a\u52a1\u5206\u6790\u6570\u636e\u6e90\u5904\u7406\u5668(DataProvider).");
            }
            try {
                rowSet.beforeFirst();
            }
            catch (SQLException e) {
                throw new R1PrintDataException("R1Print system call beforeFirst() error.", e);
            }
            this._multiCursorRowSet = new MultiCursorRowSet(rowSet);
        }
    }

    private IRowSet process(IRowSet rowSet, AbstractDataProcessor dp) {
        if (dp != null) {
            long time = System.currentTimeMillis();
            try {
                rowSet = dp.process(rowSet, this._ds);
            }
            catch (Exception e) {
                log.error((Object)("Data processing error. Class: " + dp.getClass()), (Throwable)e);
            }
            time = System.currentTimeMillis() - time;
            log.info((Object)("Data processed, Used time: " + time));
        }
        return rowSet;
    }

    private ArrayList getRelativeDatas() {
        if (this._relativeDatas == null) {
            this._relativeDatas = new ArrayList();
        }
        return this._relativeDatas;
    }

    public void addRelativeDataVisitor(R1PDataVisitor relativeData) {
        if (!this.getRelativeDatas().contains(relativeData)) {
            this.getRelativeDatas().add(relativeData);
        }
    }

    private void notifyRelativeData() throws R1PrintDataException {
        if (this._relativeDatas != null) {
            Object[] relativeDatas = this._relativeDatas.toArray();
            for (int i = relativeDatas.length - 1; i >= 0; --i) {
                ((R1PDataVisitor)relativeDatas[i]).updateParam(this);
            }
        }
    }

    private void updateParam(R1PDataVisitor masterData) throws R1PrintDataException {
        SystemR1PrintDataParameter p = (SystemR1PrintDataParameter)this._ds.getAssociateParameter();
        if (masterData._ds.getId().equals(p.getAssociateSource())) {
            Variant var = null;
            var = masterData.isBOF() ? masterData.getPropheticRowFieldData(p.getAssociateField()) : masterData.getFieldData(p.getAssociateField());
            if (var == null && this.currentValue == null || var != null && this.currentValue != null && var.equals(this.currentValue)) {
                return;
            }
            this.currentValue = var;
            if (p.isDelay()) {
                if (this.previousValue == null) {
                    this.previousValue = this.currentValue;
                }
                p.setValue(this.previousValue);
                this.previousValue = this.currentValue;
            } else {
                p.setValue(this.currentValue);
            }
            this._dataChanged = true;
            this.notifyRelativeData();
        }
    }

    public int getFieldType(String field) throws R1PrintDataException {
        this.init();
        return this._multiCursorRowSet.getFieldType(field);
    }

    public int getRowsCount() throws R1PrintDataException {
        this.init();
        return this._multiCursorRowSet.getRowsCount();
    }

    public boolean isBOF() throws R1PrintDataException {
        this.init();
        return this._multiCursorRowSet.isBOF();
    }

    public boolean isEOF() throws R1PrintDataException {
        this.init();
        return this._multiCursorRowSet.isEOF();
    }

    public boolean hasNext() throws R1PrintDataException {
        this.init();
        return this._multiCursorRowSet.hasNext();
    }

    public boolean next() throws R1PrintDataException {
        this.init();
        if (!this._multiCursorRowSet.isEOF()) {
            this._multiCursorRowSet.next();
            this.notifyRelativeData();
            return true;
        }
        throw new R1PrintRuntimeException("Can not next when data set isEOF.");
    }

    public Variant getFieldData(String field) throws R1PrintDataException {
        this.init();
        return this._multiCursorRowSet.getFieldData(field);
    }

    public Variant getPropheticRowFieldData(String field) throws R1PrintDataException {
        this.init();
        return this._multiCursorRowSet.getPropheticRowFieldData(field);
    }

    public Variant getPreviousRowFieldData(String field) throws R1PrintDataException {
        this.init();
        return this._multiCursorRowSet.getPreviousRowFieldData(field);
    }

    public int getCurrentPositon() {
        return this._multiCursorRowSet.getCurrentCursor().getRowIdx();
    }

    public void secondSpring() throws R1PrintDataException {
        if (!this.init()) {
            this._multiCursorRowSet.secondSpring();
        }
    }
}

