/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.context;

import com.kingdee.bos.ctrl.reportone.r1.print.engine.ExecuteContext;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IDatasourceSupport;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IPaginationSupport;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.AbstractPWDataGridRow;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.PWDataGrid;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.PWDetailRow;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.PWGroupRow;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.compute.ComputedSet;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.context.GroupPageNumberManager;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.context.GroupRuntimeValue;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.stat.StatSet;
import java.util.ArrayList;
import java.util.HashMap;

public class GridExecuteContext
extends ExecuteContext
implements IPaginationSupport.IPaginationContext,
IDatasourceSupport.IDatasourceContext {
    private boolean _isEnd;
    private GroupRuntimeValue _groupRuntimeValue;
    private int _levelOfGroupEnd;
    private boolean _dividePageByGroupDiffs = false;
    private StatSet _stats;
    private ComputedSet _computeds;
    private HashMap _backwardForwardStats = new HashMap();
    private boolean _isNotEnoughOutputTailGroupRow;
    private boolean _isDead;
    private GroupPageNumberManager _groupPageNumberManager;
    private boolean _christmas;
    private PWDataGrid _grid;
    private boolean _requestRelive;
    private boolean _requestSecondBirth;

    public GridExecuteContext(PWDataGrid dataGrid) {
        this._grid = dataGrid;
        this.initState();
        this.initGroupRuntimeValue(dataGrid);
        int levels = this.getGroupRuntimeValue().getLevels();
        this._stats = new StatSet(dataGrid, levels);
        this._computeds = new ComputedSet(dataGrid, levels);
        this._groupPageNumberManager = new GroupPageNumberManager(levels + 1);
    }

    private void initState() {
        this._isEnd = false;
        this._levelOfGroupEnd = Integer.MIN_VALUE;
        this._isNotEnoughOutputTailGroupRow = false;
    }

    @Override
    public void resetState() {
        this.initState();
        this._groupRuntimeValue.clearValues();
        this._stats.reset();
        this._computeds.reset();
        this._christmas = false;
        this._requestRelive = false;
        this._requestSecondBirth = false;
        int c = this._grid.getRowsCount();
        for (int i = 0; i < c; ++i) {
            this._grid.getRow(i).setOutputOnce(false);
        }
    }

    public void setNotEnoughOutputTailGroupRow(boolean is) {
        this._isNotEnoughOutputTailGroupRow = is;
    }

    public boolean isNotEnoughOutputTailGroupRow() {
        return this._isNotEnoughOutputTailGroupRow;
    }

    public void setOutputEnd(boolean isEnd) {
        this._isEnd = isEnd;
    }

    public boolean isOutputEnd() {
        return this._isEnd;
    }

    public void setDividePageByGroupDiffs(boolean dividePageByGroup) {
        this._dividePageByGroupDiffs = dividePageByGroup;
    }

    public boolean isDividePageByGroupDiffs() {
        return this._dividePageByGroupDiffs;
    }

    private void initGroupRuntimeValue(PWDataGrid grid) {
        AbstractPWDataGridRow row;
        ArrayList<String> listGroupFields = new ArrayList<String>();
        listGroupFields.add(null);
        int c = grid.getRowsCount();
        for (int i = 0; i < c && !((row = grid.getRow(i)) instanceof PWDetailRow); ++i) {
            String gf = ((PWGroupRow)row).getGroupDesc().getGroupField();
            if (listGroupFields.contains(gf)) continue;
            listGroupFields.add(gf);
        }
        int groupCount = listGroupFields.size();
        this._groupRuntimeValue = new GroupRuntimeValue(groupCount);
        for (int i = 1; i < groupCount; ++i) {
            this._groupRuntimeValue.setGroupField(i, (String)listGroupFields.get(i));
        }
        this._groupRuntimeValue.setGroupField(0, null);
    }

    public GroupRuntimeValue getGroupRuntimeValue() {
        return this._groupRuntimeValue;
    }

    public int getLevelOfGroupEnd() {
        return this._levelOfGroupEnd;
    }

    public void setLevelOfGroupEnd(int l) {
        this._levelOfGroupEnd = l;
    }

    public StatSet getStatSet() {
        return this._stats;
    }

    public ComputedSet getComputedSet() {
        return this._computeds;
    }

    public HashMap getBackwardForwardCache() {
        return this._backwardForwardStats;
    }

    public GroupPageNumberManager getGroupPageNumberManager() {
        return this._groupPageNumberManager;
    }

    @Override
    public void relive() {
        this._isDead = false;
    }

    @Override
    public void dead() {
        this._isDead = true;
    }

    @Override
    public boolean isDead() {
        return this._isDead;
    }

    public void christmas() {
        this._christmas = true;
    }

    public boolean isChristmas() {
        return this._christmas;
    }

    @Override
    public String secondSpringDatasource() {
        return this._grid.getDatasource();
    }

    public void requestSecondBirth() {
        this._requestSecondBirth = true;
    }

    @Override
    public boolean isRequestSecondBirth() {
        return this._requestSecondBirth;
    }

    public void requestRelive() {
        this._requestRelive = true;
    }

    @Override
    public boolean isRequestRelive() {
        return this._requestRelive;
    }
}

