/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.reportimpl.xmltable;

import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.util.DBUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.reportone.data.engine.resultset.IRowNode;
import com.kingdee.bos.ctrl.reportone.data.engine.resultset.SimpleResultSet;
import com.kingdee.bos.ctrl.reportone.data.engine.resultset.SimpleResultSetMetaData;
import com.kingdee.bos.ctrl.reportone.data.engine.resultset.SimpleRowNode;
import com.kingdee.bos.ctrl.reportone.data.modal.DataConvertHelper;
import com.kingdee.bos.ctrl.reportone.data.modal.query.Column;
import com.kingdee.bos.ctrl.reportone.data.modal.types.rows.OutputColumns;
import com.kingdee.bos.ctrl.reportone.data.modal.types.rows.io.Xml2OutputColumns;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import javax.sql.RowSet;
import org.apache.log4j.Logger;
import org.jdom2.Element;

public class Xml2ResultSet {
    public static final Logger log = LogUtil.getPackageLogger(Xml2ResultSet.class);
    public static final String T_ROWS = "Rows";

    public static final RowSet toRowSet(Element e) throws SQLException {
        return DBUtil.makeRowSet((ResultSet)Xml2ResultSet.toObject(e));
    }

    public static final ResultSet toObject(Element e) throws SQLException {
        if (log.isDebugEnabled()) {
            XmlUtil.printElement((Element)e);
        }
        ResultSetMetaData rsmd = Xml2ResultSet.xml2ResultSetMetaData(e.getChild("Columns"));
        List rows = e.getChild(T_ROWS).getChildren();
        int[] types = new int[rsmd.getColumnCount()];
        for (int i = 0; i < types.length; ++i) {
            types[i] = rsmd.getColumnType(i + 1);
        }
        XMLBasedRowNode firstNode = new XMLBasedRowNode(rows.iterator(), types);
        return new SimpleResultSet(firstNode, rows.size(), rsmd);
    }

    public static final ResultSetMetaData xml2ResultSetMetaData(Element e) throws SQLException {
        try {
            SimpleResultSetMetaData s = new SimpleResultSetMetaData();
            OutputColumns ocs = Xml2OutputColumns.toObject(e);
            for (int i = 0; i < ocs.size(); ++i) {
                Column column = (Column)((Object)ocs.get(i));
                s.addColumn(i + 1, column.getName(), DataType.toJdbcType((DataType)column.getDataType()));
            }
            return s;
        }
        catch (Throwable ex) {
            throw new SQLException("The given columns is invalid.");
        }
    }

    public static class XMLBasedRowNode
    extends SimpleRowNode {
        private Iterator rows;
        private int[] types;

        public XMLBasedRowNode(Iterator rows, int[] types) {
            this.rows = rows;
            this.types = types;
            this.nextRow();
        }

        @Override
        public IRowNode nextRow() {
            if (!this.rows.hasNext()) {
                return null;
            }
            this.setRowData((Element)this.rows.next());
            return this;
        }

        private void setRowData(Element rowE) {
            List cells = rowE.getChildren();
            if (this.rowData == null) {
                this.rowData = new Object[cells.size()];
            }
            for (int i = 0; i < this.rowData.length; ++i) {
                String strVal = ((Element)cells.get(i)).getText();
                this.rowData[i] = DataConvertHelper.str2data(strVal, DataType.fromJdbcType((int)this.types[i]));
            }
        }
    }
}

