/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.impl.facade.wizzard;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.FileUtil;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.IConstants;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.WizzardIO;
import com.kingdee.bos.ctrl.excel.io.BookIOUtil;
import com.kingdee.bos.ctrl.excel.io.kds.BookToKDSBook;
import com.kingdee.bos.ctrl.excel.io.kds.KDSBookToBook;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.ExporterParameter;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.kdf.util.printout.PrintableBook;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.util.SimpleFileFilter;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.filechooser.FileFilter;

public class WizzardDefaultIO
extends KDFileChooser
implements ISpreadWizzard,
IConstants {
    private SpreadContext _context;
    private boolean _beSave;

    public WizzardDefaultIO(SpreadContext context) {
        this._context = context;
        this.addChoosableFileFilter((FileFilter)new SimpleFileFilter("pdf", "pdf" + this.getLocalText("Key_File")));
        this.addChoosableFileFilter((FileFilter)new SimpleFileFilter(new String[]{"htm", "html"}, this.getLocalText("Key_Page")));
        this.addChoosableFileFilter((FileFilter)new SimpleFileFilter("xls", "MS Excel" + this.getLocalText("Key_File")));
        this.addChoosableFileFilter((FileFilter)new SimpleFileFilter("kdf", "KDTable" + this.getLocalText("Key_File")));
        this.addChoosableFileFilter((FileFilter)new SimpleFileFilter("xml", "xml" + this.getLocalText("Key_Table")));
    }

    public void commit() {
        this._context.getActionManager().getAction("Show_Style_Wizzard").setEnabled(false);
    }

    public void setBeSave(boolean beSave) {
        this._beSave = beSave;
    }

    public boolean isModal() {
        return true;
    }

    public boolean prepare() {
        return true;
    }

    public void show() {
        if (this._beSave) {
            this.showSaveWizzard();
        } else {
            this.showOpenWizzard();
        }
    }

    private String getLocalText(String key) {
        return LanguageManager.getLangMessage((String)key, WizzardIO.class, (String)"hahahaha");
    }

    private String addExtension(String fileName, String extension) {
        if (fileName.endsWith(extension)) {
            return fileName;
        }
        return fileName + "." + extension;
    }

    private void showSaveWizzard() {
        this.setDialogTitle(this.getLocalText("Key_ExportFile"));
        int result = this.showSaveDialog((Component)this._context);
        if (result == 0) {
            FileFilter filter = this.getFileFilter();
            File file = this.getSelectedFile();
            String fileName = file.getAbsolutePath();
            if (filter instanceof SimpleFileFilter) {
                SimpleFileFilter sff = (SimpleFileFilter)filter;
                if (sff.acceptExtension("xml")) {
                    fileName = this.addExtension(fileName, "xml");
                    try {
                        BookIOUtil.saveToFile(this._context.getBook(), fileName);
                    }
                    catch (FileNotFoundException e) {
                        WindowUtil.msgboxError((Object)e.getMessage(), (String)this.getLocalText("Key_ErrorOnSaveFile"), (Component)this._context);
                    }
                    catch (IOException e) {
                        WindowUtil.msgboxError((Object)e.getMessage(), (String)this.getLocalText("Key_ErrorOnSaveFile"), (Component)this._context);
                    }
                } else if (sff.acceptExtension("xls")) {
                    fileName = this.addExtension(fileName, "xls");
                    KDSBook kdsbook = BookToKDSBook.traslate(this._context.getBook());
                    ExportManager em = new ExportManager();
                    em.setExporterParmeter(ExporterParameter.BOOK_LOCKED, (Object)Boolean.TRUE);
                    em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"true");
                    em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"true");
                    em.exportToExcel(kdsbook, fileName);
                } else if (sff.acceptExtension("pdf")) {
                    fileName = this.addExtension(fileName, "pdf");
                    KDSBook kdsbook = BookToKDSBook.traslate(this._context.getBook());
                    PrintableBook prtbook = new PrintableBook(kdsbook);
                    new ExportManager().exportToPdfFile(prtbook, fileName);
                } else if (sff.acceptExtension("html")) {
                    fileName = this.addExtension(fileName, "html");
                    KDSBook kdsbook = BookToKDSBook.traslate(this._context.getBook());
                    PrintableBook prtbook = new PrintableBook(kdsbook);
                    new ExportManager().exportToHtmlFile(prtbook, fileName);
                }
            } else {
                try {
                    BookIOUtil.saveToFile(this._context.getBook(), fileName);
                }
                catch (FileNotFoundException e) {
                    WindowUtil.msgboxError((Object)e.getMessage(), (String)this.getLocalText("Key_ErrorOnOpenFile"), (Component)this._context);
                }
                catch (IOException e) {
                    WindowUtil.msgboxError((Object)e.getMessage(), (String)this.getLocalText("Key_ErrorOnOpenFile"), (Component)this._context);
                }
            }
        }
    }

    private void showOpenWizzard() {
        this.setDialogTitle(this.getLocalText("Key_ImportFile"));
        int result = this.showOpenDialog((Component)this._context);
        if (result == 0) {
            File file = this.getSelectedFile();
            String fileName = file.getAbsolutePath();
            String ext = FileUtil.getExtension((File)file);
            String str = this.getLocalText("Key_UnsupportedFileFormat");
            if ("xls".equalsIgnoreCase(ext)) {
                KDSBook kdsbook = POIXlsReader.parse((String)fileName);
                if (kdsbook != null) {
                    Book book = KDSBookToBook.traslate(kdsbook);
                    this._context.setBook(book);
                } else {
                    WindowUtil.msgboxInfo((Object)str, (String)str, (Component)this._context);
                }
            } else if ("pdf".equalsIgnoreCase(ext)) {
                WindowUtil.msgboxInfo((Object)str, (String)str, (Component)this._context);
            } else if ("html".equalsIgnoreCase(ext)) {
                WindowUtil.msgboxInfo((Object)str, (String)str, (Component)this._context);
            } else {
                try {
                    this._context.setBook(BookIOUtil.loadFile(fileName, null));
                }
                catch (Exception e1) {
                    WindowUtil.msgboxError((Object)e1.getMessage(), (String)this.getLocalText("Key_ErrorOnOpenFile"), (Component)this._context);
                    return;
                }
            }
        }
    }
}

