/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.excel;

import com.kingdee.bos.ctrl.common.hyperlink.HyperLink;
import com.kingdee.bos.ctrl.common.util.Password;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.UnitConverter;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.SortedAttributeSpanArray;
import com.kingdee.bos.ctrl.excel.model.struct.UserObject;
import com.kingdee.bos.ctrl.excel.model.struct.ViewSplitInfo;
import com.kingdee.bos.ctrl.excel.model.struct.embed.EmbedObject;
import com.kingdee.bos.ctrl.excel.model.struct.embed.EmbedhLayer;
import com.kingdee.bos.ctrl.excel.model.util.DiagonalHeaderImageUtil;
import com.kingdee.bos.ctrl.kdf.excel.AbstractDataWrapper;
import com.kingdee.bos.ctrl.kdf.export.IExportObject;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootRow;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.util.render.splitrectangle.ISplitRectInfo;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleUtil;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.print.printjob.table.ITableForPrint;
import com.kingdee.bos.ctrl.print.util.PrintSetupUtil;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.imageio.ImageIO;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.Header;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.xmlbeans.XmlUnsignedByte;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCol;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCols;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetProtection;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;

public class BookDataWrapper
extends AbstractDataWrapper {
    private Book _book;
    private Sheet currentSheet;
    private EmbedhLayer layer;
    private BufferedImage datas;
    private int colEnd;
    private int rowEnd;
    private int colStart;
    private int rowStart;
    private int[] hideColMarks;
    private int[] hideRowMarks;
    private static final String IGNORE_SHEET_PROTECTION = "IGNORE_SHEET_PROTECTION";
    private static final short MAX_EXCEL_GROUP_LEVEL = 7;
    private int currentLevel = 0;
    private List<Cell> diagonalHeaderCells = new ArrayList<Cell>();

    public BookDataWrapper(Book book) {
        super(book.getSheetCount());
        this._book = book;
    }

    public ShareStyleAttributes SSAAt(int row, int col) {
        if (this._exportSelect) {
            row += this.rowStart;
            col += this.colStart;
        }
        Cell cell = this.currentSheet.getCell(row, col, false);
        CellBlock merge = this.currentSheet.getMergeBlock(row, col);
        Style cellDisplayStyle = null;
        if (merge == null && cell == null) {
            cellDisplayStyle = this.currentSheet.getCellDisplayStyle(row, col);
            if (cellDisplayStyle == null) {
                return Styles.getEmptySSA();
            }
        } else if (merge != null) {
            cell = this.currentSheet.getCell(merge.getRow(), merge.getCol(), false);
        }
        ShareStyleAttributes[] ssas = new ShareStyleAttributes[4];
        if (cell == null) {
            ssas[0] = cellDisplayStyle;
        } else {
            Object ret;
            ssas[0] = cell.getStyle();
            UserObject object = cell.getUserObject("display");
            String numberFormat = null;
            if (null != object) {
                numberFormat = this.convertUserObject2Format(object);
            }
            if ((ret = cell.getValue()) instanceof Variant) {
                ret = ret.getValue();
            }
            if (ret instanceof IExportObject) {
                IExportObject eo = (IExportObject)ret;
                numberFormat = eo.getFormatString();
            }
            if (null != numberFormat) {
                StyleAttributes sa = Styles.getSA((ShareStyleAttributes)ssas[0]);
                sa.setNumberFormat(numberFormat);
                ssas[0] = Styles.getSSA((StyleAttributes)sa);
            }
        }
        ssas[1] = this.currentSheet.getRowSSA(row);
        ssas[2] = this.currentSheet.getColSSA(col);
        ssas[3] = this.currentSheet.getSSA();
        return Styles.mergeSSA((ShareStyleAttributes[])ssas);
    }

    private String convertUserObject2Format(UserObject object) {
        String result = null;
        switch ((Integer)object.getValue()) {
            case 2: {
                result = "0\".\"0,\"(\u4e07\u5143)\"";
                break;
            }
            case 4: {
                result = "0\".\"0,";
                break;
            }
            case 3: {
                result = "0\".\"000";
                break;
            }
            case 1: {
                result = "0\".\"000 \"(\u5343\u5143)\"";
                break;
            }
        }
        return result;
    }

    public int colCount() {
        return this.colEnd;
    }

    public int colWidthAt(int colNum) {
        return SheetBaseMath.getColWidth((Sheet)this.currentSheet, (int)colNum, (boolean)false, (boolean)true);
    }

    public void dataSourceMemeryCallback(int row, int col) {
    }

    public AbstractDataWrapper.EmbedObject getEmbedObject(int index) {
        int dx2;
        int dy2;
        int size;
        int n = size = this.layer == null ? 0 : this.layer.size();
        if (index >= size) {
            KDSBook.KDSImage img = DiagonalHeaderImageUtil.translate((Cell)this.diagonalHeaderCells.get(index - size));
            return BookDataWrapper.getEmbedObject((byte[])img.getBinaryImage(), (int)0, (int)0, (int)0, (int)0, (int)img.getTop(), (int)img.getLeft(), (int)img.getBottom(), (int)img.getRight(), (int)this._currentSheetIndex);
        }
        EmbedObject eo = this.layer.getEmbed(index);
        Rectangle rect = eo.getBounds();
        this.datas = new BufferedImage(eo.getWidth(), eo.getHeight(), 2);
        eo.setBounds(0, 0, eo.getWidth(), eo.getHeight());
        eo.paintData(this.datas.getGraphics());
        eo.setBounds(rect);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)this.datas, "png", out);
        }
        catch (IOException ioe) {
            return null;
        }
        this.datas = null;
        Point p = rect.getLocation();
        int row = SheetBaseMath.rowAtPoint((Sheet)this.currentSheet, (Point2D)p);
        int col = SheetBaseMath.colAtPoint((Sheet)this.currentSheet, (Point2D)p);
        int rowPostion = SheetBaseMath.getRowY((Sheet)this.currentSheet, (int)row);
        int colPosition = SheetBaseMath.getColX((Sheet)this.currentSheet, (int)col);
        int dy1 = (int)(9525.0 * (60.0 * ((double)(p.y > rowPostion ? p.y - rowPostion : rowPostion - p.y) / (double)SheetBaseMath.getRowHeight((Sheet)this.currentSheet, (int)row))));
        int dx1 = (int)(9525.0 * (100.0 * ((double)(p.x > colPosition ? p.x - colPosition : colPosition - p.x) / (double)SheetBaseMath.getColWidth((Sheet)this.currentSheet, (int)col))));
        p.x += rect.width;
        p.y += rect.height;
        int row2 = SheetBaseMath.rowAtPoint((Sheet)this.currentSheet, (Point2D)p);
        int col2 = SheetBaseMath.colAtPoint((Sheet)this.currentSheet, (Point2D)p);
        int rowPostion2 = SheetBaseMath.getRowY((Sheet)this.currentSheet, (int)row2);
        int colPosition2 = SheetBaseMath.getColX((Sheet)this.currentSheet, (int)col2);
        if (row != row2 && col != col2) {
            dy2 = (int)(9525.0 * (60.0 * ((double)(p.y > rowPostion2 ? p.y - rowPostion2 : rowPostion2 - p.y) / (double)SheetBaseMath.getRowHeight((Sheet)this.currentSheet, (int)row2))));
            dx2 = (int)(9525.0 * (100.0 * ((double)(p.x > colPosition2 ? p.x - colPosition2 : colPosition2 - p.x) / (double)SheetBaseMath.getColWidth((Sheet)this.currentSheet, (int)col2))));
        } else {
            dy2 = (int)(9525.0 * (60.0 * (double)(p.y > rowPostion2 ? p.y - rowPostion2 : rowPostion2 - p.y)));
            dx2 = (int)(9525.0 * (100.0 * (double)(p.x > colPosition2 ? p.x - colPosition2 : colPosition2 - p.x)));
        }
        return BookDataWrapper.getEmbedObject((byte[])out.toByteArray(), (int)dx1, (int)dy1, (int)dx2, (int)dy2, (int)row, (int)col, (int)row2, (int)col2, (int)this._currentSheetIndex);
    }

    public int getEmbedObjectsCount() {
        int count = 0;
        if (this.layer != null) {
            count = this.layer.size();
        }
        Sheet.ICellsIterator iter = this.currentSheet.getCellsIterator(0, 0, 1048575, 16383, true, true);
        while (iter.hasNext()) {
            Cell cll = iter.next();
            if (cll.getDiagonalHeader() == null || !DiagonalHeaderImageUtil.isValidSplitRectInfo((ISplitRectInfo)cll.getDiagonalHeader(), (Cell)cll)) continue;
            this.diagonalHeaderCells.add(cll);
            ++count;
        }
        return count;
    }

    protected String getFormula(int row, int col) {
        if (!this._exportFormula) {
            return null;
        }
        Cell cell = this.getFirstVisibleMergeCell(row, col);
        if (cell == null) {
            return null;
        }
        if (!cell.hasFormula()) {
            return null;
        }
        return cell.getFormula();
    }

    public AbstractDataWrapper.MergeBlock getMergeBlock(int rowNum, int colNum) {
        AbstractDataWrapper.MergeBlock mb;
        int i;
        if (!this._exportMergeBlocks) {
            return null;
        }
        Cell cell = this.getFirstVisibleMergeCell(rowNum, colNum);
        if (cell == null) {
            return null;
        }
        CellBlock cb = cell.getMerge(true);
        if (cb == null) {
            return null;
        }
        int top = cb.getRow();
        int bottom = cb.getRow2();
        int left = cb.getCol();
        int right = cb.getCol2();
        if (top == bottom && left == right) {
            return null;
        }
        int hideRowCount = 0;
        int hideColCount = 0;
        if (!this._exportHideRows) {
            for (i = top; i <= bottom; ++i) {
                if (this.hideRowMarks[i] != 1) continue;
                ++hideRowCount;
            }
        }
        if (!this._exportHideCols) {
            for (i = left; i <= right; ++i) {
                if (this.hideColMarks[i] != 1) continue;
                ++hideColCount;
            }
        }
        if ((mb = BookDataWrapper.getMergeBlock((int)rowNum, (int)colNum, (int)(bottom - top + rowNum - hideRowCount), (int)(right - left + colNum - hideColCount))).getRow2() == mb.getRow() && mb.getCol() == mb.getCol2()) {
            mb = null;
        }
        return mb;
    }

    public boolean isBookProtected() {
        return this._book.getProtection().isProtected();
    }

    public boolean isColEnd(int colPosition) {
        if (this._exportSelect) {
            return colPosition > this.colEnd - this.colStart;
        }
        return colPosition > this.colEnd;
    }

    public boolean isCurrentSheetProtected() {
        return this._book.getProtection().isProtected();
    }

    public int getActiveSheetIndex() {
        return this._book.getActiveSheetIndex();
    }

    public boolean isHideSheet(int index) {
        return this._book.getSheet(index).getSheetOption().isHide();
    }

    public boolean isHideCol(int col) {
        if (this._exportHideCols) {
            return false;
        }
        SortedAttributeSpanArray colSpans = this.currentSheet.getColSpans();
        int index = colSpans.searchSpan(col);
        if (index < 0) {
            return false;
        }
        return !colSpans.getAttributeSpan(index).isVisible();
    }

    public boolean isHideRow(int row) {
        if (this._exportHideRows) {
            return false;
        }
        SortedAttributeSpanArray rowSpans = this.currentSheet.getRowSpans();
        int index = rowSpans.searchSpan(row);
        if (index < 0) {
            return false;
        }
        return !rowSpans.getAttributeSpan(index).isVisible();
    }

    public boolean isRowEnd(int rowPosition) {
        if (this._exportSelect) {
            return rowPosition > this.rowEnd - this.rowStart;
        }
        return rowPosition > this.rowEnd;
    }

    public int rowCount() {
        return -1;
    }

    public int rowHeightAt(int rowNum) {
        return SheetBaseMath.getRowHeight((Sheet)this.currentSheet, (int)rowNum, (boolean)false, (boolean)true);
    }

    public int sheetCount() {
        return this._book.getSheetCount();
    }

    public String sheetName(int index) {
        return this._book.getSheetName(index);
    }

    public Object valueAt(int row, int col) {
        Cell cell = this.getFirstVisibleMergeCell(row, col);
        if (cell == null) {
            return null;
        }
        Object ret = cell.getValue().getValue();
        if (ret == Variant.calcLast.getValue()) {
            ret = null;
        }
        if (ret instanceof Variant) {
            ret = ((Variant)ret).getValue();
        }
        if (ret instanceof IExportObject) {
            IExportObject eo = (IExportObject)ret;
            ret = eo.getContent();
        }
        return ret;
    }

    private Cell getFirstVisibleMergeCell(int rowNum, int colNum) {
        int i;
        if (this._exportSelect) {
            rowNum += this.rowStart;
            colNum += this.colStart;
        }
        CellBlock cb = null;
        cb = this.currentSheet.getMergeBlock(rowNum, colNum);
        if (cb == null) {
            return this.currentSheet.getCell(rowNum, colNum, false);
        }
        int row = cb.getRow();
        int col = cb.getCol();
        int row2 = cb.getRow2();
        int col2 = cb.getCol2();
        if (!this._exportHideCols && this.hideColMarks[colNum] != 1) {
            for (i = col; i <= col2 && this.hideColMarks[i] == 1; ++i) {
                ++col;
            }
        }
        if (!this._exportHideRows && this.hideRowMarks[rowNum] != 1) {
            for (i = row; i <= row2 && this.hideRowMarks[i] == 1; ++i) {
                ++row;
            }
        }
        if (rowNum == row && colNum == col) {
            return this.currentSheet.getCell(cb.getRow(), cb.getCol(), false);
        }
        if (!this._exportMergeBlocks) {
            return this.currentSheet.getCell(cb.getRow(), cb.getCol(), false);
        }
        return null;
    }

    public short valueTypeAt(int row, int col) {
        Cell cell = this.getFirstVisibleMergeCell(row, col);
        if (cell == null) {
            return 3;
        }
        if (cell.hasFormula()) {
            return 2;
        }
        Variant v = cell.getValue();
        Object value = v.getValue();
        if (v == null || value == null) {
            return 3;
        }
        return BookDataWrapper.getValueType((Object)value);
    }

    public String textAt(int row, int col) {
        Cell cell = this.getFirstVisibleMergeCell(row, col);
        if (cell == null) {
            return null;
        }
        return cell.getText();
    }

    public void setCurrentSheetIndex(int currentSheetIndex) {
        int i;
        this._currentSheetIndex = currentSheetIndex;
        this.currentSheet = this._book.getSheet(this._currentSheetIndex);
        this.layer = this.currentSheet.getEmbedments(false);
        this.colEnd = this.currentSheet.getMaxColIndex();
        this.rowEnd = this.currentSheet.getMaxRowIndex();
        if (!this._exportHideRows) {
            this.hideRowMarks = new int[this.rowEnd + 1];
            for (i = 0; i <= this.rowEnd; ++i) {
                if (!this.isHideRow(i)) continue;
                this.hideRowMarks[i] = 1;
            }
        }
        if (!this._exportHideCols) {
            this.hideColMarks = new int[this.colEnd + 1];
            for (i = 0; i <= this.colEnd; ++i) {
                if (!this.isHideCol(i)) continue;
                this.hideColMarks[i] = 1;
            }
        }
        if (this._exportSelect) {
            Range range = this.currentSheet.getSelectionRange();
            CellBlock cb = range.getLastBlock();
            this.rowStart = cb.getRow();
            this.colStart = cb.getCol();
            this.rowEnd = cb.getRow2() > this.rowEnd ? this.rowEnd : cb.getRow2();
            this.colEnd = cb.getCol2() > this.colEnd ? this.colEnd : cb.getCol2();
            this.layer = null;
        }
    }

    public HyperLink hyperLinkAt(int row, int col) {
        Cell cell = this.getFirstVisibleMergeCell(row, col);
        return cell == null ? null : cell.getHyperLink();
    }

    public Sheet getSheet() {
        return this.currentSheet;
    }

    public void setGroupCol(XSSFSheet sheet, int colNum) {
        SortedAttributeSpanArray colSpans = this.currentSheet.getColSpans();
        if (colSpans == null || colSpans.isEmpty()) {
            return;
        }
        int spanPos = colSpans.searchSpan(colNum);
        if (spanPos < 0) {
            return;
        }
        int e = 1;
        CTWorksheet ctWorksheet = sheet.getCTWorksheet();
        CTCol[] colArr = new CTCol[e];
        ArrayList<CTCol> list = new ArrayList<CTCol>(e);
        CTCols cols = CTCols.Factory.newInstance();
        SortedAttributeSpanArray.AttributeSpan attrSpan = colSpans.getAttributeSpan(spanPos);
        CTCol newCol = CTCol.Factory.newInstance();
        newCol.xsetOutlineLevel(XmlUnsignedByte.Factory.newValue((Object)attrSpan.getOutlineGroupLevel()));
        newCol.setOutlineLevel((short)attrSpan.getOutlineGroupLevel());
        list.add(newCol);
        list.toArray(colArr);
        cols.setColArray(colArr);
        ctWorksheet.setColsArray(0, cols);
    }

    public void setGroupRow(XSSFSheet sheet, XSSFRow xRow) {
        SortedAttributeSpanArray.AttributeSpan attrSpan;
        SortedAttributeSpanArray rowSpans = this.currentSheet.getRowSpans();
        if (rowSpans == null || rowSpans.isEmpty()) {
            return;
        }
        int spanPos = rowSpans.searchSpan(xRow.getRowNum());
        if (spanPos < 0) {
            return;
        }
        if (xRow.getHeight() <= 0) {
            xRow.setZeroHeight(true);
            xRow.setHeight((short)(StyleUtil.lomToPt((double)((float)UnitConverter.px2mm((int)this.currentSheet.getDefRowHeight()) * 10.0f)) * 20.0));
        }
        if ((attrSpan = rowSpans.getAttributeSpan(spanPos)).getOutlineGroupLevel() <= 7) {
            xRow.getCTRow().setOutlineLevel((short)attrSpan.getOutlineGroupLevel());
        } else {
            xRow.getCTRow().setOutlineLevel((short)7);
        }
    }

    public void addGroupRow(org.apache.poi.ss.usermodel.Sheet sheet, Row row, int rowIndex) {
        SortedAttributeSpanArray rowSpans = this.currentSheet.getRowSpans();
        if (rowSpans == null || rowSpans.isEmpty()) {
            return;
        }
        int spanPos = rowSpans.searchSpan(rowIndex);
        if (spanPos < 0) {
            return;
        }
        SortedAttributeSpanArray.AttributeSpan attrSpan = rowSpans.getAttributeSpan(spanPos);
        SXSSFRow sRow = (SXSSFRow)row;
        if (!attrSpan.isVisible()) {
            sRow.setHidden(Boolean.valueOf(true));
        }
        if (this.currentSheet.getOriginalDefRowHeight() != attrSpan.getOriginalLength()) {
            row.setHeight((short)(StyleUtil.lomToPt((double)((float)UnitConverter.px2mm((int)attrSpan.getOriginalLength()) * 10.0f)) * 20.0));
        }
        if (attrSpan.getOutlineGroupLevel() <= 7) {
            this.currentLevel = this.setRowOutLineLevel(sRow, AbstractDataWrapper.getCtWorksheet((org.apache.poi.ss.usermodel.Sheet)sheet), this.currentLevel, attrSpan.getOutlineGroupLevel());
        }
    }

    public String getPassWd() {
        Protection protection = this.currentSheet.getSheetOption().getProtection(false);
        if (protection != null && protection.isProtected()) {
            return protection.getEncryptedPassword();
        }
        return null;
    }

    public String getPrintArea() {
        com.kingdee.bos.ctrl.excel.model.struct.PrintSetup printSetup = this.currentSheet.getSheetOption().getPrintSetup(false);
        if (null != printSetup) {
            return printSetup.getPrintAreas();
        }
        return super.getPrintArea();
    }

    public void addPrintSetup(org.apache.poi.ss.usermodel.Sheet xssfSheet) {
        com.kingdee.bos.ctrl.excel.model.struct.PrintSetup printSetup = this.currentSheet.getSheetOption().getPrintSetup(false);
        PrintSetup ps = xssfSheet.getPrintSetup();
        if (printSetup != null) {
            this.addMargin(xssfSheet, printSetup, ps);
            short scale = (short)printSetup.getScale();
            if (scale < 10) {
                scale = 10;
            }
            if (scale > 400) {
                scale = 400;
            }
            ps.setScale(scale);
            this.addPaperInfo(xssfSheet, printSetup, ps);
            this.addHeaderAndFooter(xssfSheet, printSetup);
            this.addPrintAttr(xssfSheet, printSetup, ps);
            this.addPrintTitle(xssfSheet, printSetup);
        }
    }

    private void addPaperInfo(org.apache.poi.ss.usermodel.Sheet xssfSheet, com.kingdee.bos.ctrl.excel.model.struct.PrintSetup printSetup, PrintSetup ps) {
        ps.setLandscape(printSetup.isLandScape());
        int centerHorizontal = printSetup.getCenterHorizontal();
        int centerVertical = printSetup.getCenterVertical();
        xssfSheet.setHorizontallyCenter(centerHorizontal == 1);
        xssfSheet.setVerticallyCenter(centerVertical == 1);
        ps.setPaperSize(this.transformPaperSizefromISOtoPOI(printSetup.getPagesizeIndex()));
    }

    private short transformPaperSizefromISOtoPOI(int paperSizeValue) {
        short paperSize;
        switch (paperSizeValue) {
            case 3: {
                paperSize = 8;
                break;
            }
            case 4: {
                paperSize = 9;
                break;
            }
            case 5: {
                paperSize = 11;
                break;
            }
            case 26: {
                paperSize = 12;
                break;
            }
            case 27: {
                paperSize = 13;
                break;
            }
            case 40: {
                paperSize = 1;
                break;
            }
            case 60: {
                paperSize = 20;
                break;
            }
            case 57: {
                paperSize = 37;
                break;
            }
            default: {
                paperSize = 9;
            }
        }
        return paperSize;
    }

    private void addPrintAttr(org.apache.poi.ss.usermodel.Sheet xssfSheet, com.kingdee.bos.ctrl.excel.model.struct.PrintSetup printSetup, PrintSetup ps) {
        ps.setNoColor(printSetup.isBlackWhite());
        xssfSheet.setPrintGridlines(printSetup.hasGrid());
        ps.setLeftToRight(printSetup.isRowFirst());
        xssfSheet.setPrintRowAndColumnHeadings(printSetup.hasRowHead() || printSetup.hasColHead());
    }

    private void addMargin(org.apache.poi.ss.usermodel.Sheet xssfSheet, com.kingdee.bos.ctrl.excel.model.struct.PrintSetup printSetup, PrintSetup ps) {
        float bottomMargin = printSetup.getBottomMargin();
        float topMargin = printSetup.getTopMargin();
        float rightMargin = printSetup.getRightMargin();
        float leftMargin = printSetup.getLeftMargin();
        boolean autoFit = printSetup.isAutoFit();
        if (autoFit) {
            ps.setFitHeight((short)printSetup.getAutoFitHeight());
            ps.setFitWidth((short)printSetup.getAutoFitWidth());
            xssfSheet.setFitToPage(autoFit);
        } else {
            printSetup.setAutoFit(false);
            ps.setFitHeight((short)1);
            ps.setFitWidth((short)1);
        }
        xssfSheet.setMargin((short)3, (double)bottomMargin);
        xssfSheet.setMargin((short)2, (double)topMargin);
        xssfSheet.setMargin((short)1, (double)rightMargin);
        xssfSheet.setMargin((short)0, (double)leftMargin);
        float footAlign = printSetup.getFootMargin();
        float headAlign = printSetup.getHeadMargin();
        ps.setHeaderMargin((double)headAlign);
        ps.setFooterMargin((double)footAlign);
    }

    private void addHeaderAndFooter(org.apache.poi.ss.usermodel.Sheet xssfSheet, com.kingdee.bos.ctrl.excel.model.struct.PrintSetup printSetup) {
        Header header = xssfSheet.getHeader();
        List headData = printSetup.getHeadData();
        if (headData != null && !headData.isEmpty()) {
            String[] headerData = this.configHeaderOrFooter(headData);
            header.setLeft(this.translateSpecailChar(headerData[0]));
            header.setCenter(this.translateSpecailChar(headerData[1]));
            header.setRight(this.translateSpecailChar(headerData[2]));
        }
        Footer footer = xssfSheet.getFooter();
        List footData = printSetup.getFootData();
        if (footData != null && !footData.isEmpty()) {
            String[] footerData = this.configHeaderOrFooter(footData);
            footer.setLeft(this.translateSpecailChar(footerData[0]));
            footer.setCenter(this.translateSpecailChar(footerData[1]));
            footer.setRight(this.translateSpecailChar(footerData[2]));
        }
    }

    private void addPrintTitle(org.apache.poi.ss.usermodel.Sheet xssfSheet, com.kingdee.bos.ctrl.excel.model.struct.PrintSetup printSetup) {
        String topTitleRows;
        List topTitleBlock;
        String leftTitleColumns = printSetup.getLeftTitleColumns();
        List leftTitleBlock = PrintSetupUtil.parserBlock((String)leftTitleColumns);
        if (null != leftTitleBlock) {
            int size = leftTitleBlock.size();
            for (int k = 0; k < size; ++k) {
                ITableForPrint.IBlock block = (ITableForPrint.IBlock)leftTitleBlock.get(k);
                if (block == null) continue;
                CellRangeAddress cols = new CellRangeAddress(-1, -1, block.getCol(), block.getCol2());
                xssfSheet.setRepeatingColumns(cols);
            }
        }
        if (null != (topTitleBlock = PrintSetupUtil.parserBlock((String)(topTitleRows = printSetup.getTopTitleRows())))) {
            int size = topTitleBlock.size();
            for (int k = 0; k < size; ++k) {
                ITableForPrint.IBlock block = (ITableForPrint.IBlock)topTitleBlock.get(k);
                if (block == null) continue;
                CellRangeAddress rows = new CellRangeAddress(block.getRow(), block.getRow2(), -1, -1);
                xssfSheet.setRepeatingRows(rows);
            }
        }
    }

    private String translateSpecailChar(String strIn) {
        if (!StringUtil.isEmptyString((String)strIn)) {
            strIn = strIn.replace("&[Page]", "&P");
            strIn = strIn.replace("&[PageCount]", "&N");
            strIn = strIn.replace("&[Date]", "&D");
            strIn = strIn.replace("&[Time]", "&T");
            strIn = strIn.replace("&L", "&L");
            strIn = strIn.replace("&C", "&C");
            strIn = strIn.replace("&R", "&R");
        }
        return strIn;
    }

    private String[] configHeaderOrFooter(List data) {
        StringBuilder leftBuffer = new StringBuilder("");
        StringBuilder centerBuffer = new StringBuilder("");
        StringBuilder rightBuffer = new StringBuilder("");
        ListIterator iterator = data.listIterator();
        while (iterator.hasNext()) {
            String originRowText = ((HeadFootRow)iterator.next()).toString();
            String[] text = StringUtil.splitString((String)originRowText, (String)"&|");
            String[] rs = this.spliceHeaderOrFooter(text, iterator.previousIndex());
            leftBuffer.append(rs[0]);
            centerBuffer.append(rs[1]);
            rightBuffer.append(rs[2]);
        }
        return new String[]{leftBuffer.toString(), centerBuffer.toString(), rightBuffer.toString()};
    }

    private String[] spliceHeaderOrFooter(String[] rowText, int rowIndex) {
        String newLine = rowIndex > 0 ? "\n" : "";
        StringBuilder left = new StringBuilder(newLine + "");
        StringBuilder center = new StringBuilder(newLine + "");
        StringBuilder right = new StringBuilder(newLine + "");
        int col = rowText.length;
        if (col != 0) {
            if (col == 1) {
                center.append(rowText[0]);
            } else if (col == 2) {
                left.append(rowText[0]);
                right.append(rowText[1]);
            } else if (col == 3) {
                left.append(rowText[0]);
                center.append(rowText[1]);
                right.append(rowText[2]);
            } else {
                left.append(rowText[0]);
                right.append(rowText[col - 1]);
                for (int i = 1; i <= col - 2; ++i) {
                    center.append(rowText[i]);
                }
            }
        }
        return new String[]{left.toString(), center.toString(), right.toString()};
    }

    public int getExportPageRowCount() {
        return Integer.MAX_VALUE;
    }

    public String getCellValue(int row, int col) {
        String value = "";
        Cell cell = this.currentSheet.getCell(row, col, false);
        if (null != cell && null != cell.getValue()) {
            value = cell.getValue().toString();
        }
        return value;
    }

    public boolean isShowHoriLines() {
        return this.currentSheet.getSheetOption().isShowHoriLines();
    }

    public boolean isShowVertLines() {
        return this.currentSheet.getSheetOption().isShowVertLines();
    }

    public void addGroupInfo(org.apache.poi.ss.usermodel.Sheet sheet) {
        CTWorksheet ctWorksheet = AbstractDataWrapper.getCtWorksheet((org.apache.poi.ss.usermodel.Sheet)sheet);
        CTCols ctCols = ctWorksheet.getColsArray(0);
        SortedAttributeSpanArray colSpans = this.currentSheet.getColSpans();
        for (int i = 0; i < colSpans.size(); ++i) {
            SortedAttributeSpanArray.AttributeSpan attrSpanCol = colSpans.getAttributeSpan(i);
            CTCol ctCol = CTCol.Factory.newInstance();
            ctCol.setMin((long)attrSpanCol.getStart() + 1L);
            ctCol.setMax((long)attrSpanCol.getEnd() + 1L);
            ctCol.setCustomWidth(true);
            if (attrSpanCol.getOutlineGroupLevel() > 0) {
                ctCol.setOutlineLevel((short)attrSpanCol.getOutlineGroupLevel());
            }
            if (!attrSpanCol.isVisible()) {
                ctCol.setHidden(true);
            }
            double width = Math.min((double)attrSpanCol.getOriginalLength() / 8.15, 255.0);
            ctCol.setWidth(width);
            ctCols.getColList().add(ctCol);
        }
    }

    public void addFreezeLine(org.apache.poi.ss.usermodel.Sheet xssfSheet) {
        ViewSplitInfo splitInfo = this.getSheet().getSheetOption().getViewSplitInfo();
        if (!splitInfo.isFreezed()) {
            return;
        }
        int xSplit = splitInfo.getColSplit();
        int ySplit = splitInfo.getRowSplit();
        int topLeft_col = splitInfo.getFirstCol2();
        int topLeft_row = splitInfo.getFirstRow2();
        xssfSheet.createFreezePane(xSplit, ySplit, topLeft_col, topLeft_row);
    }

    public void addProtection(org.apache.poi.ss.usermodel.Sheet xssfSheet) {
        String passWd;
        boolean isExportProtection;
        block7: {
            isExportProtection = true;
            if (null != this.currentSheet) {
                String sql = "SELECT * FROM T_CSL_CSLPARAM WHERE FKEY = 'IGNORE_SHEET_PROTECTION'";
                try {
                    IRowSet rowSet = SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
                    if (rowSet.size() <= 0) break block7;
                    while (rowSet.next()) {
                        String fvalue = rowSet.getObject("FVALUE").toString();
                        if (fvalue == null || !fvalue.equalsIgnoreCase("true")) continue;
                        isExportProtection = false;
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (null != (passWd = this.getPassWd()) && isExportProtection) {
            xssfSheet.protectSheet(Password.getRealPassWord((String)passWd));
            Protection pr = this.currentSheet.getSheetOption().getProtection(false);
            if (null != pr) {
                CTWorksheet ctWorkbook = AbstractDataWrapper.getCtWorksheet((org.apache.poi.ss.usermodel.Sheet)xssfSheet);
                if (null == ctWorkbook) {
                    return;
                }
                CTSheetProtection cp = ctWorkbook.isSetSheetProtection() ? ctWorkbook.getSheetProtection() : ctWorkbook.addNewSheetProtection();
                cp.setFormatRows(!pr.hasOperation(16));
                cp.setFormatColumns(!pr.hasOperation(8));
                cp.setFormatCells(!pr.hasOperation(4));
                cp.setSort(!pr.hasOperation(1024));
                cp.setDeleteRows(!pr.hasOperation(512));
                cp.setDeleteColumns(!pr.hasOperation(256));
                cp.setInsertHyperlinks(!pr.hasOperation(128));
                cp.setInsertRows(!pr.hasOperation(64));
                cp.setInsertColumns(!pr.hasOperation(32));
            }
        }
    }

    public boolean isExportRPT() {
        return true;
    }
}

