/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.swing.BasicNumberTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Currency;
import java.util.Locale;
import javax.swing.JFormattedTextField;
import javax.swing.text.NumberFormatter;

public class KDBusiCurrencyField
extends BasicNumberTextField {
    private static final long serialVersionUID = -4221593192888473223L;
    public static final int PROPERTY_SYMBOLSPOSITION = 40;
    private boolean isRequiredCurrencySymbols = false;
    private String currencySymbols = "";
    private String oldCurrencySymbols = "";
    private Currency currentCurrency = null;
    private Locale currencyLocale = null;
    private int symbolsPosition = 2;

    public KDBusiCurrencyField() {
        this.initField();
    }

    protected void initField() {
        Currency c;
        NumberFormat nf = CtrlFormatUtilities.getCurrencyFormat();
        if (nf == null) {
            nf = NumberFormat.getCurrencyInstance(Locale.getDefault());
        }
        if (nf != null && (c = nf.getCurrency()) != null) {
            this.setCurrencySymbols(c.getSymbol());
        }
    }

    @Override
    protected void init(int dataType) {
        this.dataType = 4;
        boolean old = this.isImmediatelyValidate();
        this.setRemoveingZeroInDispaly(false);
        this.setImmediatelyValidate(old);
        super.init(this.dataType);
    }

    public KDBusiCurrencyField(int dataType) {
        super(dataType);
        this.initField();
    }

    public KDBusiCurrencyField(Object value) {
        super(value);
        this.initField();
    }

    public KDBusiCurrencyField(JFormattedTextField.AbstractFormatterFactory factory) {
        super(factory);
        this.initField();
    }

    public String getCurrencySymbols() {
        return this.currencySymbols;
    }

    public void setCurrencySymbols(String newValue) {
        newValue = newValue == null ? "" : newValue.trim();
        newValue = newValue.replaceAll("\\.", " ");
        this.oldCurrencySymbols = this.currencySymbols;
        if (!StringUtil.equals((String)this.oldCurrencySymbols, (String)newValue)) {
            this.currencySymbols = newValue;
            if (this.isRequiredCurrencySymbols() && this.isImmediatelyValidate()) {
                this.createDisEdiFormatterAgain(33);
            }
        }
    }

    public boolean isRequiredCurrencySymbols() {
        return this.isRequiredCurrencySymbols;
    }

    public void setRequiredCurrencySymbols(boolean newValue) {
        boolean old = this.isRequiredCurrencySymbols;
        if (old != newValue) {
            this.isRequiredCurrencySymbols = newValue;
            String string = this.currencySymbols = this.currencySymbols == null ? "" : this.currencySymbols;
            if (this.isImmediatelyValidate()) {
                this.createDisEdiFormatterAgain(34);
            }
        }
    }

    protected Currency getCurrentCurrency() {
        return this.currentCurrency;
    }

    protected void setCurrentCurrency(Currency currentCurrency) {
        this.currentCurrency = currentCurrency;
    }

    protected Locale getCurrencyLocale() {
        return this.currencyLocale;
    }

    protected void setCurrencyLocale(Locale currencyLocale) {
        this.currencyLocale = currencyLocale;
    }

    @Override
    protected void createDisEdiFormatterAgain(int propertyType) {
        super.createDisEdiFormatterAgain(propertyType);
    }

    @Override
    protected NumberFormatter createDisplayFormatter(int newDataType) {
        return super.createDisplayFormatter(newDataType);
    }

    @Override
    protected NumberFormatter createEditFormatter(int newDataType) {
        return super.createEditFormatter(newDataType);
    }

    @Override
    protected void exConfigDisFormat(DecimalFormat format) {
        super.exConfigDisFormat(format);
        if (format == null) {
            return;
        }
        if (this.isRequiredCurrencySymbols()) {
            if (!StringUtil.equals((String)this.oldCurrencySymbols, (String)this.getCurrencySymbols())) {
                String tempPattern = KDBusiCurrencyField.generatePatter(this.getPrecision(), this.getCurrencySymbols(), this.getSymbolsPosition());
                format.applyPattern(tempPattern);
            }
        } else {
            String tempPattern = KDBusiCurrencyField.generatePatter(this.getPrecision(), "", this.getSymbolsPosition());
            format.applyPattern(tempPattern);
        }
    }

    @Override
    protected void exConfigEditFormat(DecimalFormat format) {
        super.exConfigEditFormat(format);
    }

    public int getSymbolsPosition() {
        return this.symbolsPosition;
    }

    public void setSymbolsPosition(int newValue) {
        int old;
        if (this.symbolsPosition != 2 || this.symbolsPosition != 4) {
            newValue = 4;
        }
        if ((old = this.symbolsPosition) != newValue) {
            this.symbolsPosition = newValue;
            if (this.isImmediatelyValidate()) {
                this.createDisEdiFormatterAgain(40);
            }
        }
    }

    @Override
    public boolean isRemoveingZeroInDispaly() {
        return super.isRemoveingZeroInDispaly();
    }

    private static String generatePatter(int precision, String sym, int position) {
        StringBuffer sb = new StringBuffer("#.");
        for (int i = 0; i < precision; ++i) {
            sb.append("0");
        }
        StringBuffer pat = new StringBuffer();
        if (sb.length() == 2) {
            pat.append("#");
        } else {
            pat.append(sb);
        }
        if (position == 2) {
            pat.insert(0, sym);
        } else {
            pat.append(sym);
        }
        return pat.toString();
    }
}

