/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing;

import com.kingdee.bos.ctrl.swing.IKDComponent;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.ActiveContainerEvent;
import com.kingdee.bos.ctrl.swing.event.ActiveContainerListener;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class KDContainer
extends JPanel
implements IKDComponent {
    private static final long serialVersionUID = 4319336366298701595L;
    public static final int EXTENDSIBLE_STYLE = 0;
    public static final int DISEXTENDSIBLE_STYLE = 1;
    public static final int NOBORDER_STYLE = 2;
    public static final int ACTIVESTYLE = 0;
    public static final int STATICSTYLE = 1;
    private static final String uiClassID = "KDContainerUI";
    private boolean expandButtonVisible = true;
    private int containerType;
    public static final int LABELSTYLE = 2;
    protected Object userObject = null;
    public static final int SHRINK = 0;
    public static final int SPREAD = 1;
    protected static final int STATE_MASK = 1;
    protected static final int STYLE_MASK = 3;
    public static final int TITLELABEL_MAXLEN = 156;
    protected JPanel contentPane;
    protected String title = "";
    protected int state = 1;
    protected int style = 1;
    protected int titleLength = 156;
    protected List actions;
    protected boolean enableActive = true;
    private JLabel msgLabel;
    private int gap = -1;
    private Insets customInsets;

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public JPanel getContentPane() {
        if (this.contentPane == null) {
            this.setContentPane(new JPanel());
        }
        return this.contentPane;
    }

    public void setContentPane(Container pane) {
        if (!(pane instanceof JPanel)) {
            throw new IllegalArgumentException("contentPane must is javax.swing.JPanel or subclass.");
        }
        if (this.contentPane != null && this.contentPane.getParent() == this) {
            this.remove(this.contentPane);
        }
        this.contentPane = (JPanel)pane;
        this.add(this.contentPane);
        this.contentPane.setOpaque(false);
    }

    public void setState(int s) {
        if (this.state == (s &= 1)) {
            return;
        }
        int oldState = this.state;
        this.state = s;
        this.firePropertyChange("State", oldState, this.state);
        if (this.state == 0) {
            this.fireActiveContainerEvent(3);
        } else {
            this.fireActiveContainerEvent(1);
        }
        this.doLayout();
    }

    public int getState() {
        return this.state;
    }

    public void setTitle(String newTitle) {
        if (newTitle == null) {
            newTitle = "";
        }
        if (newTitle.equals(this.title)) {
            return;
        }
        String oldTitle = this.title;
        this.title = newTitle;
        this.firePropertyChange("Title", oldTitle, this.title);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitleStyle(int s) {
        if (this.style != (s &= 3)) {
            int old = this.style;
            this.style = s;
            this.firePropertyChange("Style", old, this.style);
        }
    }

    public int getTitleStyle() {
        return this.style;
    }

    public void setMsgLabel(JLabel msgLabel) {
        JLabel oldLabel = this.msgLabel;
        this.msgLabel = msgLabel;
        this.firePropertyChange("MsgLabel", oldLabel, msgLabel);
    }

    public JLabel getMsgLabel() {
        return this.msgLabel;
    }

    public int getContainerType() {
        return this.containerType;
    }

    public void setContainerType(int containerType) {
        if (this.containerType != containerType) {
            this.containerType = containerType;
            if (containerType == 0) {
                this.setTitleStyle(0);
                this.setEnableActive(true);
            } else if (containerType == 1) {
                this.setTitleStyle(1);
                this.setEnableActive(false);
            } else if (containerType == 2) {
                this.setTitleStyle(2);
                this.setEnableActive(false);
            }
        }
    }

    public JButton add(Action a) {
        JButton b = this.createActionComponent(a);
        b.setAction(a);
        this.addButton(b);
        return b;
    }

    public void addButton(JButton b) {
        if (this.actions == null) {
            this.actions = new ArrayList(1);
        }
        this.actions.add(b);
        b.setSize(b.getPreferredSize().width, 19);
        this.firePropertyChange("Actions", null, b);
    }

    public void removeButton(JButton b) {
        if (this.actions == null) {
            return;
        }
        this.actions.remove(b);
        this.firePropertyChange("Actions", b, null);
    }

    public void removeAllButton() {
        if (this.actions == null) {
            return;
        }
        while (this.actions.size() > 0) {
            this.removeButton((JButton)this.actions.get(0));
        }
    }

    public Object[] getButtons() {
        if (this.actions != null) {
            return this.actions.toArray();
        }
        return new Object[0];
    }

    protected JButton createActionComponent(Action a) {
        String text = a != null ? (String)a.getValue("Name") : null;
        Icon icon = a != null ? (Icon)a.getValue("SmallIcon") : null;
        boolean enabled = a != null ? a.isEnabled() : true;
        String tooltip = a != null ? (String)a.getValue("ShortDescription") : null;
        KDWorkButton b = new KDWorkButton(text, icon){
            private static final long serialVersionUID = 8862776517849151349L;

            @Override
            protected PropertyChangeListener createActionPropertyChangeListener(Action a) {
                PropertyChangeListener pcl = KDContainer.this.createActionChangeListener(this);
                if (pcl == null) {
                    pcl = super.createActionPropertyChangeListener(a);
                }
                return pcl;
            }
        };
        ((AbstractButton)b).setEnabled(enabled);
        b.setToolTipText(tooltip);
        b.setSize(b.getPreferredSize());
        return b;
    }

    protected PropertyChangeListener createActionChangeListener(JButton b) {
        return null;
    }

    public void addActiveContainerListener(ActiveContainerListener listener) {
        this.listenerList.add(ActiveContainerListener.class, listener);
    }

    public void removeActiveContainerListener(ActiveContainerListener listener) {
        this.listenerList.remove(ActiveContainerListener.class, listener);
    }

    public ActiveContainerListener[] getActiveContainerListeners() {
        return (ActiveContainerListener[])this.listenerList.getListeners(ActiveContainerListener.class);
    }

    public void fireActiveContainerEvent(int command) {
        ActiveContainerEvent evt = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActiveContainerListener.class) continue;
            if (evt == null) {
                evt = new ActiveContainerEvent(this, command);
            }
            ((ActiveContainerListener)listeners[i + 1]).action(evt);
        }
    }

    public int getTitleLength() {
        return this.titleLength;
    }

    public void setTitleLength(int i) {
        this.titleLength = i;
    }

    public boolean isEnableActive() {
        return this.enableActive;
    }

    public void setEnableActive(boolean b) {
        if (this.enableActive != b) {
            boolean old = this.enableActive;
            this.enableActive = b;
            this.firePropertyChange("Active", old, this.enableActive);
        }
    }

    public void setGap(int i) {
        if (i < -1) {
            return;
        }
        if (this.gap != i) {
            this.gap = i;
            this.repaint();
        }
    }

    public int getGap() {
        int ret = this.gap == -1 ? (this.getTitleStyle() == 2 ? 0 : 8) : this.gap;
        return ret;
    }

    public boolean isVisibleOfExpandButton() {
        return this.expandButtonVisible;
    }

    public void setVisibleOfExpandButton(boolean newValue) {
        boolean old = this.expandButtonVisible;
        if (old != newValue) {
            this.expandButtonVisible = newValue;
            this.firePropertyChange("expandButtonVisible", (Object)old, (Object)this.expandButtonVisible);
        }
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        this.setUI(UIManager.getUI(this));
    }

    public void setCustomInsets(Insets newValue) {
        this.customInsets = newValue;
    }

    @Override
    public Insets getInsets() {
        if (this.customInsets != null) {
            return this.customInsets;
        }
        return super.getInsets();
    }

    @Override
    public void paintBorder(Graphics g) {
        if (this.getTitleStyle() != 2) {
            super.paintBorder(g);
        }
    }

    static {
        UIManager.getDefaults().put(uiClassID, "com.kingdee.bos.ctrl.swing.plaf.KingdeeContainerUI");
    }
}

