/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing;

import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.DateFormatterEx;
import com.kingdee.bos.ctrl.swing.DatePickerDownList;
import com.kingdee.bos.ctrl.swing.DateTimeEditor;
import com.kingdee.bos.ctrl.swing.IDateTimePicker;
import com.kingdee.bos.ctrl.swing.IKDComponent;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.model.AbstractDateTimeModel;
import com.kingdee.bos.ctrl.swing.model.DateTimeModel;
import com.kingdee.bos.ctrl.swing.model.IDateTimeModel;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeDatePickerUI;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.ctrl.swing.util.SwingLogUtil;
import com.kingdee.bos.ctrl.swing.util.TextComponentUtilities;
import java.awt.Insets;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class KDDatePicker
extends JComponent
implements IKDComponent,
IKDEditor,
IDateTimePicker,
IKDTextComponent {
    private static final long serialVersionUID = 193370374910836565L;
    private int labelAlignment = 7;
    private JLabel compositeLable = null;
    private int labelLength = -1;
    private static final String uiClassID = "DatePickerUI";
    private boolean selectAllOnFocus = true;
    public static final int SHOW_DOWNLIST = 0;
    public static final int SHOW_PANEL = 1;
    protected Object userObject = null;
    private DateTimeEditor editor = null;
    private JComponent renderer = null;
    private DatePickerDownList datePickerDownList = null;
    private IDateTimeModel model = null;
    private boolean hasDatePickerDownList = true;
    private boolean downListModal = false;
    private java.util.Date maxSelfDate = null;
    private java.util.Date minSelfDate = null;
    private boolean isSupportedEmpty = true;
    private boolean required = false;
    private Insets customInsets;
    private boolean showErrorInfo = true;
    private boolean isParseException = false;
    private boolean isOpenTips = false;

    public KDDatePicker() {
        this.initSomeData();
        this.createModel();
        this.createEditor();
        this.createRenderer();
        TextComponentUtilities.storeOriginalData(this);
        this.updateUI();
    }

    public void setSundayFirst(boolean sundayFirst) {
        if (!this.hasDatePickerDownList()) {
            throw new UnsupportedOperationException("I'm designed to take effect only on KDDatePicker's DatePickerDownList member, but now it hasn't one. Try invoking setHasDatePickerDownList(true) first!");
        }
        this.getDatePickerDownList().setSundayFirst(sundayFirst);
    }

    public boolean isSundayFirst() {
        if (this.hasDatePickerDownList()) {
            return this.getDatePickerDownList().isSundayFirst();
        }
        throw new UnsupportedOperationException("I'm designed to take effect only on KDDatePicker's DatePickerDownList member, but now it hasn't one. Try invoking setHasDatePickerDownList(true) first!");
    }

    public void setSelectAllOnFocus(boolean selectAllOnFocus) {
        this.selectAllOnFocus = selectAllOnFocus;
        ((BasicFormattedTextField)this.getEditor().getEditorComponent()).setSelectAllOnFocus(selectAllOnFocus);
    }

    public boolean isSelectAllOnFocus() {
        return this.selectAllOnFocus;
    }

    private void initSomeData() {
        this.minSelfDate = CtrlSwingUtilities.getMinDateValue();
        this.maxSelfDate = CtrlSwingUtilities.getMaxDateValue();
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    @Override
    public void addDataChangeListener(DataChangeListener listener) {
        this.editor.addDataChangeListener(listener);
    }

    @Override
    public void setAccessAuthority(int authority) {
        TextComponentUtilities.setAccessAuthority(this, authority);
        this.repaint();
    }

    @Override
    public int getAccessAuthority() {
        return TextComponentUtilities.getAccessAuthority(this);
    }

    protected void fireDataChanged(DataChangeEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataChangeListener.class || event == null) continue;
            ((DataChangeListener)listeners[i + 1]).dataChanged(event);
        }
    }

    @Override
    public Object getValue() {
        return this.getModel().getValue();
    }

    public Object getValue(Class c) {
        if (c != null) {
            String cName = c.getName();
            if (cName.equals("java.sql.Timestamp")) {
                return this.getTimestamp();
            }
            if (cName.equals("java.sql.Date")) {
                return this.getSqlDate();
            }
            if (cName.equals("java.util.Date")) {
                return this.getValue();
            }
            if (cName.equals("java.sql.Time")) {
                return this.getSqlTime();
            }
            throw new IllegalArgumentException("c type is not supported");
        }
        return this.getValue();
    }

    public Time getSqlTime() {
        Object obj = this.getValue();
        if (obj != null) {
            Time time = new Time(((java.util.Date)obj).getTime());
            return time;
        }
        return null;
    }

    @Override
    public void requestFocus() {
        this.getEditor().getEditorComponent().requestFocus();
    }

    @Override
    public boolean requestFocus(boolean b) {
        return this.getEditor().getEditorComponent().requestFocus(b);
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.getEditor().getEditorComponent().requestFocusInWindow();
    }

    public Timestamp getTimestamp() {
        Object obj = this.getValue();
        if (obj != null) {
            Timestamp timestamp = new Timestamp(((java.util.Date)obj).getTime());
            return timestamp;
        }
        return null;
    }

    public Date getSqlDate() {
        Object obj = this.getValue();
        if (obj != null) {
            Date sqlDate = new Date(((java.util.Date)obj).getTime());
            return sqlDate;
        }
        return null;
    }

    @Override
    public boolean isDisplay() {
        return this.isVisible();
    }

    @Override
    public void removeDataChangeListener(DataChangeListener listener) {
        this.editor.removeDataChangeListener(listener);
    }

    @Override
    public void setDisplay(boolean isDisplay) {
        this.setVisible(isDisplay);
    }

    @Override
    public void setValue(Object value) {
        if (CtrlSwingUtilities.judgeEqualsDateObj(value, (java.util.Date)this.getValue())) {
            return;
        }
        if (value != null || this.maxSelfDate != null || this.minSelfDate != null) {
            // empty if block
        }
        if (value != null) {
            if (this.maxSelfDate != null && CtrlSwingUtilities.judgeDate((java.util.Date)value, this.maxSelfDate) > 0) {
                return;
            }
            if (this.minSelfDate != null && CtrlSwingUtilities.judgeDate((java.util.Date)value, this.minSelfDate) < 0) {
                return;
            }
        }
        if (value != null && !(value instanceof java.util.Date)) {
            throw new IllegalArgumentException("value is illegal.");
        }
        this.getModel().setValue((java.util.Date)value);
        this.editor.setValue((java.util.Date)value);
        TextComponentUtilities.storeOriginalData(this);
        this.repaint();
    }

    public void setValue(Object value, boolean fireListener) {
        if (!fireListener) {
            ((AbstractDateTimeModel)this.getModel()).setDataChangeListenerFired(false);
            this.getEditor().setDataChangeListenerFired(false);
            this.setValue(value);
            ((AbstractDateTimeModel)this.getModel()).setDataChangeListenerFired(true);
            this.getEditor().setDataChangeListenerFired(true);
        } else {
            this.setValue(value);
        }
    }

    protected void createEditor() {
        this.editor = new DateTimeEditor(this);
        this.editor.setMaximumDate(this.maxSelfDate);
        this.editor.setMinimumDate(this.minSelfDate);
        this.editor.getEditorComponent().putClientProperty("combo", Boolean.TRUE);
    }

    protected JComponent createRenderer() {
        return null;
    }

    public DateTimeEditor getEdtor() {
        return this.editor;
    }

    public DateTimeEditor getEditor() {
        return this.editor;
    }

    public JComponent getRenderer() {
        return this.renderer;
    }

    protected void createDownList() {
        if (this.datePickerDownList == null) {
            this.datePickerDownList = new DatePickerDownList();
            this.datePickerDownList.setMaximumDate(this.maxSelfDate);
            this.datePickerDownList.setMinimumDate(this.minSelfDate);
            this.datePickerDownList.setTimeEditorEnabled(this.isTimeEnabled());
            this.datePickerDownList.setMilliSecondEnable(this.isMilliSecondEnable());
        }
    }

    public boolean isDownListCreated() {
        return this.datePickerDownList == null;
    }

    public DateFormat getFormat() {
        if (this.editor != null) {
            return this.editor.getFormat();
        }
        return null;
    }

    public void setDatePattern(String pattern) {
        this.editor.setDateTimePattern(pattern);
    }

    public String getDatePattern() {
        return this.editor.getDateTimePattern();
    }

    public String getText() {
        if (this.getValue() == null) {
            return "";
        }
        return this.editor.getText();
    }

    public DatePickerDownList getDatePickerDownList() {
        if (!this.hasDatePickerDownList) {
            return null;
        }
        if (this.datePickerDownList == null) {
            this.createDownList();
        }
        return this.datePickerDownList;
    }

    @Override
    public void setTimeEnabled(boolean b) {
        boolean oldB = this.isTimeEnabled();
        if (oldB != b) {
            this.getModel().setTimeEnable(b);
            this.firePropertyChange("timeEnabled", (Object)oldB, (Object)b);
        }
        if (this.datePickerDownList != null) {
            this.datePickerDownList.setTimeEditorEnabled(b);
        }
    }

    @Override
    public boolean isTimeEnabled() {
        return this.getModel().isTimeEnable();
    }

    protected void createModel() {
        if (this.model != null) {
            return;
        }
        this.model = new DateTimeModel();
        this.model.setDateEnable(true);
        this.model.setTimeEnable(false);
        this.model.setMilliSecondEnable(false);
    }

    @Override
    public IDateTimeModel getModel() {
        return this.model;
    }

    @Override
    public boolean isDateEnabled() {
        return this.getModel().isDateEnable();
    }

    @Override
    public void setDateEnabled(boolean b) {
        this.getModel().setDateEnable(true);
    }

    public void setMilliSecondEnable(boolean b) {
        boolean oldB = this.getModel().isMillisecondEnable();
        if (oldB != b) {
            this.getModel().setMilliSecondEnable(b);
            this.firePropertyChange("milliSecondEnable", oldB, b);
            if (this.hasDatePickerDownList && this.datePickerDownList != null) {
                this.datePickerDownList.setMilliSecondEnable(b);
            }
        }
    }

    public boolean isMilliSecondEnable() {
        return this.getModel().isMillisecondEnable();
    }

    @Override
    public void setEditable(boolean b) {
        if (TextComponentUtilities.setEditable(this, b)) {
            if (this.editor != null) {
                this.editor.setEditable(b);
            }
            this.repaint();
        }
    }

    @Override
    public void setEnabled(boolean newValue) {
        if (TextComponentUtilities.setEnabled(this, newValue)) {
            super.setEnabled(newValue);
            this.editor.setEnabled(newValue);
            this.setHasDatePickerDownList(newValue);
        }
        this.repaint();
    }

    @Override
    public boolean isEditable() {
        if (this.editor != null) {
            return this.editor.isEditable();
        }
        return false;
    }

    public boolean isReadOnly() {
        return this.getAccessAuthority() == 1;
    }

    public void setReadOnly(boolean readOnly) {
        if (readOnly) {
            this.setAccessAuthority(1);
        }
    }

    public boolean isSupportedEmpty() {
        return this.isSupportedEmpty;
    }

    public void setSupportedEmpty(boolean newValue) {
        this.isSupportedEmpty = newValue;
        this.getEditor().setSupportedEmpty(this.isSupportedEmpty);
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public void setRequired(boolean required) {
        boolean oldValue = this.required;
        this.required = required;
        ((BasicFormattedTextField)this.getEditor().getEditorComponent()).setRequired(required);
        this.firePropertyChange("required", new Boolean(oldValue), new Boolean(required));
    }

    public void commitEdit() throws ParseException {
        block3: {
            JComponent editor = this.getEditor().getEditorComponent();
            try {
                if (editor instanceof JFormattedTextField) {
                    ((JFormattedTextField)editor).commitEdit();
                }
            }
            catch (ParseException pe) {
                if (this.isSupportedEmpty() && ((BasicFormattedTextField)editor).isFoucusLost()) break block3;
                throw pe;
            }
        }
    }

    public void setMaxMinDate(java.util.Date maxDate, java.util.Date minDate) {
        if (maxDate == null && minDate == null) {
            this.maxSelfDate = null;
            this.minSelfDate = null;
            this.setOtherMaxDate(this.maxSelfDate);
            this.setOtherMinDate(this.minSelfDate);
        } else if (maxDate != null && minDate != null && CtrlSwingUtilities.judgeDate(maxDate, minDate) >= 0) {
            if (CtrlSwingUtilities.judgeDate(maxDate, (java.util.Date)this.getValue()) >= 0) {
                this.maxSelfDate = new java.util.Date(maxDate.getTime());
                this.setOtherMaxDate(this.maxSelfDate);
            }
            if (CtrlSwingUtilities.judgeDate(minDate, (java.util.Date)this.getValue()) <= 0) {
                this.minSelfDate = new java.util.Date(minDate.getTime());
                this.setOtherMinDate(this.minSelfDate);
            }
        } else if (maxDate != null && minDate == null) {
            this.minSelfDate = null;
            this.setMaximumDate(maxDate);
        } else if (maxDate == null && minDate != null) {
            this.maxSelfDate = null;
            this.setMinimumDate(minDate);
        } else {
            return;
        }
    }

    private void setOtherMaxDate(java.util.Date maxDate) {
        if (this.datePickerDownList != null) {
            this.datePickerDownList.setMaximumDate(maxDate);
        }
        this.editor.setMaximumDate(maxDate);
    }

    private void setOtherMinDate(java.util.Date minDate) {
        if (this.datePickerDownList != null) {
            this.datePickerDownList.setMinimumDate(minDate);
        }
        this.editor.setMinimumDate(minDate);
    }

    public void setMaximumDate(java.util.Date newMaxDate) {
        if (newMaxDate != null) {
            java.util.Date tempDate = null;
            if (this.minSelfDate != null && CtrlSwingUtilities.judgeDate(newMaxDate, this.minSelfDate) <= 0) {
                SwingLogUtil.info((String)"\u8b66\u544a\uff1a\u7ed9\u65e5\u671f\u63a7\u4ef6\u8bbe\u7f6e\u7684\u6700\u5927\u65e5\u671f\u503c \u5c0f\u4e8e \u6700\u5c0f\u65e5\u671f\u503c\uff0c\u8bf7\u6539\u6b63\u3002");
                return;
            }
            tempDate = new java.util.Date(newMaxDate.getTime());
            if (CtrlSwingUtilities.judgeDate(newMaxDate, (java.util.Date)this.getValue()) < 0) {
                SwingLogUtil.info((String)"\u8b66\u544a\uff1a\u7ed9\u65e5\u671f\u63a7\u4ef6\u8bbe\u7f6e\u7684\u6700\u5927\u65e5\u671f\u503c \u5c0f\u4e8e\u63a7\u4ef6\u7684\u5f53\u524d\u503c\uff0c\u8bf7\u6539\u6b63\u3002");
                return;
            }
            this.maxSelfDate = tempDate;
            Object var2_2 = null;
        } else {
            this.maxSelfDate = null;
        }
        this.setOtherMaxDate(this.maxSelfDate);
    }

    public java.util.Date getMaximumDate() {
        return this.maxSelfDate;
    }

    public void setMinimumDate(java.util.Date newMinDate) {
        if (CtrlSwingUtilities.judgeEqualsDateObj(newMinDate, this.minSelfDate)) {
            return;
        }
        if (newMinDate != null) {
            java.util.Date tempDate = null;
            if (this.maxSelfDate != null && newMinDate.compareTo(this.maxSelfDate) >= 0) {
                SwingLogUtil.info((String)"\u8b66\u544a\uff1a\u7ed9\u65e5\u671f\u63a7\u4ef6\u8bbe\u7f6e\u7684\u6700\u5c0f\u65e5\u671f\u503c \u5927\u4e8e \u6700\u5927\u65e5\u671f\u503c\uff0c\u8bf7\u6539\u6b63\u3002");
                return;
            }
            tempDate = new java.util.Date(newMinDate.getTime());
            if (CtrlSwingUtilities.judgeDate(newMinDate, (java.util.Date)this.getValue()) > 0) {
                return;
            }
            this.minSelfDate = tempDate;
            Object var2_2 = null;
        } else {
            this.minSelfDate = null;
        }
        this.setOtherMinDate(this.minSelfDate);
    }

    public java.util.Date getMinimumDate() {
        return this.minSelfDate;
    }

    public void setHasDatePickerDownList(boolean b) {
        boolean old = this.hasDatePickerDownList;
        if (old != b) {
            this.hasDatePickerDownList = b;
            this.firePropertyChange("hasDatePickerDownList", (Object)old, (Object)b);
        }
    }

    public boolean hasDatePickerDownList() {
        return this.hasDatePickerDownList;
    }

    public void setDownListModal(boolean modal) {
        boolean oldModal = modal;
        if (oldModal != modal) {
            this.downListModal = modal;
            this.firePropertyChange("downListModal", (Object)oldModal, (Object)modal);
        }
    }

    public boolean isDownListModal() {
        return this.downListModal;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public KingdeeDatePickerUI getUI() {
        return (KingdeeDatePickerUI)this.ui;
    }

    public void setUI(KingdeeDatePickerUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        this.setUI((KingdeeDatePickerUI)UIManager.getUI(this));
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
        Map additionalValues = (Map)s.readObject();
        this.model = (IDateTimeModel)additionalValues.get("model");
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        HashMap<String, IDateTimeModel> additionalValues = new HashMap<String, IDateTimeModel>(1);
        IDateTimeModel model = this.getModel();
        if (model instanceof Serializable) {
            additionalValues.put("model", model);
        }
        s.writeObject(additionalValues);
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
    }

    public void setLabelAlignment(int newLabelAlignment) {
        if (this.validateLabelAlignment(newLabelAlignment)) {
            int old = this.getLabelAlignment();
            if (old != newLabelAlignment) {
                this.labelAlignment = newLabelAlignment;
                this.firePropertyChange("labelAlignment", new Integer(old), new Integer(this.labelAlignment));
            }
        } else {
            throw new IllegalArgumentException("labelAlignment is invalidate.please see javax.swing.SwingConstants");
        }
    }

    public int getLabelAlignment() {
        return this.labelAlignment;
    }

    public void setLabelText(String newLabelText) {
        String old = this.getLabelText();
        if (newLabelText != null && old != newLabelText) {
            if (this.getCompositeLabel() == null) {
                this.setCompositeLabel(new JLabel());
            }
            this.getCompositeLabel().setText(newLabelText);
            this.repaint();
        }
    }

    public String getLabelText() {
        if (this.getCompositeLabel() != null) {
            return this.getCompositeLabel().getText();
        }
        return null;
    }

    public void setCompositeLabel(JLabel newLabel) {
        JLabel old;
        if (newLabel != null && (old = this.getCompositeLabel()) != newLabel) {
            this.compositeLable = newLabel;
            this.firePropertyChange("compositeLabel", old, newLabel);
        }
    }

    public JLabel getCompositeLabel() {
        if (this.compositeLable == null) {
            this.compositeLable = new KDLabel();
        }
        return this.compositeLable;
    }

    public void setLabelLength(int len) {
        int old = this.getLabelLength();
        if (old != len) {
            this.labelLength = len;
            this.firePropertyChange("labelLength", new Integer(old), new Integer(len));
        }
    }

    public int getLabelLength() {
        return this.labelLength;
    }

    private boolean validateLabelAlignment(int labelAli) {
        switch (labelAli) {
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setFocusTraversalKeysEnabled(boolean b) {
        super.setFocusTraversalKeysEnabled(b);
        this.getEditor().getEditorComponent().setFocusTraversalKeysEnabled(b);
    }

    public void setCustomInsets(Insets newValue) {
        this.customInsets = newValue;
    }

    @Override
    public Insets getInsets() {
        if (this.customInsets != null) {
            return this.customInsets;
        }
        return super.getInsets();
    }

    public boolean isShowErrorInfo() {
        return this.showErrorInfo;
    }

    public void setShowErrorInfo(boolean showErrorInfo) {
        this.showErrorInfo = showErrorInfo;
    }

    public void setViewing(boolean isViewing) {
        this.setEditable(!isViewing);
        ((DateFormatterEx)((JFormattedTextField)this.getEditor().getEditorComponent()).getFormatter()).setSupportIncrement(!isViewing);
        this.setHasDatePickerDownList(!isViewing);
    }

    public boolean isParseException() {
        return this.isParseException;
    }

    public void setParseException(boolean isParseException) {
        this.isParseException = isParseException;
    }

    public boolean isOpenTips() {
        return this.isOpenTips;
    }

    public void setOpenTips(boolean isOpenTips) {
        this.isOpenTips = isOpenTips;
    }

    static {
        UIManager.getDefaults().put(uiClassID, "com.kingdee.bos.ctrl.swing.plaf.KingdeeDatePickerUI");
    }
}

