/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.ctrl.common.util.STConverter;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.swing.IAutoToolTipText;
import com.kingdee.bos.ctrl.swing.IKDComponent;
import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.ctrl.swing.ITextLengthLimit;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextAreaCtrl;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeMultiLangAreaUI;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeMultiLangBoxUI;
import com.kingdee.bos.ctrl.swing.plaf.MultiLangAreaEditor;
import com.kingdee.bos.ctrl.swing.plaf.MultiLangBoxEditor;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.ctrl.swing.util.TextComponentUtilities;
import com.kingdee.util.LocaleUtils;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.swing.ComboBoxEditor;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;

public class KDMultiLangBox
extends KDComboBox
implements IKDComponent,
ITextLengthLimit,
IKDTextComponent {
    private static final long serialVersionUID = 6873538445066645345L;
    private static final String chineseReg = "[\u4e00-\u9fa5]";
    private static Pattern pattern = Pattern.compile("[\u4e00-\u9fa5]");
    protected Object userObject = null;
    public static final int DEFAULTSTYLE = 0;
    public static final int MULTILINE = 1;
    private Insets customInsets;
    private boolean required = false;
    private boolean selectAllOnFocus = true;
    private boolean firelistener = true;
    private static boolean shouldSync = false;
    private Object realData;

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public void setRequired(boolean required) {
        boolean old = this.required;
        this.required = required;
        if (this.isEnabled() && this.isEditable() && required) {
            this.setBackground(UIManager.getColor("TextField.requiredBackground"));
            this.setForeground(UIManager.getColor("TextField.requiredForeground"));
            this.repaint();
        }
        this.firePropertyChange("required", new Boolean(old), new Boolean(required));
    }

    public void setSelectAllOnFocus(boolean selectAllOnFocus) {
        this.selectAllOnFocus = selectAllOnFocus;
        Component comp = this.getEditorComponent();
        if (comp instanceof KDTextField) {
            ((KDTextField)comp).setSelectAllOnFocus(selectAllOnFocus);
        } else if (comp instanceof KDTextArea) {
            ((KDTextArea)comp).setSelectAllOnFocus(selectAllOnFocus);
        }
    }

    public boolean isSelectAllOnFocus() {
        return this.selectAllOnFocus;
    }

    @Override
    public void setBorder(Border b) {
        super.setBorder(b);
    }

    public KDMultiLangBox() {
        this.setComboBoxEditable(true);
        this.setAutoToolTipText(true);
        TextComponentUtilities.storeOriginalData(this);
        CtrlSwingUtilities.addManagingFocusForwardTraversalKeys(this, KeyStroke.getKeyStroke(10, 0));
    }

    public KDMultiLangBox(int style) {
        if (style == 1) {
            super.setUI(KingdeeMultiLangAreaUI.createUI(this));
        } else {
            this.setAutoToolTipText(true);
        }
        this.setComboBoxEditable(true);
        TextComponentUtilities.storeOriginalData(this);
        CtrlSwingUtilities.addManagingFocusForwardTraversalKeys(this, KeyStroke.getKeyStroke(10, 0));
    }

    @Override
    public void updateUI() {
        super.setUI(KingdeeMultiLangBoxUI.createUI(this));
    }

    @Override
    public void setCustomInsets(Insets newValue) {
        this.customInsets = newValue;
    }

    @Override
    public Insets getInsets() {
        if (this.customInsets != null) {
            return this.customInsets;
        }
        return super.getInsets();
    }

    public void addLanguage(LanguageInfo lang) {
        MultiLangItem item = this.findItemByLang(lang);
        if (item == null) {
            item = new MultiLangItem(lang, null);
            super.addItem(item);
        }
    }

    public void removeLanguage(LanguageInfo lang) {
        MultiLangItem item = this.findItemByLang(lang);
        if (item != null) {
            this.removeItem(item);
        }
    }

    public void addItem(LanguageInfo lang, Object data) {
        MultiLangItem item = new MultiLangItem(lang, data);
        this.addItem(item);
    }

    public MultiLangItem getItemBy(LanguageInfo lang) {
        return this.findItemByLang(lang);
    }

    public void addItem(MultiLangItem newItem) {
        MultiLangItem item = this.findItemByLang(newItem.getLang());
        if (item == null) {
            super.addItem(newItem);
        } else {
            this.updateItemData(item, newItem.getData());
        }
        this.updateText(item);
    }

    public void removeItem(MultiLangItem item) {
        super.removeItem(item);
    }

    public void setSelectedLanguage(LanguageInfo lang) {
        MultiLangItem item = this.findItemByLang(lang);
        if (item != null) {
            this.setSelectedItem(item);
        }
    }

    public void setSelectedLanguage(LanguageInfo lang, boolean fireListener) {
        MultiLangItem item = this.findItemByLang(lang);
        if (item != null) {
            if (!fireListener) {
                this.firelistener = false;
                this.setSelectedItem(item);
                this.firelistener = true;
            } else {
                this.setSelectedItem(item);
            }
        }
    }

    @Override
    protected void fireItemStateChanged(ItemEvent e) {
        if (!this.firelistener) {
            ItemListener[] savedItemListeners = this.getItemListeners();
            if (savedItemListeners != null) {
                for (int i = savedItemListeners.length - 1; i >= 0; --i) {
                    if (!(savedItemListeners[i] instanceof KingdeeMultiLangBoxUI.MulitLangItemHandler)) continue;
                    savedItemListeners[i].itemStateChanged(e);
                }
            }
        } else {
            super.fireItemStateChanged(e);
        }
    }

    @Override
    protected void fireActionEvent() {
        if (!this.firelistener) {
            return;
        }
        super.fireActionEvent();
    }

    public void setSelectedItemData(Object data) {
        this.setSelectedItemData(data, true);
    }

    public void setSelectedItemData(Object data, boolean updateText) {
        Object item = this.getSelectedItem();
        if (item != null && item instanceof MultiLangItem) {
            MultiLangItem selectedItem = (MultiLangItem)item;
            Locale selectLoc = selectedItem.getLang().getStandarlocale();
            if ((selectLoc.equals(Locale.TRADITIONAL_CHINESE) || selectLoc.equals(Locale.SIMPLIFIED_CHINESE)) && data instanceof String && data != null) {
                MultiLangItem destItem;
                String src = ((String)data).trim();
                if (selectLoc.equals(Locale.CHINA)) {
                    MultiLangItem destItem2 = this.findItemByStanderLang(new LanguageInfo(Locale.TRADITIONAL_CHINESE));
                    if (destItem2 != null) {
                        Object selectedItemData = selectedItem.getData();
                        Object destItemData = destItem2.getData();
                        if (destItemData == null || destItemData.equals(selectedItemData) || destItemData instanceof String && STConverter.sc2tc((String)((String)selectedItemData).trim()).equals(((String)destItemData).trim())) {
                            this.updateItemData(destItem2, STConverter.sc2tc((String)src));
                        }
                    }
                } else if (selectLoc.equals(Locale.TRADITIONAL_CHINESE) && (destItem = this.findItemByStanderLang(new LanguageInfo(Locale.CHINA))) != null) {
                    Object selectedItemData = selectedItem.getData();
                    Object destItemData = destItem.getData();
                    if (destItemData == null || destItemData.equals(selectedItemData) || destItemData instanceof String && STConverter.tc2sc((String)((String)selectedItemData).trim()).equals(((String)destItemData).trim())) {
                        this.updateItemData(destItem, STConverter.tc2sc((String)src));
                    }
                }
            }
            this.updateItemData((MultiLangItem)item, data);
            if (updateText) {
                this.updateText((MultiLangItem)item);
            }
        }
    }

    public static void multiLangBoxShouldSyncData(boolean flag) {
        shouldSync = flag;
    }

    public void syncNullItemData() {
        if (!shouldSync) {
            return;
        }
        Object obj = this.getSelectedItem();
        if (obj instanceof MultiLangItem) {
            MultiLangItem item = (MultiLangItem)obj;
            int itemCount = this.getItemCount();
            for (int i = 0; i < itemCount; ++i) {
                Object tObj = this.getItemAt(i);
                if (!(obj instanceof MultiLangItem)) continue;
                MultiLangItem temp = (MultiLangItem)tObj;
                Object t = temp.getData();
                if (temp == item || !(t instanceof String) || !this.isChina(item) || !StringUtil.isEmptyString((String)((String)temp.getData()))) continue;
                this.updateItemData(temp, item.getData());
            }
        }
    }

    private boolean isChina(MultiLangItem item) {
        return item.getLang().getLocale().equals(LocaleUtils.getLocale((String)"l2")) || item.getLang().getLocale().equals(LocaleUtils.getLocale((String)"l3"));
    }

    public void setItemData(LanguageInfo lang, Object data) {
        this.addItem(lang, data);
    }

    @Override
    public boolean hasFocus() {
        boolean br = super.hasFocus();
        if (br) {
            return br;
        }
        ComboBoxEditor edt = this.getEditor();
        if (edt instanceof MultiLangBoxEditor) {
            br = ((MultiLangBoxEditor)edt).hasFocus();
        } else if (edt instanceof MultiLangAreaEditor) {
            br = ((MultiLangAreaEditor)edt).hasFocus();
        }
        return br;
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    @Override
    public void setAccessAuthority(int authority) {
        TextComponentUtilities.setAccessAuthority(this, authority);
    }

    @Override
    public int getAccessAuthority() {
        return TextComponentUtilities.getAccessAuthority(this);
    }

    public Object getSelectedItemData() {
        this.syncNullItemData();
        MultiLangItem item = (MultiLangItem)this.getSelectedItem();
        if (item != null) {
            return item.getData();
        }
        return null;
    }

    public Object getItemDataByLang(LanguageInfo lang) {
        this.syncNullItemData();
        MultiLangItem item = this.findItemByLang(lang);
        if (item != null) {
            return item.getData();
        }
        return null;
    }

    public Object getDefaultLangItemData() {
        Locale locale = this.getLocale();
        locale = BOSLocaleUtil.ZH_CN.equals(locale) ? LocaleUtils.locale_L2 : (BOSLocaleUtil.ZH_TW.equals(locale) ? LocaleUtils.locale_L3 : (BOSLocaleUtil.EN_US.equals(locale) ? LocaleUtils.locale_L1 : LocaleUtils.locale_L1));
        LanguageInfo lang = new LanguageInfo(locale);
        return this.findItemByLang(lang);
    }

    public void setDefaultLangItemData(Object data) {
        Locale locale = this.getLocale();
        locale = BOSLocaleUtil.ZH_CN.equals(locale) ? LocaleUtils.locale_L2 : (BOSLocaleUtil.ZH_TW.equals(locale) ? LocaleUtils.locale_L3 : (BOSLocaleUtil.EN_US.equals(locale) ? LocaleUtils.locale_L1 : LocaleUtils.locale_L1));
        LanguageInfo lang = new LanguageInfo(locale);
        this.setItemData(lang, data);
    }

    public void selectedDefaultLangItem() {
        Locale locale = this.getLocale();
        locale = BOSLocaleUtil.ZH_CN.equals(locale) ? LocaleUtils.locale_L2 : (BOSLocaleUtil.ZH_TW.equals(locale) ? LocaleUtils.locale_L3 : (BOSLocaleUtil.EN_US.equals(locale) ? LocaleUtils.locale_L1 : LocaleUtils.locale_L1));
        LanguageInfo lang = new LanguageInfo(locale);
        MultiLangItem item = this.findItemByLang(lang);
        if (item != null) {
            this.setSelectedItem(item);
        }
    }

    protected MultiLangItem findItemByLang(LanguageInfo lang) {
        this.syncNullItemData();
        MultiLangItem item = null;
        int itemCount = this.getItemCount();
        for (int i = 0; i < itemCount && !(item = (MultiLangItem)this.getItemAt(i)).getLang().isSameLanguage(lang); ++i) {
            item = null;
        }
        return item;
    }

    protected MultiLangItem findItemByStanderLang(LanguageInfo lang) {
        MultiLangItem item = null;
        int itemCount = this.getItemCount();
        for (int i = 0; i < itemCount && !(item = (MultiLangItem)this.getItemAt(i)).getLang().isSameStandarLanguage(lang); ++i) {
            item = null;
        }
        return item;
    }

    private void updateItemData(MultiLangItem item, Object data) {
        if (item != null) {
            item.setData(data);
        }
    }

    private void updateText(MultiLangItem item) {
        Object selectedItem = this.getSelectedItem();
        if (selectedItem == null) {
            if (this.getItemCount() > 0) {
                this.setSelectedIndex(0);
            }
        } else if (item == selectedItem) {
            ComboBoxEditor edt = this.getEditor();
            if (edt instanceof MultiLangBoxEditor) {
                JTextField tf = (JTextField)edt.getEditorComponent();
                tf.setText(item.toString());
            } else if (edt instanceof MultiLangAreaEditor) {
                KDTextAreaCtrl tac = (KDTextAreaCtrl)edt.getEditorComponent();
                tac.getTextComponent().setText(item.toString());
            }
        }
    }

    public void updateText() {
        String text = "";
        MultiLangItem selectedItem = (MultiLangItem)this.getSelectedItem();
        if (selectedItem != null) {
            ComboBoxEditor edt;
            Object data = selectedItem.getData();
            if (data != null) {
                text = data.toString();
            }
            if ((edt = this.getEditor()) instanceof MultiLangBoxEditor) {
                JTextField tf = (JTextField)edt.getEditorComponent();
                tf.setText(text);
            } else if (edt instanceof MultiLangAreaEditor) {
                KDTextAreaCtrl tac = (KDTextAreaCtrl)edt.getEditorComponent();
                tac.getTextComponent().setText(text);
            }
        }
    }

    @Override
    public void addItem(Object o) {
        if (o instanceof MultiLangItem) {
            this.addItem((MultiLangItem)o);
        }
    }

    public Component getEditorComponent() {
        JTextComponent comp = null;
        ComboBoxEditor edt = this.getEditor();
        if (edt instanceof MultiLangBoxEditor) {
            comp = (KDTextField)edt.getEditorComponent();
            ((JComponent)comp).setOpaque(false);
        } else if (edt instanceof MultiLangAreaEditor) {
            KDTextAreaCtrl tac = (KDTextAreaCtrl)edt.getEditorComponent();
            comp = tac.getTextComponent();
            tac.setOpaque(false);
            tac.getViewport().setOpaque(false);
            ((JComponent)comp).setOpaque(false);
        }
        return comp;
    }

    @Override
    public void setEnabled(boolean aFlag) {
        if (TextComponentUtilities.setEnabled(this, aFlag)) {
            super.setEnabled(aFlag);
            ComboBoxEditor edt = this.getEditor();
            if (edt instanceof MultiLangBoxEditor) {
                JTextField tf = (JTextField)edt.getEditorComponent();
                tf.setEditable(this.isEditable);
                if (aFlag) {
                    tf.setEnabled(true);
                    this.setBackground(UIManager.getColor("TextField.background"));
                    this.getEditorComponent().setForeground(UIManager.getColor("TextField.foreground"));
                    this.setEditable(this.isEditable());
                } else {
                    tf.setEnabled(false);
                    this.setBackground(UIManager.getColor("TextField.disabledBackground"));
                    this.getEditorComponent().setForeground(UIManager.getColor("TextField.disabledForeground"));
                    this.repaint();
                }
            } else if (edt instanceof MultiLangAreaEditor) {
                KDTextAreaCtrl tac = (KDTextAreaCtrl)edt.getEditorComponent();
                tac.setEditable(this.isEditable);
                if (aFlag) {
                    tac.setEnabled(true);
                    this.setBackground(UIManager.getColor("TextField.background"));
                    this.getEditorComponent().setForeground(UIManager.getColor("TextField.foreground"));
                    this.setEditable(this.isEditable());
                } else {
                    tac.setEnabled(false);
                    this.setBackground(UIManager.getColor("TextField.disabledBackground"));
                    this.getEditorComponent().setForeground(UIManager.getColor("TextField.disabledForeground"));
                    this.repaint();
                }
            }
        }
    }

    @Override
    public void setEditable(boolean aFlag) {
        if (TextComponentUtilities.setEditable(this, aFlag)) {
            this.isEditable = aFlag;
            ComboBoxEditor edt = this.getEditor();
            if (edt instanceof MultiLangBoxEditor) {
                JTextField tf = (JTextField)edt.getEditorComponent();
                tf.setEditable(this.isEditable);
                if (this.isEnabled()) {
                    if (aFlag) {
                        this.setBackground(UIManager.getColor("TextField.background"));
                        this.getEditorComponent().setForeground(UIManager.getColor("TextField.foreground"));
                        this.setRequired(this.isRequired());
                    } else {
                        this.setBackground(UIManager.getColor("TextField.disableBackground"));
                        this.getEditorComponent().setForeground(UIManager.getColor("TextField.disabledForeground"));
                        this.repaint();
                    }
                }
            } else if (edt instanceof MultiLangAreaEditor) {
                KDTextAreaCtrl tac = (KDTextAreaCtrl)edt.getEditorComponent();
                tac.setEditable(this.isEditable);
                if (this.isEnabled()) {
                    if (aFlag) {
                        if (this.isRequired()) {
                            this.setRequired(true);
                        } else {
                            this.setBackground(UIManager.getColor("TextField.background"));
                            this.getEditorComponent().setForeground(UIManager.getColor("TextField.foreground"));
                        }
                    } else {
                        this.setBackground(UIManager.getColor("TextField.background"));
                        this.getEditorComponent().setForeground(UIManager.getColor("TextField.disabledForeground"));
                    }
                }
            }
        }
        this.repaint();
    }

    private void setComboBoxEditable(boolean b) {
        super.setEditable(b);
    }

    public void setAutoToolTipText(boolean b) {
        Component comp = this.getEditorComponent();
        if (comp instanceof IAutoToolTipText) {
            ((IAutoToolTipText)((Object)comp)).setAutoToolTipText(b);
        }
    }

    public boolean isAutoToolTipText() {
        Component comp = this.getEditorComponent();
        if (comp instanceof IAutoToolTipText) {
            return ((IAutoToolTipText)((Object)comp)).isAutoToolTipText();
        }
        return false;
    }

    @Override
    public int getMaxLength() {
        int len = -1;
        Component comp = this.getEditorComponent();
        if (comp instanceof ITextLengthLimit) {
            len = ((ITextLengthLimit)((Object)comp)).getMaxLength();
        }
        return len;
    }

    @Override
    public int getMinLength() {
        int len = -1;
        Component comp = this.getEditorComponent();
        if (comp instanceof ITextLengthLimit) {
            len = ((ITextLengthLimit)((Object)comp)).getMaxLength();
        }
        return len;
    }

    @Override
    public void setMaxLength(int len) {
        Component comp = this.getEditorComponent();
        if (comp instanceof ITextLengthLimit) {
            ((ITextLengthLimit)((Object)comp)).setMaxLength(len);
        }
    }

    @Override
    public void setMinLength(int len) {
        Component comp = this.getEditorComponent();
        if (comp instanceof ITextLengthLimit) {
            ((ITextLengthLimit)((Object)comp)).setMinLength(len);
        }
    }

    @Override
    public void configureEditor(ComboBoxEditor anEditor, Object anItem) {
        anEditor.setItem(anItem);
    }

    @Override
    public void desensitization(ActionEvent e) {
        super.desensitization(e);
        if (!this.getIsDesensitization() && this.realData != null) {
            this.configureEditor(this.getEditor(), this.realData);
        } else {
            this.configureEditor(this.getEditor(), super.getSelectedItemDesensitization());
        }
    }

    @Override
    public Object getSelectedItemDesensitization() {
        Object selectedItem = super.getSelectedItem();
        if (selectedItem instanceof MultiLangItem) {
            this.realData = ((MultiLangItem)selectedItem).getData();
        }
        return super.getSelectedItemDesensitization();
    }
}

