/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing;

import com.kingdee.bos.ctrl.swing.BarPartArea;
import com.kingdee.bos.ctrl.swing.ButtonActionPropertyListenerEx;
import com.kingdee.bos.ctrl.swing.ButtonPropertyConfigurer;
import com.kingdee.bos.ctrl.swing.ITextIconDisplayStyle;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeWorkButtonUI;
import com.kingdee.bos.ctrl.swing.util.CtrlImageUtilities;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class KDWorkButton
extends JButton
implements ITextIconDisplayStyle {
    private static final long serialVersionUID = 8575077660059272538L;
    public static final int HORIZONTAL_WRAP = 1;
    public static final int VERTICAL = 0;
    private int assistComponentLayoutOrientation = 0;
    private static final Insets selfMargin = new Insets(2, 4, 2, 24);
    private JPanel assistContentPane = null;
    private int arrowOrientation = 3;
    private int maxAssistComponentCount = 16;
    private KDPopupMenu popupMenu = null;
    protected Object userObject = null;
    public static final int BLUE_FACE = 0;
    public static final int GRAY_FACE = 1;
    private int faceType = 1;
    private Icon selfDisableIcon = null;
    private short textIconStyle = (short)-1;
    private boolean isControlByParent = true;
    private static final String uiClassID = "WorkButtonUI";
    private Insets customInsets;
    private boolean isSeparatorVisible = false;
    private boolean autoToolTipText;

    public KDWorkButton(Action action) {
        super(action);
        this.init();
    }

    public KDWorkButton() {
        this.init();
    }

    public KDWorkButton(String text) {
        super(text);
        this.init();
    }

    public KDWorkButton(String text, Icon icon) {
        super(text, icon);
        this.init();
    }

    public KDWorkButton(Icon icon) {
        super(icon);
        this.init();
    }

    public void setCustomInsets(Insets newValue) {
        this.customInsets = newValue;
    }

    @Override
    public Insets getInsets() {
        if (this.customInsets != null) {
            return this.customInsets;
        }
        return super.getInsets();
    }

    private void init() {
        this.faceType = 1;
        this.setMargin(new Insets(2, 4, 2, 5));
        this.putClientProperty("IsInArrowScope", Boolean.FALSE);
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys(this, KeyStroke.getKeyStroke(10, 0));
        this.setAutoToolTipText(true);
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        Container comp = this.getParent();
        if (comp instanceof KDToolBar) {
            if (comp.getParent() instanceof BarPartArea.KDToolBarRowContainer) {
                comp = comp.getParent();
                ((BarPartArea.KDToolBarRowContainer)comp).validate();
                ((BarPartArea.KDToolBarRowContainer)comp).repaint();
            } else {
                ((KDToolBar)comp).doLayout();
                ((KDToolBar)comp).repaint();
            }
        }
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        Container comp = this.getParent();
        if (comp instanceof KDToolBar) {
            ((KDToolBar)comp).doLayout();
            ((KDToolBar)comp).repaint();
        }
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public JComponent addAssitButton(JComponent comp) {
        if (comp != null) {
            this.resetSelfMargin();
            this.getAssistPopup().add(comp);
        }
        return comp;
    }

    private void resetSelfMargin() {
        Insets oldMargin = this.getMargin();
        if (!oldMargin.equals(selfMargin)) {
            this.setMargin((Insets)selfMargin.clone());
        }
    }

    public void removeAssitButton(int index) {
        this.getAssistPopup().remove(index);
    }

    public void removeAllAssistButton() {
        this.getAssistPopup().removeAll();
        this.invalidate();
        Container pa = this.getParent();
        if (pa != null) {
            pa.validate();
        }
        this.repaint();
    }

    public JComponent getAssitButton(int index) {
        return (JComponent)this.getAssistPopup().getComponent(index);
    }

    public JComponent[] getAssitButtons() {
        return (JComponent[])this.getAssistPopup().getComponents();
    }

    public boolean isAssitButton() {
        return this.getAssistPopup().getComponentCount() > 0;
    }

    public int getAssistButtonCount() {
        return this.getAssistPopup().getComponentCount();
    }

    public void setMaxAssistComponentCount(int newValue) {
        int old = this.getMaxAssistComponentCount();
        if (old != newValue) {
            this.maxAssistComponentCount = newValue;
            this.firePropertyChange("maxAssistComponentCount", new Integer(newValue), new Integer(newValue));
        }
    }

    public int getMaxAssistComponentCount() {
        return this.maxAssistComponentCount;
    }

    public KDWorkButton addAssitButton(Action action) {
        KDWorkButton button = new KDWorkButton(action);
        return (KDWorkButton)this.addAssitButton(button);
    }

    public JMenuItem addAssistMenuItem(Action action) {
        JMenuItem tempMI = this.getAssistPopup().add(action);
        if (tempMI != null) {
            this.resetSelfMargin();
        }
        return tempMI;
    }

    public void addSeparator() {
        this.getAssistPopup().addSeparator();
    }

    public JMenuItem addAssistMenuItem(JMenuItem menuItem) {
        if (menuItem != null) {
            this.resetSelfMargin();
            this.getAssistPopup().add(menuItem);
        }
        return menuItem;
    }

    public void addAssistContainerListener(ContainerListener l) {
        this.getAssistPopup().addContainerListener(l);
    }

    public void removeAssistContainerListener(ContainerListener l) {
        this.getAssistPopup().removeContainerListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPanel getAssistContentPane() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.assistContentPane == null) {
                this.createAssistContentPane();
            }
            return this.assistContentPane;
        }
    }

    public KDPopupMenu getAssistPopup() {
        if (this.popupMenu == null) {
            this.popupMenu = new KDPopupMenu();
        }
        return this.popupMenu;
    }

    public void setAssistPopup(KDPopupMenu menu) {
        this.popupMenu = menu;
        this.resetSelfMargin();
    }

    protected void createAssistContentPane() {
        int count;
        if (this.assistContentPane != null && (count = this.assistContentPane.getComponentCount()) > 0) {
            this.assistContentPane.removeAll();
        }
        this.assistContentPane = new JPanel(new GridLayout(4, 1));
    }

    public void setArrowOrientation(int newValue) {
        int old = this.getArrowOrientation();
        if (old != newValue) {
            this.arrowOrientation = newValue;
            this.firePropertyChange("arrowOrientation", new Integer(old), new Integer(newValue));
        }
    }

    @Override
    protected void fireActionPerformed(ActionEvent event) {
        Boolean b = (Boolean)this.getClientProperty("IsInArrowScope");
        if (b != null && b.booleanValue()) {
            return;
        }
        super.fireActionPerformed(event);
    }

    public int getArrowOrientation() {
        return this.arrowOrientation;
    }

    @Override
    protected void configurePropertiesFromAction(Action a) {
        ButtonPropertyConfigurer.configure(this, a);
    }

    @Override
    protected PropertyChangeListener createActionPropertyChangeListener(Action a) {
        return new ButtonActionPropertyListenerEx(this, a);
    }

    public int getAssistComponentLayoutOrientation() {
        return this.assistComponentLayoutOrientation;
    }

    public void setAssistComponentLayoutOrientation(int i) {
        this.assistComponentLayoutOrientation = i;
        this.reLayout();
    }

    private void reLayout() {
        if (this.getAssistComponentLayoutOrientation() == 1) {
            int rowCount = (this.getAssistButtonCount() - 1) / 4 + 1;
            ((GridLayout)this.getAssistContentPane().getLayout()).setRows(rowCount);
            ((GridLayout)this.getAssistContentPane().getLayout()).setColumns(4);
        } else if (this.getAssistComponentLayoutOrientation() == 0) {
            int rowCount = this.getAssistButtonCount();
            ((GridLayout)this.getAssistContentPane().getLayout()).setRows(rowCount);
            ((GridLayout)this.getAssistContentPane().getLayout()).setColumns(1);
        }
    }

    public void setFactType(int newValue) {
        int oldFace;
        int tempFace = 0;
        if (newValue != 0) {
            tempFace = 1;
        }
        if (tempFace != (oldFace = this.getFaceType())) {
            this.faceType = tempFace;
            this.firePropertyChange("selfFaceType", new Integer(oldFace), new Integer(tempFace));
        }
    }

    public int getFaceType() {
        return this.faceType;
    }

    @Override
    public void setDisabledIcon(Icon newVal) {
        Icon oldValue = this.selfDisableIcon;
        this.selfDisableIcon = newVal;
        this.firePropertyChange("disabledIcon", oldValue, this.selfDisableIcon);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", oldValue, this.selfDisableIcon);
        }
        if (this.selfDisableIcon != oldValue && !this.isEnabled()) {
            this.repaint();
        }
    }

    public void setSelfImageSize(int newVal) {
    }

    @Override
    public Icon getDisabledIcon() {
        Icon tempIcon;
        if (this.selfDisableIcon == null && (tempIcon = this.getIcon()) != null && tempIcon instanceof ImageIcon) {
            this.selfDisableIcon = CtrlImageUtilities.createDisableIcon(tempIcon);
        }
        return this.selfDisableIcon;
    }

    @Override
    public Icon getIcon() {
        if (this.getFaceType() != 0) {
            return super.getIcon();
        }
        short tiStyle = this.getTextIconDisStyle();
        if (this.isControlByParent() && this.getParent() instanceof KDToolBar) {
            tiStyle = ((KDToolBar)this.getParent()).isControlByParent() ? KDToolBar.getTextIconDisStyleByParent() : ((KDToolBar)this.getParent()).getTextIconDisStyle();
        }
        if (tiStyle == 2 || tiStyle == 3 || tiStyle == -1) {
            return super.getIcon();
        }
        return null;
    }

    @Override
    public void setText(String text) {
        if (this.getFaceType() != 0) {
            super.setText(text);
            return;
        }
        short tiStyle = this.getTextIconDisStyle();
        if (this.isControlByParent() && this.getParent() instanceof KDToolBar) {
            tiStyle = ((KDToolBar)this.getParent()).isControlByParent() ? KDToolBar.getTextIconDisStyleByParent() : ((KDToolBar)this.getParent()).getTextIconDisStyle();
        }
        if (tiStyle == 1 || tiStyle == 3 || tiStyle == -1) {
            super.setText(text);
        }
    }

    @Override
    public String getText() {
        if (this.getFaceType() != 0) {
            return super.getText();
        }
        short tiStyle = this.getTextIconDisStyle();
        if (this.isControlByParent() && this.getParent() instanceof KDToolBar) {
            tiStyle = ((KDToolBar)this.getParent()).isControlByParent() ? KDToolBar.getTextIconDisStyleByParent() : ((KDToolBar)this.getParent()).getTextIconDisStyle();
        }
        if (tiStyle == 1 || tiStyle == 3 || tiStyle == -1) {
            return super.getText();
        }
        return "";
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        this.setUI(UIManager.getUI(this));
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (CtrlSwingUtilities.runCtrlInputVerifier(this)) {
            super.processMouseEvent(e);
        }
    }

    @Override
    public void setTextIconDisStyle(short newVal) {
        if (newVal == 1 || newVal == 2 || newVal == 3 || newVal == -1) {
            this.textIconStyle = newVal;
        }
    }

    @Override
    public short getTextIconDisStyle() {
        if (0 == this.textIconStyle) {
            this.textIconStyle = (short)-1;
        }
        return this.textIconStyle;
    }

    @Override
    public void setIsControlByParent(boolean newVal) {
        this.isControlByParent = newVal;
    }

    @Override
    public boolean isControlByParent() {
        return this.isControlByParent;
    }

    @Override
    protected void paintBorder(Graphics g) {
        Border border = this.getBorder();
        if (border != null) {
            border.paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight() - 1);
        }
    }

    String getTextAnyWay() {
        return super.getText();
    }

    Icon getIconAnyWay() {
        return super.getIcon();
    }

    Icon getDisabledIconAnyWay() {
        Icon tempIcon;
        if (this.selfDisableIcon == null && (tempIcon = this.getIconAnyWay()) != null && tempIcon instanceof ImageIcon) {
            this.selfDisableIcon = CtrlImageUtilities.createDisableIcon(tempIcon);
        }
        return this.selfDisableIcon;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        return this.getToolTipText();
    }

    @Override
    public String getToolTipText() {
        if (!this.autoToolTipText) {
            String str = super.getToolTipText();
            if (StringUtils.isEmpty(str)) {
                str = null;
            }
            return str;
        }
        String str = super.getToolTipText();
        if (StringUtils.isEmpty(str)) {
            str = this.getText();
        }
        if (StringUtils.isEmpty(str)) {
            return null;
        }
        return str;
    }

    public void setSeparatorVisible(boolean isSeparatorVisible) {
        KingdeeWorkButtonUI ui = null;
        if (this.getUI() instanceof KingdeeWorkButtonUI) {
            ui = (KingdeeWorkButtonUI)this.getUI();
            ui.showLine(isSeparatorVisible);
            this.isSeparatorVisible = isSeparatorVisible;
        }
    }

    public boolean isSeparatorVisible() {
        return this.isSeparatorVisible;
    }

    public void setAutoToolTipText(boolean auto) {
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        if (auto) {
            toolTipManager.registerComponent(this);
        } else {
            toolTipManager.unregisterComponent(this);
        }
        this.autoToolTipText = auto;
    }

    public boolean isAutoToolTipText() {
        return this.autoToolTipText;
    }

    static {
        UIManager.getDefaults().put(uiClassID, "com.kingdee.bos.ctrl.swing.plaf.KingdeeWorkButtonUI");
    }
}

