/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.dial;

public class KpiRange {
    public static final Double INFINITY = new Double(Double.POSITIVE_INFINITY);
    public static final Double INFINITESIMAL = new Double(Double.NEGATIVE_INFINITY);
    private double lower;
    private double upper;

    public KpiRange(double lower, double upper) {
        assert (lower <= upper);
        this.lower = lower;
        this.upper = upper;
    }

    public KpiRange(Double lower, Double upper) {
        this((double)lower, (double)upper);
    }

    public double getLowerBound() {
        return this.lower;
    }

    public double getUpperBound() {
        return this.upper;
    }

    public double getLength() {
        return this.upper - this.lower;
    }

    public double getCentralValue() {
        return this.lower / 2.0 + this.upper / 2.0;
    }

    public boolean contains(double value) {
        return value >= this.lower && value <= this.upper;
    }

    public static KpiRange combine(KpiRange range1, KpiRange range2) {
        if (range1 == null) {
            return range2;
        }
        if (range2 == null) {
            return range1;
        }
        double l = Math.min(range1.getLowerBound(), range2.getLowerBound());
        double u = Math.max(range1.getUpperBound(), range2.getUpperBound());
        return new KpiRange(l, u);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof KpiRange) {
            KpiRange range = (KpiRange)object;
            boolean b0 = this.lower == range.lower;
            boolean b1 = this.upper == range.upper;
            return b0 && b1;
        }
        return false;
    }

    public String toString() {
        return "Range[" + this.lower + "," + this.upper + "]";
    }

    public int hashCode() {
        return super.hashCode();
    }
}

