/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.plaf;

import com.kingdee.bos.ctrl.swing.plaf.KingdeeBorders;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextFieldUI;

public class DefaultTextFieldUI
extends BasicTextFieldUI {
    protected transient JTextField tf;
    protected TextFieldListener listener;

    public static ComponentUI createUI(JComponent comp) {
        return new DefaultTextFieldUI(comp);
    }

    public DefaultTextFieldUI(JComponent comp) {
        this.tf = (JTextField)comp;
    }

    @Override
    public void installUI(JComponent comp) {
        super.installUI(comp);
        this.tf.setBackground(UIManager.getColor("TextField.background"));
        this.tf.setSelectionColor(UIManager.getColor("TextField.selectionBackground"));
        this.tf.setSelectedTextColor(UIManager.getColor("TextField.selectionForeground"));
        this.tf.setBorder(KingdeeBorders.createEditorBorder());
        this.tf.setDisabledTextColor(UIManager.getColor("TextField.disableForeground"));
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        if (this.listener == null) {
            this.listener = new TextFieldListener(this.tf);
        }
        this.tf.addFocusListener(this.listener);
    }

    protected void uninstallListeners(JComponent c) {
        this.tf.removeFocusListener(this.listener);
        super.uninstallListeners();
    }

    @Override
    protected void paintBackground(Graphics g) {
        if (this.tf.isEnabled()) {
            super.paintBackground(g);
        } else {
            g.setColor(UIManager.getColor("TextField.disableBackground"));
            g.fillRect(0, 0, this.tf.getWidth(), this.tf.getHeight());
        }
    }

    private int getHorAlignValue() {
        return this.tf.getHorizontalAlignment();
    }

    @Override
    protected Rectangle getVisibleEditorRect() {
        Rectangle rect = super.getVisibleEditorRect();
        int tempHori = this.getHorAlignValue();
        if (rect != null) {
            if (tempHori == 4) {
                rect.x = -1;
            } else if (tempHori == 10) {
                rect.x = 3;
            }
        }
        return rect;
    }

    protected static class TextFieldListener
    implements FocusListener {
        public TextFieldListener(JTextField t) {
        }

        @Override
        public void focusGained(FocusEvent e) {
            Component c = (Component)e.getSource();
            c.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            Component c = (Component)e.getSource();
            c.repaint();
        }
    }
}

