/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.plaf;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.swing.BarPartArea;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDSkinRootPane;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolBarUI;

public class KingdeeToolBarUI
extends BasicToolBarUI {
    public static final int SHADOW_HORIZONTAL = 1;
    public static final int SHADOW_VERTICAL = 2;
    private Color shadowColor = null;
    private Color darkShadowColor = null;
    private Color topColor = null;
    private Color firstShadowColor = null;
    private Color secondShadowColor = null;
    private Color thirdShadowColor = null;
    private Color fourthShadowColor = null;
    private Color fifthsShadowColor = null;
    protected Color dotColor = null;
    protected Color shadowDotColor = null;
    private int shadowOrientation = 1;
    private KDPopupMenu popupMenu = null;
    private boolean popupMenuShowable = true;
    protected KDLabel dragArea = null;
    protected MouseMotionListener localDragListener = null;
    protected Container dockingSource;
    protected boolean floating;
    protected RootPaneContainer floatingToolBar;
    protected int floatingX;
    protected int floatingY;

    public static ComponentUI createUI(JComponent x) {
        return new KingdeeToolBarUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.toolBar.addMouseListener(new MouseHandler(this.toolBar));
        this.popupMenu = this.createPopupMenu();
        if (this.toolBar instanceof KDToolBar && this.toolBar.isFloatable()) {
            this.dragArea = (KDLabel)this.toolBar.getComponent(1);
            this.dragArea.addMouseMotionListener(this.dockingListener);
            this.dragArea.addMouseListener(this.dockingListener);
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.toolBar.removeMouseMotionListener(this.dockingListener);
        this.toolBar.removeMouseListener(this.dockingListener);
    }

    @Override
    protected void uninstallListeners() {
        if (this.toolBar instanceof KDToolBar && this.toolBar.isFloatable()) {
            this.dragArea.removeMouseMotionListener(this.dockingListener);
            this.dragArea.removeMouseListener(this.dockingListener);
        }
        this.dockingListener = null;
    }

    public void add(Component comp) {
        if (comp != null) {
            comp.addMouseListener(new MouseHandler(comp));
        }
    }

    public void setPopupMenuShowable(boolean popupMenuShowable) {
        this.popupMenuShowable = popupMenuShowable;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.dotColor = UIManager.getColor("ToolBar.dotColor");
        if (this.dotColor == null) {
            this.dotColor = Color.decode("#7386A5");
        }
        this.shadowDotColor = UIManager.getColor("ToolBar.shadowDotColor");
        if (this.shadowDotColor == null) {
            this.shadowDotColor = Color.decode("#002549");
        }
        this.shadowColor = UIManager.getColor("ToolBar.shadow");
        if (this.shadowColor == null) {
            this.shadowColor = Color.decode("#CEDBE7");
        }
        this.darkShadowColor = UIManager.getColor("ToolBar.darkShadow");
        if (this.darkShadowColor == null) {
            this.darkShadowColor = Color.decode("#9EBCD5");
        }
        this.topColor = UIManager.getColor("ToolBar.topColor");
        if (this.topColor == null) {
            this.topColor = Color.decode("#B6C8D8");
        }
        this.firstShadowColor = UIManager.getColor("ToolBar.firstShadowColor");
        if (this.firstShadowColor == null) {
            this.firstShadowColor = Color.decode("#CEDBE7");
        }
        this.secondShadowColor = UIManager.getColor("ToolBar.secondShadowColor");
        if (this.secondShadowColor == null) {
            this.secondShadowColor = Color.decode("#C6D6E4");
        }
        this.thirdShadowColor = UIManager.getColor("ToolBar.thirdShadowColor");
        if (this.thirdShadowColor == null) {
            this.thirdShadowColor = Color.decode("#B7CDDE");
        }
        this.fourthShadowColor = UIManager.getColor("ToolBar.fourthShadowColor");
        if (this.fourthShadowColor == null) {
            this.fourthShadowColor = Color.decode("#A9C3D9");
        }
        this.fifthsShadowColor = UIManager.getColor("ToolBar.fifthsShadowColor");
        if (this.fifthsShadowColor == null) {
            this.fifthsShadowColor = Color.decode("#9EBCD5");
        }
        this.toolBar.setBorder(null);
        this.toolBar.setBackground(Color.BLACK);
    }

    @Override
    protected void dragTo(Point position, Point origin) {
        if (this.toolBar.isFloatable()) {
            try {
                int areaOrientation;
                Point offset;
                if (this.dragWindow == null) {
                    this.dragWindow = this.createDragWindow(this.toolBar);
                }
                if ((offset = this.dragWindow.getOffset()) == null) {
                    Dimension size = this.toolBar.getPreferredSize();
                    offset = new Point(size.width / 2, size.height / 2);
                    this.dragWindow.setOffset(offset);
                }
                Point global = new Point(origin.x + position.x, origin.y + position.y);
                Point dragPoint = new Point(global.x - offset.x, global.y - offset.y);
                if (this.dockingSource == null) {
                    this.dockingSource = this.toolBar.getParent().getParent();
                }
                if ((areaOrientation = this.getDockingAreaOrientation(global)) == 0) {
                    this.dragWindow.setBackground(this.getFloatingColor());
                    this.dragWindow.setBorderColor(this.floatingBorderColor);
                } else {
                    KDSkinRootPane skinRootPane = (KDSkinRootPane)((RootPaneContainer)((Object)SwingUtilities.getWindowAncestor(this.dockingSource))).getRootPane();
                    BarPartArea targetBarPartArea = skinRootPane.getBarPartAreaOfOrientation(areaOrientation);
                    if (!(this.dockingSource != targetBarPartArea || this.floatingToolBar != null && ((Window)((Object)this.floatingToolBar)).isVisible())) {
                        this.dragWindow.setBackground(this.getFloatingColor());
                        this.dragWindow.setBorderColor(this.floatingBorderColor);
                    } else {
                        this.floatAt(position, origin);
                        ((DockingListener)this.dockingListener).cleanUpOrigin();
                        return;
                    }
                }
                this.dragWindow.setLocation(dragPoint.x, dragPoint.y);
                if (!this.dragWindow.isVisible()) {
                    Dimension size = this.toolBar.getPreferredSize();
                    this.dragWindow.setSize(size.width, size.height);
                    this.dragWindow.setVisible(true);
                }
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void floatAt(Point position, Point origin) {
        if (this.toolBar.isFloatable()) {
            if (!this.dragWindow.isVisible()) {
                return;
            }
            try {
                Point offset = this.dragWindow.getOffset();
                if (offset == null) {
                    offset = position;
                    this.dragWindow.setOffset(offset);
                }
                Point global = new Point(origin.x + position.x, origin.y + position.y);
                Point dragPoint = new Point(global.x - offset.x, global.y - offset.y);
                this.setFloatingLocation(dragPoint.x, dragPoint.y);
                if (this.dockingSource != null) {
                    int areaOrientation = this.getDockingAreaOrientation(global);
                    this.setFloating(areaOrientation);
                }
                this.dragWindow.setOffset(null);
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
    }

    protected int getDockingAreaOrientation(Point globalPoint) {
        KDSkinRootPane skinRootPane = (KDSkinRootPane)((RootPaneContainer)((Object)SwingUtilities.getWindowAncestor(this.dockingSource))).getRootPane();
        BarPartArea barPartArea = skinRootPane.getBarPartAreaOfOrientation(1);
        Point point = barPartArea.getLocationOnScreen();
        int width = barPartArea.getWidth();
        int height = barPartArea.getHeight();
        if (globalPoint.getX() >= point.getX() && globalPoint.getX() <= point.getX() + (double)width && globalPoint.getY() <= point.getY() + (double)height + 27.0) {
            return 1;
        }
        barPartArea = skinRootPane.getBarPartAreaOfOrientation(5);
        point = barPartArea.getLocationOnScreen();
        width = barPartArea.getWidth();
        height = barPartArea.getHeight();
        if (globalPoint.getX() >= point.getX() && globalPoint.getX() <= point.getX() + (double)width && globalPoint.getY() >= point.getY() - 27.0) {
            return 5;
        }
        barPartArea = skinRootPane.getBarPartAreaOfOrientation(7);
        point = barPartArea.getLocationOnScreen();
        width = barPartArea.getWidth();
        height = barPartArea.getHeight();
        if (globalPoint.getX() <= point.getX() + (double)width + 27.0 && globalPoint.getY() > point.getY() && globalPoint.getY() <= point.getY() + (double)height) {
            return 7;
        }
        barPartArea = skinRootPane.getBarPartAreaOfOrientation(3);
        point = barPartArea.getLocationOnScreen();
        width = barPartArea.getWidth();
        height = barPartArea.getHeight();
        if (globalPoint.getX() >= point.getX() - 27.0 && globalPoint.getY() > point.getY() && globalPoint.getY() <= point.getY() + (double)height) {
            return 3;
        }
        return 0;
    }

    protected void setFloating(int areaOrientation) {
        if (this.toolBar.isFloatable()) {
            if (this.dragWindow != null) {
                this.dragWindow.setVisible(false);
            }
            if (areaOrientation == 0) {
                this.floating = true;
                Point l = new Point();
                this.toolBar.getLocation(l);
                if (this.propertyListener != null) {
                    UIManager.addPropertyChangeListener(this.propertyListener);
                }
                if (this.floatingToolBar == null) {
                    this.floatingToolBar = this.createFloatingWindow(this.toolBar);
                }
                ((BarPartArea)this.dockingSource).removeJToolBar(this.toolBar);
                this.floatingToolBar.getContentPane().add((Component)this.toolBar, "Center");
                this.setOrientation(0);
                if (this.floatingToolBar instanceof Window) {
                    ((Window)((Object)this.floatingToolBar)).pack();
                }
                if (this.floatingToolBar instanceof Window) {
                    ((Window)((Object)this.floatingToolBar)).setLocation(this.floatingX, this.floatingY);
                }
                if (this.floatingToolBar instanceof Window) {
                    ((Window)((Object)this.floatingToolBar)).setVisible(true);
                }
            } else {
                if (this.floatingToolBar == null) {
                    this.floatingToolBar = this.createFloatingWindow(this.toolBar);
                }
                this.floatingToolBar.getContentPane().remove(this.toolBar);
                if (!this.floating) {
                    ((BarPartArea)this.dockingSource).removeJToolBar(this.toolBar);
                }
                if (this.dockingSource == null) {
                    this.dockingSource = this.toolBar.getParent().getParent();
                }
                if (this.propertyListener != null) {
                    UIManager.removePropertyChangeListener(this.propertyListener);
                }
                KDSkinRootPane skinRootPane = (KDSkinRootPane)((RootPaneContainer)((Object)SwingUtilities.getWindowAncestor(this.dockingSource))).getRootPane();
                BarPartArea targetBarPartArea = skinRootPane.getBarPartAreaOfOrientation(areaOrientation);
                if (areaOrientation == 1 || areaOrientation == 7) {
                    ((KDToolBar)this.toolBar).setRowID(targetBarPartArea.getToolBarRowCount() + 1);
                } else if (areaOrientation == 5 || areaOrientation == 3) {
                    ((KDToolBar)this.toolBar).setRowID(0);
                }
                int orientation = this.mapAreaOrientationToOrientation(areaOrientation);
                if (this.toolBar.getOrientation() != orientation) {
                    this.setOrientation(orientation);
                }
                targetBarPartArea.addJToolBar(this.toolBar);
                if (this.floatingToolBar instanceof Window) {
                    ((Window)((Object)this.floatingToolBar)).setVisible(false);
                }
                this.dockingSource = targetBarPartArea;
                this.floating = false;
            }
            this.dockingSource.invalidate();
            Container dockingSourceParent = this.dockingSource.getParent();
            if (dockingSourceParent != null) {
                ((JComponent)dockingSourceParent).revalidate();
            }
            this.dockingSource.repaint();
        }
    }

    @Override
    protected MouseInputListener createDockingListener() {
        return new DockingListener(this.toolBar);
    }

    @Override
    protected WindowListener createFrameListener() {
        return new FrameListener();
    }

    @Override
    public boolean isFloating() {
        return this.floating;
    }

    @Override
    public void setFloatingLocation(int x, int y) {
        this.floatingX = x;
        this.floatingY = y;
    }

    protected int mapAreaOrientationToOrientation(int areaOrientation) {
        int orientation = this.toolBar.getOrientation();
        if (areaOrientation == 7 || areaOrientation == 3) {
            orientation = 1;
        } else if (areaOrientation == 5 || areaOrientation == 1) {
            orientation = 0;
        }
        return orientation;
    }

    @Override
    public void setRolloverBorders(boolean rollover) {
    }

    @Override
    protected void setBorderToRollover(Component c) {
    }

    @Override
    protected void setBorderToNormal(Component c) {
    }

    @Override
    protected void setBorderToNonRollover(Component c) {
    }

    public void configDragArea(boolean b) {
        if (!(this.toolBar instanceof KDToolBar)) {
            return;
        }
        if (this.dragArea == null && b) {
            this.dragArea = new KDLabel();
            this.localDragListener = this.createLocalDragListener();
            this.dragArea.setCursor(Cursor.getPredefinedCursor(13));
            this.dragArea.addMouseMotionListener(this.localDragListener);
            this.dragArea.addMouseMotionListener(this.dockingListener);
            this.dragArea.addMouseListener(this.dockingListener);
            int width = (Integer)UIManager.get("ToolBar.dragAreaWidthWhenHorizontal");
            int height = (Integer)UIManager.get("ToolBar.preHeight");
            this.dragArea.setPreferredSize(new Dimension(width, height));
            this.toolBar.add((Component)this.dragArea, 1);
        } else if (this.dragArea != null) {
            this.dragArea.setVisible(b);
        }
    }

    @Override
    protected PropertyChangeListener createPropertyListener() {
        return new PropertyListener();
    }

    protected MouseMotionListener createLocalDragListener() {
        return new BarPartAreaLocalDragListener();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        c.setOpaque(false);
        super.paint(g, c);
        this.paintSelfShadow(g, c);
        if (this.toolBar instanceof KDToolBar && ((KDToolBar)this.toolBar).isFloatable()) {
            this.paintPoint(g, c);
        }
        c.setBackground(Color.WHITE);
    }

    protected void paintPoint(Graphics g, JComponent c) {
        Color old = g.getColor();
        if (this.toolBar.getOrientation() == 1) {
            int width = this.toolBar.getWidth();
            int x = width / 2;
            g.setColor(this.dotColor);
            g.fillRect(x, 9, 2, 2);
            g.fillRect(x - 4, 9, 2, 2);
            g.fillRect(x - 8, 9, 2, 2);
            g.fillRect(x + 4, 9, 2, 2);
            g.fillRect(x + 8, 9, 2, 2);
            g.setColor(this.shadowDotColor);
            g.fillRect(x, 8, 2, 2);
            g.fillRect(x - 4, 8, 2, 2);
            g.fillRect(x - 8, 8, 2, 2);
            g.fillRect(x + 4, 8, 2, 2);
            g.fillRect(x + 8, 8, 2, 2);
        } else {
            g.setColor(this.dotColor);
            g.fillRect(9, 9, 2, 2);
            g.fillRect(9, 13, 2, 2);
            g.fillRect(9, 17, 2, 2);
            g.fillRect(9, 21, 2, 2);
            g.setColor(this.shadowDotColor);
            g.fillRect(8, 8, 2, 2);
            g.fillRect(8, 12, 2, 2);
            g.fillRect(8, 16, 2, 2);
            g.fillRect(8, 20, 2, 2);
        }
        g.setColor(old);
    }

    protected void paintSelfShadow(Graphics g, JComponent c) {
        if (c.getParent() instanceof BarPartArea.KDToolBarRowContainer) {
            return;
        }
        Insets ins = c.getInsets();
        int height = c.getHeight();
        int width = c.getWidth();
        Insets insets = ins = ins != null ? ins : new Insets(2, 0, 2, 0);
        if (this.toolBar.getOrientation() == 0) {
            this.shadowOrientation = UIManager.getInt("ToolBar.shadowOrientationWhenHorizontal");
            if (this.shadowOrientation == 1) {
                int perWidth = width / 4;
                float x0 = 0.0f;
                float y0 = 1.0f;
                float x1 = x0 + (float)perWidth;
                float y1 = y0;
                float x2 = x1 + (float)perWidth;
                float y2 = y1;
                float x3 = x2 + (float)perWidth;
                float y3 = y2;
                float x4 = x3 + (float)perWidth;
                float y4 = y3;
                Graphics2D g2d = (Graphics2D)g;
                Paint oldPaint = g2d.getPaint();
                g2d.setColor(this.topColor);
                g2d.fillRect(0, 0, c.getWidth(), 1);
                Rectangle rect = c.getBounds();
                GradientPaint gradient = new GradientPaint(x0, y0, this.firstShadowColor, x1, y1, this.secondShadowColor);
                g2d.setPaint(gradient);
                g2d.fillRect((int)x0, (int)y0, perWidth, rect.height - 1);
                gradient = new GradientPaint(x1, y1, this.secondShadowColor, x2, y2, this.thirdShadowColor);
                g2d.setPaint(gradient);
                g2d.fillRect((int)x1, (int)y1, perWidth, rect.height - 1);
                gradient = new GradientPaint(x2, y2, this.thirdShadowColor, x3, y3, this.fourthShadowColor);
                g2d.setPaint(gradient);
                g2d.fillRect((int)x2, (int)y2, perWidth, rect.height - 1);
                gradient = new GradientPaint(x3, y3, this.fourthShadowColor, x4, y4, this.fifthsShadowColor);
                g2d.setPaint(gradient);
                g2d.fillRect((int)x3, (int)y3, width - (int)x3, rect.height - 1);
                g2d.setPaint(oldPaint);
            } else if (this.shadowOrientation == 2) {
                int perHeight = height / 4;
                float x0 = 0.0f;
                float y0 = 1.0f;
                float x1 = 0.0f;
                float y1 = y0 + (float)perHeight;
                float x2 = 0.0f;
                float y2 = y1 + (float)perHeight;
                float x3 = 0.0f;
                float y3 = y2 + (float)perHeight;
                float x4 = 0.0f;
                float y4 = y3 + (float)perHeight;
                Graphics2D g2d = (Graphics2D)g;
                Paint oldPaint = g2d.getPaint();
                g2d.setColor(this.topColor);
                g2d.fillRect(0, 0, c.getWidth(), 1);
                GradientPaint gradient = new GradientPaint(x0, y0, this.firstShadowColor, x1, y1, this.secondShadowColor);
                Rectangle rect = c.getBounds();
                g2d.setPaint(gradient);
                g2d.fillRect((int)x0, (int)y0, rect.width, perHeight);
                gradient = new GradientPaint(x1, y1, this.secondShadowColor, x2, y2, this.thirdShadowColor);
                g2d.setPaint(gradient);
                g2d.fillRect((int)x1, (int)y1, rect.width, perHeight);
                gradient = new GradientPaint(x2, y2, this.thirdShadowColor, x3, y3, this.fourthShadowColor);
                g2d.setPaint(gradient);
                g2d.fillRect((int)x2, (int)y2, rect.width, perHeight);
                gradient = new GradientPaint(x3, y3, this.fourthShadowColor, x4, y4, this.fifthsShadowColor);
                g2d.setPaint(gradient);
                g2d.fillRect((int)x3, (int)y3, rect.width, height - (int)y3);
                g2d.setPaint(oldPaint);
            }
        } else if (this.toolBar.getOrientation() == 1) {
            this.shadowOrientation = UIManager.getInt("ToolBar.shadowOrientationWhenVertical");
            if (this.shadowOrientation == 1) {
                int perWidth = width / 4;
                float x0 = 0.0f;
                float y0 = 1.0f;
                float x1 = x0 + (float)perWidth;
                float y1 = y0;
                float x2 = x1 + (float)perWidth;
                float y2 = y1;
                float x3 = x2 + (float)perWidth;
                float y3 = y2;
                float x4 = x3 + (float)perWidth;
                float y4 = y3;
                Graphics2D g2d = (Graphics2D)g;
                Paint oldPaint = g2d.getPaint();
                g2d.setColor(this.topColor);
                g2d.fillRect(0, 0, c.getWidth(), 1);
                Rectangle rect = c.getBounds();
                GradientPaint gradient = new GradientPaint(x0, y0, this.firstShadowColor, x1, y1, this.secondShadowColor);
                g2d.setPaint(gradient);
                g2d.fillRect((int)x0, (int)y0, perWidth, rect.height - 1);
                gradient = new GradientPaint(x1, y1, this.secondShadowColor, x2, y2, this.thirdShadowColor);
                g2d.setPaint(gradient);
                g2d.fillRect((int)x1, (int)y1, perWidth, rect.height - 1);
                gradient = new GradientPaint(x2, y2, this.thirdShadowColor, x3, y3, this.fourthShadowColor);
                g2d.setPaint(gradient);
                g2d.fillRect((int)x2, (int)y2, perWidth, rect.height - 1);
                gradient = new GradientPaint(x3, y3, this.fourthShadowColor, x4, y4, this.fifthsShadowColor);
                g2d.setPaint(gradient);
                g2d.fillRect((int)x3, (int)y3, width - (int)x3, rect.height - 1);
                g2d.setPaint(oldPaint);
            } else if (this.shadowOrientation == 2) {
                int perHeight = height / 4;
                float x0 = 0.0f;
                float y0 = 1.0f;
                float x1 = 0.0f;
                float y1 = y0 + (float)perHeight;
                float x2 = 0.0f;
                float y2 = y1 + (float)perHeight;
                float x3 = 0.0f;
                float y3 = y2 + (float)perHeight;
                float x4 = 0.0f;
                float y4 = y3 + (float)perHeight;
                Graphics2D g2d = (Graphics2D)g;
                Paint oldPaint = g2d.getPaint();
                g2d.setColor(this.topColor);
                g2d.fillRect(0, 0, c.getWidth(), 1);
                GradientPaint gradient = new GradientPaint(x0, y0, this.firstShadowColor, x1, y1, this.secondShadowColor);
                Rectangle rect = c.getBounds();
                g2d.setPaint(gradient);
                g2d.fillRect((int)x0, (int)y0, rect.width, perHeight);
                gradient = new GradientPaint(x1, y1, this.secondShadowColor, x2, y2, this.thirdShadowColor);
                g2d.setPaint(gradient);
                g2d.fillRect((int)x1, (int)y1, rect.width, perHeight);
                gradient = new GradientPaint(x2, y2, this.thirdShadowColor, x3, y3, this.fourthShadowColor);
                g2d.setPaint(gradient);
                g2d.fillRect((int)x2, (int)y2, rect.width, perHeight);
                gradient = new GradientPaint(x3, y3, this.fourthShadowColor, x4, y4, this.fifthsShadowColor);
                g2d.setPaint(gradient);
                g2d.fillRect((int)x3, (int)y3, rect.width, height - (int)y3);
                g2d.setPaint(oldPaint);
            }
        }
    }

    protected KDPopupMenu createPopupMenu() {
        KDPopupMenu menu = new KDPopupMenu();
        KDMenuItem textItem = new KDMenuItem(this.getLocaleLanguage("onlyText", "\u53ea\u663e\u793a\u6587\u672c"));
        textItem.putClientProperty("itemType", "text");
        textItem.addActionListener(new ActionHandler());
        KDMenuItem iconItem = new KDMenuItem(this.getLocaleLanguage("onlyIcon", "\u53ea\u663e\u793a\u56fe\u6807"));
        iconItem.putClientProperty("itemType", "icon");
        iconItem.addActionListener(new ActionHandler());
        KDMenuItem textIconItem = new KDMenuItem(this.getLocaleLanguage("partText", "\u663e\u793a\u6587\u672c\u548c\u56fe\u6807"));
        textIconItem.putClientProperty("itemType", "textIcon");
        textIconItem.addActionListener(new ActionHandler());
        menu.add(textItem);
        menu.add(iconItem);
        menu.add(textIconItem);
        return menu;
    }

    private String getLocaleLanguage(String key, String defaultValue) {
        return LanguageManager.getLangMessage((String)key, KingdeeToolBarUI.class, (String)defaultValue);
    }

    protected class PropertyListener
    implements PropertyChangeListener {
        protected PropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if (propertyName.equals("lookAndFeel")) {
                KingdeeToolBarUI.this.toolBar.updateUI();
            } else if (propertyName.equals("orientation") && KingdeeToolBarUI.this.toolBar.isFloatable()) {
                Component[] components = KingdeeToolBarUI.this.toolBar.getComponents();
                int orientation = (Integer)evt.getNewValue();
                if (orientation == 0) {
                    for (int i = 0; i < components.length; ++i) {
                        JComponent comp = (JComponent)components[i];
                        if (!(comp instanceof JSeparator)) continue;
                        ((JSeparator)comp).setOrientation(1);
                        ((JSeparator)comp).setPreferredSize(new Dimension(8, 20));
                    }
                    int width = (Integer)UIManager.get("ToolBar.dragAreaWidthWhenHorizontal");
                    int height = (Integer)UIManager.get("ToolBar.preHeight");
                    KingdeeToolBarUI.this.dragArea.setPreferredSize(new Dimension(width, height));
                } else {
                    for (int i = 0; i < components.length; ++i) {
                        JComponent comp = (JComponent)components[i];
                        if (!(comp instanceof JSeparator)) continue;
                        ((JSeparator)comp).setOrientation(0);
                        ((JSeparator)comp).setPreferredSize(new Dimension(20, 8));
                    }
                    int width = (Integer)UIManager.get("ToolBar.preWidth");
                    int height = (Integer)UIManager.get("ToolBar.dragAreaHeightWhenVertical");
                    KingdeeToolBarUI.this.dragArea.setPreferredSize(new Dimension(width, height));
                }
            } else if (propertyName.equals("JToolBar.isRollover")) {
                KingdeeToolBarUI.this.setRolloverBorders((Boolean)evt.getNewValue());
            }
        }
    }

    protected class FrameListener
    extends WindowAdapter {
        protected FrameListener() {
        }

        @Override
        public void windowClosing(WindowEvent w) {
            if (KingdeeToolBarUI.this.toolBar.isFloatable()) {
                BarPartArea barPartArea;
                int areaOrientation;
                if (KingdeeToolBarUI.this.dragWindow != null) {
                    KingdeeToolBarUI.this.dragWindow.setVisible(false);
                }
                KingdeeToolBarUI.this.floating = false;
                if (KingdeeToolBarUI.this.floatingToolBar == null) {
                    KingdeeToolBarUI.this.floatingToolBar = KingdeeToolBarUI.this.createFloatingWindow(KingdeeToolBarUI.this.toolBar);
                }
                if (KingdeeToolBarUI.this.floatingToolBar instanceof Window) {
                    ((Window)((Object)KingdeeToolBarUI.this.floatingToolBar)).setVisible(false);
                }
                KingdeeToolBarUI.this.floatingToolBar.getContentPane().remove(KingdeeToolBarUI.this.toolBar);
                if (KingdeeToolBarUI.this.dockingSource == null) {
                    KingdeeToolBarUI.this.dockingSource = KingdeeToolBarUI.this.toolBar.getParent().getParent();
                }
                if (KingdeeToolBarUI.this.propertyListener != null) {
                    UIManager.removePropertyChangeListener(KingdeeToolBarUI.this.propertyListener);
                }
                if ((areaOrientation = (barPartArea = (BarPartArea)KingdeeToolBarUI.this.dockingSource).getAreaOrientation()) == 1 || areaOrientation == 7) {
                    ((KDToolBar)KingdeeToolBarUI.this.toolBar).setRowID(barPartArea.getToolBarRowCount() + 1);
                } else if (areaOrientation == 5 || areaOrientation == 3) {
                    ((KDToolBar)KingdeeToolBarUI.this.toolBar).setRowID(0);
                }
                ((BarPartArea)KingdeeToolBarUI.this.dockingSource).addJToolBar(KingdeeToolBarUI.this.toolBar);
                KingdeeToolBarUI.this.dockingSource.invalidate();
                Container dockingSourceParent = KingdeeToolBarUI.this.dockingSource.getParent();
                if (dockingSourceParent != null) {
                    ((JComponent)dockingSourceParent).revalidate();
                }
                KingdeeToolBarUI.this.dockingSource.repaint();
            }
        }
    }

    public class DockingListener
    implements MouseInputListener {
        protected JToolBar toolBar;
        protected boolean isDragging = false;
        protected Point origin = null;

        public DockingListener(JToolBar t) {
            this.toolBar = t;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!this.toolBar.isEnabled()) {
                return;
            }
            this.isDragging = false;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!this.toolBar.isEnabled()) {
                return;
            }
            if (this.isDragging) {
                Point position = e.getPoint();
                if (this.origin == null) {
                    this.origin = e.getComponent().getLocationOnScreen();
                }
                KingdeeToolBarUI.this.floatAt(position, this.origin);
            }
            this.origin = null;
            this.isDragging = false;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (e.isConsumed() || !this.toolBar.isEnabled()) {
                return;
            }
            this.isDragging = true;
            Point position = e.getPoint();
            if (this.origin == null) {
                this.origin = e.getComponent().getLocationOnScreen();
            }
            KingdeeToolBarUI.this.dragTo(position, this.origin);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        public void cleanUpOrigin() {
            this.origin = null;
        }
    }

    private class BarPartAreaLocalDragListener
    implements MouseMotionListener {
        private BarPartAreaLocalDragListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!(KingdeeToolBarUI.this.toolBar.getParent() instanceof BarPartArea.KDToolBarRowContainer)) {
                return;
            }
            BarPartArea.KDToolBarRowContainer rowContainer = (BarPartArea.KDToolBarRowContainer)KingdeeToolBarUI.this.toolBar.getParent();
            BarPartArea barPartArea = (BarPartArea)rowContainer.getParent();
            int rowID = rowContainer.getRowID();
            Point p = e.getPoint();
            p = SwingUtilities.convertPoint(KingdeeToolBarUI.this.dragArea, p, KingdeeToolBarUI.this.toolBar);
            int rowCount = barPartArea.getToolBarRowCount();
            if (KingdeeToolBarUI.this.toolBar.getOrientation() == 0) {
                int height = (Integer)UIManager.get("ToolBar.preHeight");
                if (p.getY() < 0.0 && rowID == 1 && rowContainer.getComponentCount() == 1 && barPartArea.getAreaOrientation() == 5) {
                    return;
                }
                if (p.getY() > (double)height && rowID == rowCount && rowContainer.getComponentCount() == 1 && barPartArea.getAreaOrientation() == 1) {
                    return;
                }
                if (p.getY() >= 0.0 && p.getY() <= (double)height) {
                    if (KingdeeToolBarUI.this.dragWindow != null && KingdeeToolBarUI.this.dragWindow.isVisible()) {
                        KingdeeToolBarUI.this.dragWindow.setVisible(false);
                    }
                    rowContainer.putClientProperty("motion", "parallel");
                    rowContainer.putClientProperty("point", SwingUtilities.convertPoint(KingdeeToolBarUI.this.toolBar, p, KingdeeToolBarUI.this.toolBar.getParent()));
                    rowContainer.putClientProperty("source", KingdeeToolBarUI.this.toolBar);
                    rowContainer.revalidate();
                    rowContainer.repaint();
                    e.consume();
                } else if (p.getY() < 0.0 && rowID == 1) {
                    barPartArea.removeJToolBar(KingdeeToolBarUI.this.toolBar);
                    ((KDToolBar)KingdeeToolBarUI.this.toolBar).setRowID(0);
                    barPartArea.addJToolBar(KingdeeToolBarUI.this.toolBar);
                    e.consume();
                } else if (p.getY() > (double)height && rowID == rowCount) {
                    barPartArea.removeJToolBar(KingdeeToolBarUI.this.toolBar);
                    ((KDToolBar)KingdeeToolBarUI.this.toolBar).setRowID(rowCount + 1);
                    barPartArea.addJToolBar(KingdeeToolBarUI.this.toolBar);
                    e.consume();
                } else if (p.getY() > (double)height && rowID < rowCount || p.getY() < 0.0 && rowID > 1) {
                    for (int i = 0; i < barPartArea.getComponentCount(); ++i) {
                        BarPartArea.KDToolBarRowContainer targetRowContainer;
                        Component comp = barPartArea.getComponent(i);
                        if (!(comp instanceof BarPartArea.KDToolBarRowContainer) || !(targetRowContainer = (BarPartArea.KDToolBarRowContainer)comp).contains(SwingUtilities.convertPoint(KingdeeToolBarUI.this.toolBar, p, targetRowContainer))) continue;
                        for (int j = 0; j < targetRowContainer.getComponentCount(); ++j) {
                            KDToolBar targetToolBar = (KDToolBar)targetRowContainer.getComponent(j);
                            if (!targetToolBar.contains(SwingUtilities.convertPoint(KingdeeToolBarUI.this.toolBar, p, targetToolBar))) continue;
                            barPartArea.removeJToolBar(KingdeeToolBarUI.this.toolBar);
                            ((KDToolBar)KingdeeToolBarUI.this.toolBar).setRowID(targetRowContainer.getRowID());
                            rowContainer.putClientProperty("motion", "insert");
                            barPartArea.addJToolBar(KingdeeToolBarUI.this.toolBar, j + 1);
                            e.consume();
                            return;
                        }
                        barPartArea.removeJToolBar(KingdeeToolBarUI.this.toolBar);
                        ((KDToolBar)KingdeeToolBarUI.this.toolBar).setRowID(targetRowContainer.getRowID());
                        rowContainer.putClientProperty("motion", "insert");
                        barPartArea.addJToolBar(KingdeeToolBarUI.this.toolBar);
                    }
                    e.consume();
                }
            } else if (KingdeeToolBarUI.this.toolBar.getOrientation() == 1) {
                int width = (Integer)UIManager.get("ToolBar.preWidth");
                if (p.getX() < 0.0 && rowID == 1 && rowContainer.getComponentCount() == 1 && barPartArea.getAreaOrientation() == 3) {
                    return;
                }
                if (p.getX() > (double)width && rowID == rowCount && rowContainer.getComponentCount() == 1 && barPartArea.getAreaOrientation() == 7) {
                    return;
                }
                if (p.getX() >= 0.0 && p.getX() <= (double)width) {
                    if (KingdeeToolBarUI.this.dragWindow != null && KingdeeToolBarUI.this.dragWindow.isVisible()) {
                        KingdeeToolBarUI.this.dragWindow.setVisible(false);
                    }
                    rowContainer.putClientProperty("motion", "parallel");
                    rowContainer.putClientProperty("point", SwingUtilities.convertPoint(KingdeeToolBarUI.this.toolBar, p, KingdeeToolBarUI.this.toolBar.getParent()));
                    rowContainer.putClientProperty("source", KingdeeToolBarUI.this.toolBar);
                    rowContainer.revalidate();
                    rowContainer.repaint();
                    e.consume();
                } else if (p.getX() < 0.0 && rowID == 1) {
                    barPartArea.removeJToolBar(KingdeeToolBarUI.this.toolBar);
                    ((KDToolBar)KingdeeToolBarUI.this.toolBar).setRowID(0);
                    barPartArea.addJToolBar(KingdeeToolBarUI.this.toolBar);
                    e.consume();
                } else if (p.getX() > (double)width && rowID == rowCount) {
                    barPartArea.removeJToolBar(KingdeeToolBarUI.this.toolBar);
                    ((KDToolBar)KingdeeToolBarUI.this.toolBar).setRowID(rowCount + 1);
                    barPartArea.addJToolBar(KingdeeToolBarUI.this.toolBar);
                    e.consume();
                } else if (p.getX() > (double)width && rowID < rowCount || p.getX() < 0.0 && rowID > 1) {
                    for (int i = 0; i < barPartArea.getComponentCount(); ++i) {
                        BarPartArea.KDToolBarRowContainer targetRowContainer;
                        Component comp = barPartArea.getComponent(i);
                        if (!(comp instanceof BarPartArea.KDToolBarRowContainer) || !(targetRowContainer = (BarPartArea.KDToolBarRowContainer)comp).contains(SwingUtilities.convertPoint(KingdeeToolBarUI.this.toolBar, p, targetRowContainer))) continue;
                        for (int j = 0; j < targetRowContainer.getComponentCount(); ++j) {
                            KDToolBar targetToolBar = (KDToolBar)targetRowContainer.getComponent(j);
                            if (!targetToolBar.contains(SwingUtilities.convertPoint(KingdeeToolBarUI.this.toolBar, p, targetToolBar))) continue;
                            barPartArea.removeJToolBar(KingdeeToolBarUI.this.toolBar);
                            ((KDToolBar)KingdeeToolBarUI.this.toolBar).setRowID(targetRowContainer.getRowID());
                            rowContainer.putClientProperty("motion", "insert");
                            barPartArea.addJToolBar(KingdeeToolBarUI.this.toolBar, j + 1);
                            e.consume();
                            return;
                        }
                        barPartArea.removeJToolBar(KingdeeToolBarUI.this.toolBar);
                        ((KDToolBar)KingdeeToolBarUI.this.toolBar).setRowID(targetRowContainer.getRowID());
                        rowContainer.putClientProperty("motion", "insert");
                        barPartArea.addJToolBar(KingdeeToolBarUI.this.toolBar);
                    }
                    e.consume();
                }
            } else {
                throw new IllegalArgumentException("orientation of KDToolBar is illegal.");
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!(KingdeeToolBarUI.this.toolBar instanceof KDToolBar)) {
                return;
            }
            ((KDToolBar)KingdeeToolBarUI.this.toolBar).setIsControlByParent(false);
            if (((KDMenuItem)e.getSource()).getClientProperty("itemType").equals("text")) {
                ((KDToolBar)KingdeeToolBarUI.this.toolBar).setTextIconDisStyle((short)1);
            }
            if (((KDMenuItem)e.getSource()).getClientProperty("itemType").equals("icon")) {
                ((KDToolBar)KingdeeToolBarUI.this.toolBar).setTextIconDisStyle((short)2);
            }
            if (((KDMenuItem)e.getSource()).getClientProperty("itemType").equals("textIcon")) {
                ((KDToolBar)KingdeeToolBarUI.this.toolBar).setTextIconDisStyle((short)3);
            }
            KingdeeToolBarUI.this.toolBar.doLayout();
            KingdeeToolBarUI.this.toolBar.repaint();
        }
    }

    public class MouseHandler
    extends MouseAdapter {
        private Component invoker;

        public MouseHandler(Component invoker) {
            this.invoker = invoker;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e) && KingdeeToolBarUI.this.popupMenuShowable) {
                KingdeeToolBarUI.this.popupMenu.show(this.invoker, e.getX(), e.getY());
            }
        }
    }
}

