/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.resource;

import com.kingdee.bos.ctrl.common.LanguageManager;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class KDResourceManager {
    private static KDResourceManager res = new KDResourceManager();
    private static Font buttonfont = new Font("\u5b8b\u4f53", 0, 12);
    static Hashtable images = new Hashtable();

    public static Image getImageOfRapid(String imageName) {
        if (images.containsKey(imageName)) {
            return (Image)images.get(imageName);
        }
        URL url = res.getClass().getResource(imageName);
        if (url != null) {
            try {
                Image image = new ImageIcon(url).getImage();
                if (image != null) {
                    images.put(imageName, image);
                }
                return image;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static BufferedImage getImage(String imageName) {
        if (images.containsKey(imageName)) {
            return (BufferedImage)images.get(imageName);
        }
        URL url = res.getClass().getResource(imageName);
        if (url != null) {
            BufferedImage image = null;
            try {
                image = ImageIO.read(url);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (image != null) {
                images.put(imageName, image);
            }
            return image;
        }
        return null;
    }

    public static Image getImageByDefault(String imageName) {
        if (images.containsKey(imageName)) {
            return (Image)images.get(imageName);
        }
        URL url = res.getClass().getResource(imageName);
        if (url != null) {
            Image image = null;
            image = Toolkit.getDefaultToolkit().getImage(url);
            if (image != null) {
                images.put(imageName, image);
            }
            return image;
        }
        return null;
    }

    public static Font getFont() {
        return buttonfont;
    }

    public static String getMLS(String key, String defaultValue) {
        return LanguageManager.getLangMessage((String)key, (String)"com.kingdee.bos.ctrl.swing.ctrl_swing", (String)defaultValue);
    }
}

