/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.etl;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.eas.framework.bireport.bimanager.util.IDispatchCallBack;
import com.kingdee.eas.framework.bireport.bimanager.util.LostStrategy;
import com.kingdee.eas.framework.bireport.bimanager.util.TnterruptException;
import java.util.LinkedList;

public class LostStrategy_ETL
implements LostStrategy {
    public boolean isIgnore = true;
    public boolean isExcuteTryCatch = true;
    public boolean isBatchIgnore = true;
    public boolean isBatchEtlScheme;

    public String toString() {
        if (this.isBatchEtlScheme) {
            if (this.isIgnore) {
                if (this.isBatchIgnore) {
                    return "\u5ffd\u7565;\u5ffd\u7565\u672c\u5e10\u5957\u9519\u8bef\uff0c\u7ee7\u7eed\u4e0b\u4e00\u4e2a\u5e10\u5957\u8c03\u5ea6";
                }
                return "\u5ffd\u7565;\u4e2d\u6b62\u5168\u90e8\u5e10\u5957\u8c03\u5ea6";
            }
            if (this.isBatchIgnore) {
                return "\u4e2d\u65ad;\u5ffd\u7565\u672c\u5e10\u5957\u9519\u8bef\uff0c\u7ee7\u7eed\u4e0b\u4e00\u4e2a\u5e10\u5957\u8c03\u5ea6";
            }
            return "\u4e2d\u65ad;\u4e2d\u6b62\u5168\u90e8\u5e10\u5957\u8c03\u5ea6";
        }
        if (this.isIgnore) {
            return "\u5ffd\u7565";
        }
        return "\u4e2d\u65ad";
    }

    public static LostStrategy str2LostStrategy(String str) {
        LostStrategy_ETL etl = new LostStrategy_ETL();
        try {
            etl.parse(str);
        }
        catch (Exception e) {
            return null;
        }
        return etl;
    }

    @Override
    public String toSaveString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ETL");
        sb.append(";");
        sb.append(this.isIgnore);
        sb.append(";");
        sb.append(this.isExcuteTryCatch);
        sb.append(";");
        sb.append(this.isBatchIgnore);
        sb.append(";");
        sb.append(this.isBatchEtlScheme);
        return sb.toString();
    }

    public static void main(String[] args) {
        LostStrategy_ETL etl = new LostStrategy_ETL();
        etl.isIgnore = true;
        etl.isExcuteTryCatch = false;
        etl.isBatchIgnore = false;
        etl.isBatchEtlScheme = true;
        System.out.println(etl.toSaveString());
        System.out.println(etl.toString());
        try {
            LostStrategy_ETL dd = new LostStrategy_ETL();
            dd.parse(etl.toSaveString());
            System.out.println(dd.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void parse(String str) throws Exception {
        String[] splits = str.split(";");
        if (splits.length != 5 && !splits[0].equals("ETL")) {
            throw new Exception("\u5931\u8d25\u7b56\u7565\u8f6c\u6362\u9519\u8bef");
        }
        this.isIgnore = this.str2bool(splits[1]);
        this.isExcuteTryCatch = this.str2bool(splits[2]);
        this.isBatchIgnore = this.str2bool(splits[3]);
        this.isBatchEtlScheme = this.str2bool(splits[4]);
    }

    private boolean str2bool(String str) {
        return "true".equalsIgnoreCase(str);
    }

    @Override
    public void excute(IDispatchCallBack callback) {
        if (this.isBatchEtlScheme) {
            int i;
            int size = callback.getBatchSize();
            int sesucess = 0;
            LinkedList<Integer> list = new LinkedList<Integer>();
            int fail = 0;
            for (i = 0; i < size; ++i) {
                try {
                    callback.executScheme(i);
                    callback.logInfo("\u6267\u884c\u7b2c" + (i + 1) + "\u4e2a\u8c03\u5ea6\uff0c \u5e10\u5957: " + callback.getDBName(i) + ",\u516c\u53f8\uff1a" + callback.getCompanyName(i) + ", \u6267\u884c\u6210\u529f");
                    ++sesucess;
                    continue;
                }
                catch (Exception e) {
                    callback.logInfo("\u6267\u884c\u7b2c" + (i + 1) + "\u4e2a\u8c03\u5ea6\uff0c \u5e10\u5957: " + callback.getDBName(i) + ",\u516c\u53f8\uff1a" + callback.getCompanyName(i) + ", \u6267\u884c\u5931\u8d25");
                    ++fail;
                    list.add(new Integer(i));
                    if (this.isExcuteTryCatch) {
                        try {
                            callback.executTryCatchScheme(i);
                        }
                        catch (Exception e1) {
                            callback.logInfo("\u5f02\u5e38\u5904\u7406ETL\u65b9\u6848\u6267\u884c\u5931\u8d25");
                            callback.addException(e1);
                        }
                    }
                    callback.addException(e);
                    if (this.isBatchIgnore) continue;
                    if (i == size - 1) break;
                    callback.logInfo("\u4e2d\u6b62\u5269\u4e0b" + (size - 1 - i) + "\u4e2a\u5e10\u5957\u8c03\u5ea6");
                    break;
                }
            }
            callback.logInfo("\u6267\u884c\u7ed3\u679c \uff0c\u6210\u529f\uff1a" + sesucess + ",\u5931\u8d25:" + fail);
            if (fail > 0) {
                callback.logInfo("\u6267\u884c\u5931\u8d25\u7684\u5e10\u5957-\u516c\u53f8\u6709\u5982\u4e0b\uff1a");
                for (i = 0; i < list.size(); ++i) {
                    int index = (Integer)list.get(i);
                    callback.logInfo("                    \u5e10\u5957:" + callback.getDBName(index) + " \u516c\u53f8\uff1a" + callback.getCompanyName(index));
                }
            }
            if (!this.isIgnore && callback.hasException()) {
                callback.addException(new TnterruptException(callback.getSchemeName() + "\u6267\u884c\u51fa\u9519\uff0c\u4e2d\u6b62\u6267\u884c\u8c03\u5ea6\u65b9\u6848"));
            }
            return;
        }
        try {
            callback.executScheme(0);
            if (StringUtil.isEmptyString((String)callback.getDBName(0)) && StringUtil.isEmptyString((String)callback.getCompanyName(0))) {
                callback.logInfo(callback.getSchemeName() + "\u5e10\u5957:" + callback.getDBName(0) + ",\u516c\u53f8\uff1a" + callback.getCompanyName(0) + ", \u6267\u884c\u6210\u529f");
            } else {
                callback.logInfo(callback.getSchemeName() + "   \u6267\u884c\u6210\u529f");
            }
        }
        catch (Exception e) {
            if (this.isExcuteTryCatch) {
                try {
                    callback.executTryCatchScheme(0);
                }
                catch (Exception e1) {
                    callback.addException(e);
                }
            }
            if (this.isIgnore) {
                if (StringUtil.isEmptyString((String)callback.getDBName(0)) && StringUtil.isEmptyString((String)callback.getCompanyName(0))) {
                    callback.logInfo(callback.getSchemeName() + "\u5e10\u5957:" + callback.getDBName(0) + ",\u516c\u53f8\uff1a" + callback.getCompanyName(0) + ", \u6267\u884c\u5931\u8d25");
                } else {
                    callback.logInfo(callback.getSchemeName() + "   \u6267\u884c\u5931\u8d25");
                }
                callback.addException(e);
            }
            callback.addException(new TnterruptException(callback.getSchemeName() + "\u6267\u884c\u51fa\u9519\uff0c\u4e2d\u6b62\u6267\u884c\u8c03\u5ea6\u65b9\u6848"));
            callback.addException(new TnterruptException(e.getMessage()));
            return;
        }
    }
}

