/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.kettle;

import com.kingdee.bos.sql.shell.Driver;
import com.kingdee.eas.framework.bireport.bimanager.dbpool.DBConnectionUtil;
import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.LogForTestFactory;
import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.kettle.ETLProxyFactory;
import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.tomcat.ConnectionProxy;
import com.kingdee.eas.framework.bireport.bimanager.util.StringUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;

public class DriverProxy
extends Driver {
    public Connection connect(String url, Properties properties) throws SQLException {
        if ("true".equals(System.getProperty("isExcuteAtTomcat"))) {
            try {
                LogForTestFactory.getLogger().info("\u521b\u5efa\u8fde\u63a5url=" + url);
                String dbID = url.replaceAll("jdbc:etlsqlDB", "");
                Connection remoteInstance = ETLProxyFactory.getRemoteInstance(dbID);
                LogForTestFactory.getLogger().info("\u521b\u5efa\u8fde\u63a5\u6210\u529f");
                return remoteInstance;
            }
            catch (Exception e) {
                LogForTestFactory.getLogger().info("\u521b\u5efa\u8fde\u63a5\u5931\u8d25=" + url);
                throw new SQLException(e.getMessage());
            }
        }
        try {
            if (url.startsWith("jdbc:etlsqlDB")) {
                Map eas_ctx = StringUtils.string2Map(properties.getProperty("password"));
                Properties pro = new Properties();
                String tempDataCenterID = eas_ctx.get("dataCenterID") == null ? null : eas_ctx.get("dataCenterID").toString();
                String dbID = StringUtils.getDBCenterID(url, tempDataCenterID);
                Connection connect = DBConnectionUtil.getConnectionByDBCenterID(dbID);
                return ConnectionProxy.getLocalInstance(connect, eas_ctx);
            }
            if (url.startsWith("jdbc:apache:commons:dbcp:")) {
                return DriverManager.getDriver("jdbc:apache:commons:dbcp:").connect(url, properties);
            }
            url = url.replaceAll("192.168.33.105", "192.168.76.175");
            return super.connect(url, properties);
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith("jdbc:etlsqlDB");
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    public int getMajorVersion() {
        return 3;
    }

    public int getMinorVersion() {
        return 0;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    static {
        try {
            DriverManager.registerDriver((java.sql.Driver)((Object)new DriverProxy()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

