/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.socket;

import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.LogForTestFactory;
import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.RMIInvoke;
import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.TimeOutException;
import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.socket.Bytes;
import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.socket.ResultObjPool;
import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.socket.TransportObj;
import com.kingdee.eas.framework.bireport.bimanager.util.UUID;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;

public class SocketClient
implements Runnable,
RMIInvoke {
    private SocketChannel socketChannal;
    private ByteBuffer buffer;
    private String socketServerHost = "127.0.0.1";
    private int port = 0;
    private String uuid;
    private Object lock = new Object();
    public boolean isOccupation = false;
    boolean isUse = false;
    private static final int WAITTIMEOUT = 600;
    boolean isRunning;

    public SocketClient(String socketServerHost, int port) throws IOException {
        this.socketServerHost = socketServerHost;
        this.port = port;
        this.init();
        this.uuid = UUID.randomUUID().toString();
        new Thread(this).start();
    }

    public void init() {
        try {
            this.socketChannal = SocketChannel.open();
            this.socketChannal.configureBlocking(false);
            this.socketChannal.connect(new InetSocketAddress(this.socketServerHost, this.port));
            this.buffer = ByteBuffer.allocate(8192);
            while (!this.socketChannal.finishConnect()) {
            }
            this.isRunning = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isUse() {
        return this.isUse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object obj) throws IOException {
        this.isUse = true;
        LogForTestFactory.getLogger().info("set isUse=true");
        try {
            if (this.socketChannal != null && this.socketChannal.isConnected()) {
                TransportObj transobj = new TransportObj(obj);
                this.socketChannal.write(ByteBuffer.wrap(Bytes.getBytes(transobj)));
                this.wait(transobj, 600);
                if (transobj.result == null || "null".equalsIgnoreCase(transobj.result.toString())) {
                    Object var3_4 = null;
                    return var3_4;
                }
                Object object = transobj.result;
                return object;
            }
        }
        catch (Exception e) {
            Exception exception = e;
            return exception;
        }
        finally {
            LogForTestFactory.getLogger().info("set isUse =false");
            this.isUse = false;
        }
        return null;
    }

    public boolean isConnection() {
        if (this.socketChannal == null) {
            return false;
        }
        return this.socketChannal.isConnected();
    }

    public void readMessage() throws Exception {
        int sum = 0;
        int len = 0;
        LinkedList<byte[]> list = new LinkedList<byte[]>();
        this.buffer.clear();
        boolean falg = false;
        while (this.isRunning && ((len = this.socketChannal.read(this.buffer)) != 0 || !falg)) {
            if (len == 0) {
                Thread.sleep(50L);
                continue;
            }
            this.buffer.flip();
            sum += len;
            list.add(Bytes.toCopy(this.buffer.array(), len));
            this.buffer.clear();
            falg = true;
        }
        Object result = null;
        result = list.size() == 1 ? Bytes.getObject((byte[])list.get(0)) : Bytes.getObject(list, sum);
        if (result instanceof TransportObj) {
            TransportObj to = (TransportObj)result;
            ResultObjPool.getInstance().receveMsg(this.uuid, to);
        } else {
            LogForTestFactory.getLogger().info("\u63a5\u53d7\u6d88\u606f\u6709\u8bef\uff0c--------");
            LogForTestFactory.getLogger().info(result.getClass().toString());
            System.out.println("\u63a5\u53d7\u6d88\u606f\u6709\u8bef\uff0c--------");
        }
    }

    @Override
    public void run() {
        while (this.isRunning) {
            try {
                this.readMessage();
            }
            catch (Exception exception) {}
        }
        System.out.println("\u5ba2\u6237\u7aef\u53d6\u6d88\u76d1\u542c\u6d88\u606f\uff01\u5173\u95ed\u5ba2\u6237\u7aef");
        LogForTestFactory.getLogger().info("\u5ba2\u6237\u7aef\u53d6\u6d88\u76d1\u542c\u6d88\u606f\uff01\u5173\u95ed\u5ba2\u6237\u7aef");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wait(TransportObj obj, int count) throws TimeOutException {
        ResultObjPool.getInstance().storeObj(this.uuid, obj);
        while (count != 0) {
            --count;
            Object object = obj.lock;
            synchronized (object) {
                if (obj.isComplete) {
                    return;
                }
                try {
                    obj.lock.wait(500L);
                }
                catch (InterruptedException e) {
                    obj.command = e;
                }
                if (!obj.isComplete) {
                    this.reSend(obj);
                }
            }
        }
        if (count == 0) {
            throw new TimeOutException();
        }
    }

    private void reSend(TransportObj obj) {
        try {
            this.socketChannal.write(ByteBuffer.wrap(Bytes.getBytes(obj)));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void close() {
        while (this.isUse()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.socketChannal != null && this.socketChannal.isOpen()) {
            try {
                this.socketChannal.close();
                if (!this.socketChannal.socket().isClosed()) {
                    this.socketChannal.socket().close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.buffer != null) {
            this.buffer.clear();
        }
        this.isRunning = false;
        ResultObjPool.getInstance().close(this.uuid);
    }

    public static void main(String[] args) {
        try {
            SocketClient client = new SocketClient("localhost", 1001);
            Thread.yield();
            Object result = client.invoke("asdfasfd");
            System.out.println(result);
            System.out.println(client.invoke("asdfasfd"));
            System.out.println(client.invoke("afdas"));
            System.out.println(client.invoke("asdfaadfassfd"));
            System.out.println(client.invoke("asdfafdasdfasfd"));
            client.close();
            System.out.println("\u5173\u95ed\u8fde\u63a5");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void exit() {
        this.isRunning = false;
        this.close();
    }
}

