/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.transport.socket.nio.support;

import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.ByteBuffer;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.ExceptionMonitor;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.IoAcceptor;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.IoFilter;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.IoHandler;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.IoServiceConfig;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.IoSession;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.IoSessionRecycler;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.support.BaseIoAcceptor;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.support.IoServiceListenerSupport;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.transport.socket.nio.DatagramAcceptorConfig;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.transport.socket.nio.DatagramServiceConfig;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.transport.socket.nio.DatagramSessionConfig;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.transport.socket.nio.support.DatagramFilterChain;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.transport.socket.nio.support.DatagramService;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.transport.socket.nio.support.DatagramSessionImpl;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.util.NamePreservingRunnable;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.util.Queue;
import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DatagramAcceptorDelegate
extends BaseIoAcceptor
implements IoAcceptor,
DatagramService {
    private static volatile int nextId = 0;
    private final IoAcceptor wrapper;
    private final Executor executor;
    private final int id = nextId++;
    private Selector selector;
    private DatagramAcceptorConfig defaultConfig = new DatagramAcceptorConfig();
    private final Map channels = new HashMap();
    private final Queue registerQueue = new Queue();
    private final Queue cancelQueue = new Queue();
    private final Queue flushingSessions = new Queue();
    private Worker worker;

    public DatagramAcceptorDelegate(IoAcceptor wrapper, Executor executor) {
        this.wrapper = wrapper;
        this.executor = executor;
        ((DatagramSessionConfig)this.defaultConfig.getSessionConfig()).setReuseAddress(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(SocketAddress address, IoHandler handler, IoServiceConfig config) throws IOException {
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        if (config == null) {
            config = this.getDefaultConfig();
        }
        if (address != null && !(address instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unexpected address type: " + address.getClass());
        }
        RegistrationRequest request = new RegistrationRequest(address, handler, config);
        Object object = this;
        synchronized (object) {
            Queue queue = this.registerQueue;
            synchronized (queue) {
                this.registerQueue.push(request);
            }
            this.startupWorker();
            this.selector.wakeup();
        }
        object = request;
        synchronized (object) {
            while (!request.done) {
                try {
                    request.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (request.exception != null) {
            throw (IOException)new IOException("Failed to bind").initCause(request.exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbind(SocketAddress address) {
        if (address == null) {
            throw new NullPointerException("address");
        }
        CancellationRequest request = new CancellationRequest(address);
        Object object = this;
        synchronized (object) {
            try {
                this.startupWorker();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Address not bound: " + address);
            }
            Queue queue = this.cancelQueue;
            synchronized (queue) {
                this.cancelQueue.push(request);
            }
            this.selector.wakeup();
        }
        object = request;
        synchronized (object) {
            while (!request.done) {
                try {
                    request.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (request.exception != null) {
            throw new RuntimeException("Failed to unbind", request.exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbindAll() {
        ArrayList addresses;
        Map map = this.channels;
        synchronized (map) {
            addresses = new ArrayList(this.channels.keySet());
        }
        Iterator i = addresses.iterator();
        while (i.hasNext()) {
            this.unbind((SocketAddress)i.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IoSession newSession(SocketAddress remoteAddress, SocketAddress localAddress) {
        IoSession session;
        IoSessionRecycler sessionRecycler;
        if (remoteAddress == null) {
            throw new NullPointerException("remoteAddress");
        }
        if (localAddress == null) {
            throw new NullPointerException("localAddress");
        }
        Selector selector = this.getSelector();
        DatagramChannel ch = (DatagramChannel)this.channels.get(localAddress);
        if (selector == null || ch == null) {
            throw new IllegalArgumentException("Unknown localAddress: " + localAddress);
        }
        SelectionKey key = ch.keyFor(selector);
        if (key == null) {
            throw new IllegalArgumentException("Unknown localAddress: " + localAddress);
        }
        RegistrationRequest req = (RegistrationRequest)key.attachment();
        IoSessionRecycler ioSessionRecycler = sessionRecycler = this.getSessionRecycler(req);
        synchronized (ioSessionRecycler) {
            session = sessionRecycler.recycle(localAddress, remoteAddress);
            if (session != null) {
                return session;
            }
            DatagramSessionImpl datagramSession = new DatagramSessionImpl(this.wrapper, this, req.config, ch, req.handler, req.address, req.address);
            datagramSession.setRemoteAddress(remoteAddress);
            datagramSession.setSelectionKey(key);
            this.getSessionRecycler(req).put(datagramSession);
            session = datagramSession;
        }
        try {
            this.buildFilterChain(req, session);
            this.getListeners().fireSessionCreated(session);
        }
        catch (Throwable t) {
            ExceptionMonitor.getInstance().exceptionCaught(t);
        }
        return session;
    }

    private IoSessionRecycler getSessionRecycler(RegistrationRequest req) {
        IoSessionRecycler sessionRecycler = req.config instanceof DatagramServiceConfig ? ((DatagramServiceConfig)req.config).getSessionRecycler() : this.defaultConfig.getSessionRecycler();
        return sessionRecycler;
    }

    @Override
    public IoServiceListenerSupport getListeners() {
        return super.getListeners();
    }

    private void buildFilterChain(RegistrationRequest req, IoSession session) throws Exception {
        this.getFilterChainBuilder().buildFilterChain(session.getFilterChain());
        req.config.getFilterChainBuilder().buildFilterChain(session.getFilterChain());
        req.config.getThreadModel().buildFilterChain(session.getFilterChain());
    }

    @Override
    public IoServiceConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public void setDefaultConfig(DatagramAcceptorConfig defaultConfig) {
        if (defaultConfig == null) {
            throw new NullPointerException("defaultConfig");
        }
        this.defaultConfig = defaultConfig;
    }

    private synchronized Selector getSelector() {
        return this.selector;
    }

    private synchronized void startupWorker() throws IOException {
        if (this.worker == null) {
            this.selector = Selector.open();
            this.worker = new Worker();
            this.executor.execute((Runnable)new NamePreservingRunnable(this.worker, "DatagramAcceptor-" + this.id));
        }
    }

    @Override
    public void flushSession(DatagramSessionImpl session) {
        Selector selector;
        if (this.scheduleFlush(session) && (selector = this.getSelector()) != null) {
            selector.wakeup();
        }
    }

    @Override
    public void closeSession(DatagramSessionImpl session) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean scheduleFlush(DatagramSessionImpl session) {
        if (session.setScheduledForFlush(true)) {
            Queue queue = this.flushingSessions;
            synchronized (queue) {
                this.flushingSessions.push(session);
            }
            return true;
        }
        return false;
    }

    private void processReadySessions(Set keys) {
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            SelectionKey key = (SelectionKey)it.next();
            it.remove();
            DatagramChannel ch = (DatagramChannel)key.channel();
            RegistrationRequest req = (RegistrationRequest)key.attachment();
            try {
                if (key.isReadable()) {
                    this.readSession(ch, req);
                }
                if (!key.isWritable()) continue;
                Iterator i = this.getManagedSessions(req.address).iterator();
                while (i.hasNext()) {
                    this.scheduleFlush((DatagramSessionImpl)i.next());
                }
            }
            catch (Throwable t) {
                ExceptionMonitor.getInstance().exceptionCaught(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSession(DatagramChannel channel, RegistrationRequest req) throws Exception {
        ByteBuffer readBuf = ByteBuffer.allocate(((DatagramSessionConfig)req.config.getSessionConfig()).getReceiveBufferSize());
        try {
            SocketAddress remoteAddress = channel.receive(readBuf.buf());
            if (remoteAddress != null) {
                DatagramSessionImpl session = (DatagramSessionImpl)this.newSession(remoteAddress, req.address);
                readBuf.flip();
                ByteBuffer newBuf = ByteBuffer.allocate(readBuf.limit());
                newBuf.put(readBuf);
                newBuf.flip();
                session.increaseReadBytes(newBuf.remaining());
                session.getFilterChain().fireMessageReceived(session, newBuf);
            }
        }
        finally {
            readBuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushSessions() {
        if (this.flushingSessions.size() == 0) {
            return;
        }
        while (true) {
            DatagramSessionImpl session;
            Queue queue = this.flushingSessions;
            synchronized (queue) {
                session = (DatagramSessionImpl)this.flushingSessions.pop();
            }
            if (session == null) break;
            session.setScheduledForFlush(false);
            try {
                boolean flushedAll = this.flush(session);
                if (!flushedAll || session.getWriteRequestQueue().isEmpty() || session.isScheduledForFlush()) continue;
                this.scheduleFlush(session);
            }
            catch (IOException e) {
                session.getFilterChain().fireExceptionCaught(session, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean flush(DatagramSessionImpl session) throws IOException {
        SelectionKey key = session.getSelectionKey();
        if (key == null) {
            this.scheduleFlush(session);
            return false;
        }
        if (!key.isValid()) {
            return false;
        }
        key.interestOps(key.interestOps() & 0xFFFFFFFB);
        DatagramChannel ch = session.getChannel();
        Queue writeRequestQueue = session.getWriteRequestQueue();
        int writtenBytes = 0;
        int maxWrittenBytes = ((DatagramSessionConfig)session.getConfig()).getSendBufferSize() << 1;
        try {
            while (true) {
                int localWrittenBytes;
                IoFilter.WriteRequest req;
                Queue queue = writeRequestQueue;
                synchronized (queue) {
                    req = (IoFilter.WriteRequest)writeRequestQueue.first();
                }
                if (req == null) {
                    break;
                }
                ByteBuffer buf = (ByteBuffer)req.getMessage();
                if (buf.remaining() == 0) {
                    Queue queue2 = writeRequestQueue;
                    synchronized (queue2) {
                        writeRequestQueue.pop();
                    }
                    buf.reset();
                    if (!buf.hasRemaining()) {
                        session.increaseWrittenMessages();
                    }
                    ((DatagramFilterChain)session.getFilterChain()).fireMessageSent(session, req);
                    continue;
                }
                SocketAddress destination = req.getDestination();
                if (destination == null) {
                    destination = session.getRemoteAddress();
                }
                if ((localWrittenBytes = ch.send(buf.buf(), destination)) == 0 || (writtenBytes += localWrittenBytes) >= maxWrittenBytes) {
                    key.interestOps(key.interestOps() | 4);
                    boolean bl = false;
                    return bl;
                }
                Queue queue3 = writeRequestQueue;
                synchronized (queue3) {
                    writeRequestQueue.pop();
                }
                buf.reset();
                if (!buf.hasRemaining()) {
                    session.increaseWrittenMessages();
                }
                session.getFilterChain().fireMessageSent(session, req);
            }
        }
        finally {
            session.increaseWrittenBytes(writtenBytes);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void registerNew() {
        if (this.registerQueue.isEmpty()) {
            return;
        }
        Selector selector = this.getSelector();
        while (true) {
            Object cfg;
            RegistrationRequest req;
            Queue queue = this.registerQueue;
            synchronized (queue) {
                req = (RegistrationRequest)this.registerQueue.pop();
            }
            if (req == null) return;
            DatagramChannel ch = null;
            try {
                ch = DatagramChannel.open();
                cfg = req.config.getSessionConfig() instanceof DatagramSessionConfig ? (DatagramSessionConfig)req.config.getSessionConfig() : (DatagramSessionConfig)this.getDefaultConfig().getSessionConfig();
                ch.socket().setReuseAddress(cfg.isReuseAddress());
                ch.socket().setBroadcast(cfg.isBroadcast());
                ch.socket().setReceiveBufferSize(cfg.getReceiveBufferSize());
                ch.socket().setSendBufferSize(cfg.getSendBufferSize());
                if (ch.socket().getTrafficClass() != cfg.getTrafficClass()) {
                    ch.socket().setTrafficClass(cfg.getTrafficClass());
                }
                ch.configureBlocking(false);
                ch.socket().bind(req.address);
                if (req.address == null || req.address.getPort() == 0) {
                    req.address = (InetSocketAddress)ch.socket().getLocalSocketAddress();
                }
                ch.register(selector, 1, req);
                Map map = this.channels;
                synchronized (map) {
                    this.channels.put(req.address, ch);
                }
                this.getListeners().fireServiceActivated(this, req.address, req.handler, req.config);
                continue;
            }
            catch (Throwable t) {
                req.exception = t;
                continue;
            }
            finally {
                cfg = req;
                synchronized (cfg) {
                    req.done = true;
                    req.notify();
                }
                if (ch == null || req.exception == null) continue;
                try {
                    ch.disconnect();
                    ch.close();
                }
                catch (Throwable e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                }
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void cancelKeys() {
        if (this.cancelQueue.isEmpty()) {
            return;
        }
        Selector selector = this.getSelector();
        while (true) {
            Object key;
            DatagramChannel ch;
            CancellationRequest request;
            Queue queue = this.cancelQueue;
            synchronized (queue) {
                request = (CancellationRequest)this.cancelQueue.pop();
            }
            if (request == null) return;
            Map map = this.channels;
            synchronized (map) {
                ch = (DatagramChannel)this.channels.remove(request.address);
            }
            try {
                if (ch == null) {
                    request.exception = new IllegalArgumentException("Address not bound: " + request.address);
                    continue;
                }
                key = ch.keyFor(selector);
                request.registrationRequest = (RegistrationRequest)((SelectionKey)key).attachment();
                ((SelectionKey)key).cancel();
                selector.wakeup();
                ch.disconnect();
                ch.close();
                continue;
            }
            catch (Throwable t) {
                ExceptionMonitor.getInstance().exceptionCaught(t);
                continue;
            }
            finally {
                key = request;
                synchronized (key) {
                    request.done = true;
                    request.notify();
                }
                if (request.exception != null) continue;
                this.getListeners().fireServiceDeactivated(this, request.address, request.registrationRequest.handler, request.registrationRequest.config);
                continue;
            }
            break;
        }
    }

    @Override
    public void updateTrafficMask(DatagramSessionImpl session) {
    }

    private static class CancellationRequest {
        private final SocketAddress address;
        private boolean done;
        private RegistrationRequest registrationRequest;
        private RuntimeException exception;

        private CancellationRequest(SocketAddress address) {
            this.address = address;
        }
    }

    private static class RegistrationRequest {
        private InetSocketAddress address;
        private final IoHandler handler;
        private final IoServiceConfig config;
        private Throwable exception;
        private boolean done;

        private RegistrationRequest(SocketAddress address, IoHandler handler, IoServiceConfig config) {
            this.address = (InetSocketAddress)address;
            this.handler = handler;
            this.config = config;
        }
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Selector selector = DatagramAcceptorDelegate.this.getSelector();
            while (true) {
                try {
                    do {
                        int nKeys = selector.select();
                        DatagramAcceptorDelegate.this.registerNew();
                        if (nKeys > 0) {
                            DatagramAcceptorDelegate.this.processReadySessions(selector.selectedKeys());
                        }
                        DatagramAcceptorDelegate.this.flushSessions();
                        DatagramAcceptorDelegate.this.cancelKeys();
                    } while (!selector.keys().isEmpty());
                    DatagramAcceptorDelegate datagramAcceptorDelegate = DatagramAcceptorDelegate.this;
                    synchronized (datagramAcceptorDelegate) {
                        if (selector.keys().isEmpty() && DatagramAcceptorDelegate.this.registerQueue.isEmpty() && DatagramAcceptorDelegate.this.cancelQueue.isEmpty()) {
                            DatagramAcceptorDelegate.this.worker = null;
                            try {
                                selector.close();
                            }
                            catch (IOException e) {
                                ExceptionMonitor.getInstance().exceptionCaught(e);
                            }
                            finally {
                                DatagramAcceptorDelegate.this.selector = null;
                            }
                            break;
                        }
                        continue;
                    }
                }
                catch (IOException e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                break;
            }
        }
    }
}

