/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.transport.vmpipe.support;

import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.IdleStatus;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.transport.vmpipe.support.VmPipeSessionImpl;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class VmPipeIdleStatusChecker {
    private static final VmPipeIdleStatusChecker INSTANCE = new VmPipeIdleStatusChecker();
    private final Map sessions = new HashMap();
    private final Worker worker = new Worker();

    public static VmPipeIdleStatusChecker getInstance() {
        return INSTANCE;
    }

    private VmPipeIdleStatusChecker() {
        this.worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSession(VmPipeSessionImpl session) {
        Map map = this.sessions;
        synchronized (map) {
            this.sessions.put(session, session);
        }
    }

    private void notifyIdleSession(VmPipeSessionImpl session, long currentTime) {
        this.notifyIdleSession0(session, currentTime, session.getIdleTimeInMillis(IdleStatus.BOTH_IDLE), IdleStatus.BOTH_IDLE, Math.max(session.getLastIoTime(), session.getLastIdleTime(IdleStatus.BOTH_IDLE)));
        this.notifyIdleSession0(session, currentTime, session.getIdleTimeInMillis(IdleStatus.READER_IDLE), IdleStatus.READER_IDLE, Math.max(session.getLastReadTime(), session.getLastIdleTime(IdleStatus.READER_IDLE)));
        this.notifyIdleSession0(session, currentTime, session.getIdleTimeInMillis(IdleStatus.WRITER_IDLE), IdleStatus.WRITER_IDLE, Math.max(session.getLastWriteTime(), session.getLastIdleTime(IdleStatus.WRITER_IDLE)));
    }

    private void notifyIdleSession0(VmPipeSessionImpl session, long currentTime, long idleTime, IdleStatus status, long lastIoTime) {
        if (idleTime > 0L && lastIoTime != 0L && currentTime - lastIoTime >= idleTime) {
            session.increaseIdleCount(status);
            session.getFilterChain().fireSessionIdle(session, status);
        }
    }

    private class Worker
    extends Thread {
        private Worker() {
            super("VmPipeIdleStatusChecker");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                long currentTime = System.currentTimeMillis();
                Map map = VmPipeIdleStatusChecker.this.sessions;
                synchronized (map) {
                    Iterator it = VmPipeIdleStatusChecker.this.sessions.keySet().iterator();
                    while (it.hasNext()) {
                        VmPipeSessionImpl session = (VmPipeSessionImpl)it.next();
                        if (!session.isConnected()) {
                            it.remove();
                            continue;
                        }
                        VmPipeIdleStatusChecker.this.notifyIdleSession(session, currentTime);
                    }
                }
            }
        }
    }
}

