/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.util;

import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.util.ExpirationListener;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReadWriteLock;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class ExpiringMap
implements Map {
    public static final int DEFAULT_TIME_TO_LIVE = 60;
    public static final int DEFAULT_EXPIRATION_INTERVAL = 1;
    private static volatile int expirerCount = 1;
    private final ConcurrentHashMap delegate;
    private final CopyOnWriteArrayList expirationListeners;
    private final Expirer expirer;

    public ExpiringMap() {
        this(60, 1);
    }

    public ExpiringMap(int timeToLive) {
        this(timeToLive, 1);
    }

    public ExpiringMap(int timeToLive, int expirationInterval) {
        this(new ConcurrentHashMap(), new CopyOnWriteArrayList(), timeToLive, expirationInterval);
    }

    private ExpiringMap(ConcurrentHashMap delegate, CopyOnWriteArrayList expirationListeners, int timeToLive, int expirationInterval) {
        this.delegate = delegate;
        this.expirationListeners = expirationListeners;
        this.expirer = new Expirer();
        this.expirer.setTimeToLive(timeToLive);
        this.expirer.setExpirationInterval(expirationInterval);
    }

    public Object put(Object key, Object value) {
        return this.delegate.put(key, (Object)new ExpiringObject(key, value, System.currentTimeMillis()));
    }

    public Object get(Object key) {
        Object object = this.delegate.get(key);
        if (object != null) {
            ExpiringObject expObject = (ExpiringObject)object;
            expObject.setLastAccessTime(System.currentTimeMillis());
            return expObject.getValue();
        }
        return object;
    }

    public Object remove(Object key) {
        return this.delegate.remove(key);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public Set keySet() {
        return this.delegate.keySet();
    }

    @Override
    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map inMap) {
        Map map = inMap;
        synchronized (map) {
            for (Object key : inMap.keySet()) {
                Object value = inMap.get(key);
                if (!(value instanceof ExpiringObject)) continue;
                this.delegate.put(key, value);
            }
        }
    }

    public Collection values() {
        return this.delegate.values();
    }

    public Set entrySet() {
        return this.delegate.entrySet();
    }

    public void addExpirationListener(ExpirationListener listener) {
        this.expirationListeners.add((Object)listener);
    }

    public void removeExpirationListener(ExpirationListener listener) {
        this.expirationListeners.remove((Object)listener);
    }

    public Expirer getExpirer() {
        return this.expirer;
    }

    public int getExpirationInterval() {
        return this.expirer.getExpirationInterval();
    }

    public int getTimeToLive() {
        return this.expirer.getTimeToLive();
    }

    public void setExpirationInterval(int expirationInterval) {
        this.expirer.setExpirationInterval(expirationInterval);
    }

    public void setTimeToLive(int timeToLive) {
        this.expirer.setTimeToLive(timeToLive);
    }

    static /* synthetic */ int access$008() {
        return expirerCount++;
    }

    public class Expirer
    implements Runnable {
        private ReadWriteLock stateLock = new ReentrantReadWriteLock();
        private long timeToLiveMillis;
        private long expirationIntervalMillis;
        private boolean running = false;
        private final Thread expirerThread = new Thread((Runnable)this, "ExpiringMapExpirer-" + ExpiringMap.access$008());

        public Expirer() {
            this.expirerThread.setDaemon(true);
        }

        @Override
        public void run() {
            while (this.running) {
                this.processExpires();
                try {
                    Thread.sleep(this.expirationIntervalMillis);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        private void processExpires() {
            long timeNow = System.currentTimeMillis();
            for (ExpiringObject expObject : ExpiringMap.this.delegate.values()) {
                long timeIdle;
                if (this.timeToLiveMillis <= 0L || (timeIdle = timeNow - expObject.getLastAccessTime()) < this.timeToLiveMillis) continue;
                ExpiringMap.this.delegate.remove(expObject.getKey());
                for (ExpirationListener listener : ExpiringMap.this.expirationListeners) {
                    listener.expired(expObject.getValue());
                }
            }
        }

        public void startExpiring() {
            this.stateLock.writeLock().lock();
            try {
                if (!this.running) {
                    this.running = true;
                    this.expirerThread.start();
                }
            }
            finally {
                this.stateLock.writeLock().unlock();
            }
        }

        public void startExpiringIfNotStarted() {
            this.stateLock.readLock().lock();
            try {
                if (this.running) {
                    return;
                }
            }
            finally {
                this.stateLock.readLock().unlock();
            }
            this.stateLock.writeLock().lock();
            try {
                if (!this.running) {
                    this.running = true;
                    this.expirerThread.start();
                }
            }
            finally {
                this.stateLock.writeLock().unlock();
            }
        }

        public void stopExpiring() {
            this.stateLock.writeLock().lock();
            try {
                if (this.running) {
                    this.running = false;
                    this.expirerThread.interrupt();
                }
            }
            finally {
                this.stateLock.writeLock().unlock();
            }
        }

        public boolean isRunning() {
            this.stateLock.readLock().lock();
            try {
                boolean bl = this.running;
                return bl;
            }
            finally {
                this.stateLock.readLock().unlock();
            }
        }

        public int getTimeToLive() {
            this.stateLock.readLock().lock();
            try {
                int n = (int)this.timeToLiveMillis / 1000;
                return n;
            }
            finally {
                this.stateLock.readLock().unlock();
            }
        }

        public void setTimeToLive(long timeToLive) {
            this.stateLock.writeLock().lock();
            try {
                this.timeToLiveMillis = timeToLive * 1000L;
            }
            finally {
                this.stateLock.writeLock().unlock();
            }
        }

        public int getExpirationInterval() {
            this.stateLock.readLock().lock();
            try {
                int n = (int)this.expirationIntervalMillis / 1000;
                return n;
            }
            finally {
                this.stateLock.readLock().unlock();
            }
        }

        public void setExpirationInterval(long expirationInterval) {
            this.stateLock.writeLock().lock();
            try {
                this.expirationIntervalMillis = expirationInterval * 1000L;
            }
            finally {
                this.stateLock.writeLock().unlock();
            }
        }
    }

    private class ExpiringObject {
        private Object key;
        private Object value;
        private long lastAccessTime;
        private ReadWriteLock lastAccessTimeLock = new ReentrantReadWriteLock();

        public ExpiringObject(Object key, Object value, long lastAccessTime) {
            if (value == null) {
                throw new IllegalArgumentException("An expiring object cannot be null.");
            }
            this.key = key;
            this.value = value;
            this.lastAccessTime = lastAccessTime;
        }

        public long getLastAccessTime() {
            this.lastAccessTimeLock.readLock().lock();
            try {
                long l = this.lastAccessTime;
                return l;
            }
            finally {
                this.lastAccessTimeLock.readLock().unlock();
            }
        }

        public void setLastAccessTime(long lastAccessTime) {
            this.lastAccessTimeLock.writeLock().lock();
            try {
                this.lastAccessTime = lastAccessTime;
            }
            finally {
                this.lastAccessTimeLock.writeLock().unlock();
            }
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            return this.value.equals(obj);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

