/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.web.app.spi;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSON;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.bireport.bimanager.web.BIWebUtil;
import com.kingdee.eas.framework.bireport.bimanager.web.IWebUtilFacade;
import com.kingdee.eas.framework.bireport.bimanager.web.WebUtilFacadeFactory;
import com.kingdee.eas.framework.bireport.bimanager.web.app.IBIManagerServer;
import com.kingdee.eas.framework.bireport.bimanager.web.jxl.ExcelToDB;
import com.kingdee.eas.framework.bireport.bimanager.web.jxl.UpExcelParseByPOIUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;

public class UploadHandler
implements IBIManagerServer {
    @Override
    public String getMappingActionName() {
        return "upload";
    }

    @Override
    public JSON service(Context ctx, HttpServletRequest request, HttpServletResponse response, IWebUtilFacade facade, OrgUnitInfo orgInfo, String currUserIDAndOrg) throws BIReportException, BOSException, EASBizException {
        List tableDefineList = this.getTableDefine(request);
        this.upload(request, response, tableDefineList, currUserIDAndOrg);
        return null;
    }

    private void upload(HttpServletRequest request, HttpServletResponse response, List list, String currUserID) {
        String filePath = this.uploadFile(request, response);
        this.uploadToDB(request, response, filePath, list, currUserID);
    }

    private void uploadToDB(HttpServletRequest request, HttpServletResponse response, String filePath, List list, String currUserID) {
        String msg;
        Map<String, String> infoMap = null;
        Date date = null;
        String periodDescrip = null;
        if (request.getParameter("baseOrFact").equalsIgnoreCase("factdata")) {
            int year = Integer.parseInt(request.getParameter("year"));
            String cycle = request.getParameter("cycle");
            String cycleType = request.getParameter("cycleType");
            infoMap = this.getReportDate(year, cycle, cycleType);
            infoMap.put("filePath", filePath);
            date = (Date)infoMap.get("date");
            periodDescrip = (String)infoMap.get("periodDescrip");
        } else {
            infoMap = new HashMap<String, String>();
            infoMap.put("filePath", filePath);
        }
        IWebUtilFacade facade = null;
        ExcelToDB excelToDB = new ExcelToDB();
        Map map = new HashMap();
        try {
            String path = request.getRealPath("/upload") + "\\" + filePath + ".xls";
            map = UpExcelParseByPOIUtil.readExcel(path, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String tableName = (String)((Map)list.get(0)).get("tablename");
        boolean isSuccess = false;
        String errorMsg = null;
        try {
            facade = WebUtilFacadeFactory.getRemoteInstance();
            isSuccess = facade.insert(tableName, currUserID, request.getParameter("treenode"), request.getParameter("baseOrFact"), map, list, infoMap);
        }
        catch (BOSException e) {
            errorMsg = e.getMessage();
        }
        catch (EASBizException e) {
            e.printStackTrace();
            errorMsg = e.getMessage();
        }
        if (isSuccess) {
            response.setContentType("text/html;charset=utf-8");
            msg = "{success:true,message:'\u4e0a\u4f20\u6210\u529f'}";
            PrintWriter out = null;
            try {
                out = response.getWriter();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (null != out) {
                out.print(msg);
            }
        } else {
            response.setContentType("text/html;charset=utf-8");
            msg = "{success:false,message:'" + errorMsg + "'}";
            PrintWriter out = null;
            try {
                out = response.getWriter();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (null != out) {
                out.print(msg);
            }
        }
    }

    private Map getReportDate(int year, String cycle, String cycleType) {
        HashMap<String, Object> returnVal = new HashMap<String, Object>();
        String yearAscii = "Year";
        String halfAscii = "HalfYear";
        String seasonAscii = "Quarter";
        String monthAscii = "Month";
        String weekAscii = "Week";
        String dayAscii = "Date";
        Object dateStr = null;
        Date date = null;
        String periodDescrip = "";
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        if (cycleType.equals(monthAscii)) {
            int month = Integer.parseInt(cycle);
            date = new Date(year - 1900, month - 1, 1);
            periodDescrip = String.valueOf(year) + "\u5e74" + (String.valueOf(cycle).length() == 1 ? "0" + String.valueOf(cycle) : String.valueOf(cycle)) + "\u6708";
        } else if (cycleType.equals(halfAscii)) {
            int month = (Integer.parseInt(cycle) - 1) * 6 + 1;
            date = new Date(year - 1900, month - 1, 1);
            periodDescrip = String.valueOf(year) + "\u5e74" + (Integer.parseInt(cycle) == 1 ? "\u4e0a\u534a\u5e74" : "\u4e0b\u534a\u5e74");
        } else if (cycleType.equals(yearAscii)) {
            date = new Date(year - 1900, 0, 1);
            periodDescrip = String.valueOf(year) + "\u5e74";
        } else if (cycleType.equals(seasonAscii)) {
            int month = (Integer.parseInt(cycle) - 1) * 3 + 1;
            date = new Date(year - 1900, month - 1, 1);
            switch (Integer.parseInt(cycle)) {
                case 1: {
                    periodDescrip = String.valueOf(year) + "\u5e741\u5b63\u5ea6";
                    break;
                }
                case 2: {
                    periodDescrip = String.valueOf(year) + "\u5e742\u5b63\u5ea6";
                    break;
                }
                case 3: {
                    periodDescrip = String.valueOf(year) + "\u5e743\u5b63\u5ea6";
                    break;
                }
                case 4: {
                    periodDescrip = String.valueOf(year) + "\u5e744\u5b63\u5ea6";
                    break;
                }
            }
        } else if (cycleType.equals(weekAscii)) {
            String[] cycleSplit = cycle.split("-");
            String firstDayOfYearStr = cycleSplit[0] + "-1-1";
            int weekDay = BIWebUtil.getWeekday(firstDayOfYearStr);
            int firstWeekDayOfYear = (7 - (weekDay - 1)) % 7 + 1;
            Date firstWeekDateOfYear = new Date(Integer.parseInt(cycleSplit[0]) - 1900, 0, firstWeekDayOfYear);
            long dayTime = 86400000L;
            Date submitDate = new Date(Integer.parseInt(cycleSplit[0]) - 1900, Integer.parseInt(cycleSplit[1]) - 1, Integer.parseInt(cycleSplit[2]));
            long weekNum = (submitDate.getTime() - firstWeekDateOfYear.getTime()) / (dayTime * 7L) + 1L;
            date = new Date(((weekNum - 1L) * 7L + (long)firstWeekDayOfYear) * dayTime + new Date(year - 1900, 0, 0).getTime());
            Date lastDayOfWeek = new Date(date.getTime() + 6L * dayTime);
            periodDescrip = sf.format(date) + "~~" + sf.format(lastDayOfWeek);
        } else if (cycleType.equals(dayAscii)) {
            String[] yyyy_mm_dd = cycle.split("-");
            int yyyy = Integer.parseInt(yyyy_mm_dd[0]);
            int mm = Integer.parseInt(yyyy_mm_dd[1]);
            int dd = Integer.parseInt(yyyy_mm_dd[2]);
            date = new Date(yyyy - 1900, mm - 1, dd);
            periodDescrip = sf.format(date);
        }
        returnVal.put("date", date);
        returnVal.put("periodDescrip", periodDescrip);
        return returnVal;
    }

    private String uploadFile(HttpServletRequest request, HttpServletResponse response) {
        String uploadPath = request.getRealPath("/upload");
        File f = new File(uploadPath);
        if (!f.exists()) {
            f.mkdirs();
        }
        String filePath = null;
        String pfileName = null;
        try {
            System.out.println("\u5f00\u59cb\u8fdb\u884c\u6587\u4ef6\u4e0a\u4f20");
            DiskFileUpload fu = null;
            fu = new DiskFileUpload();
            List fileItems = fu.parseRequest(request);
            for (FileItem fi : fileItems) {
                String fileName = fi.getName();
                if (fileName == null) continue;
                String extfile = fileName.substring(fileName.lastIndexOf("."));
                Timestamp now = new Timestamp(new Date().getTime());
                SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMddHHmmssSSS");
                pfileName = fmt.format(now).toString().trim();
                filePath = uploadPath + File.separator + pfileName + extfile;
                File file = new File(filePath);
                file.createNewFile();
                fi.write(file);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pfileName;
    }

    private List getTableDefine(HttpServletRequest request) throws BIReportException {
        Context ctx = BISystem.getContext((HttpServletRequest)request);
        IWebUtilFacade facade = null;
        List list = null;
        String currUserID = ctx.getCaller().toString();
        OrgUnitInfo orgInfo = BISystem.getCurrentOrgUnit((HttpServletRequest)request);
        String org = orgInfo.getId().toString();
        if ("basedata".equals(request.getParameter("baseOrFact"))) {
            try {
                facade = WebUtilFacadeFactory.getRemoteInstance();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            try {
                list = facade.getTableDefine(currUserID + "@" + org, request.getParameter("baseOrFact"), request.getParameter("treenode"));
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        } else if ("factdata".equals(request.getParameter("baseOrFact"))) {
            try {
                facade = WebUtilFacadeFactory.getRemoteInstance();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            try {
                list = facade.getTableDefine(currUserID + "@" + org, request.getParameter("baseOrFact"), request.getParameter("treenode"));
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return list;
    }
}

