/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.ws.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.bireport.bimanager.TableTypeEnum;
import com.kingdee.eas.framework.bireport.bimanager.basedata.TableIndexFactory;
import com.kingdee.eas.framework.bireport.bimanager.da.BaseDataInfo;
import com.kingdee.eas.framework.bireport.bimanager.da.FactDataInfo;
import com.kingdee.eas.framework.bireport.bimanager.ws.WsExtractSchemeInfo;
import com.kingdee.eas.framework.bireport.bimanager.ws.WsFactDataCollection;
import com.kingdee.eas.framework.bireport.bimanager.ws.WsFactDataFactory;
import com.kingdee.eas.framework.bireport.bimanager.ws.WsFactDataInfo;
import com.kingdee.eas.framework.bireport.bimanager.ws.app.AbstractWsFactDataControllerBean;
import com.kingdee.eas.framework.bireport.bimanager.ws.app.ResultSetToTemplateImpl;
import com.kingdee.eas.framework.bireport.bimanager.ws.util.DBTableStructHelper;
import com.kingdee.eas.framework.bireport.bimanager.ws.util.IResultSetHandle;
import com.kingdee.eas.framework.bireport.bimanager.ws.util.JDBCEASTemplate;
import com.kingdee.eas.framework.bireport.bimanager.ws.util.JDBCODSTemplate;
import com.kingdee.eas.framework.report.util.DBUtilx;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.util.UuidException;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class WsFactDataControllerBean
extends AbstractWsFactDataControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.framework.bireport.bimanager.ws.app.WsFactDataControllerBean");

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        view.setFilter(f);
        view.getSelector().add("wsScheme.*");
        view.getSelector().add("wsScheme.mappings.wsField");
        view.getSelector().add("wsScheme.mappings.modelField");
        view.getSelector().add("wsScheme.mappings.id");
        view.getSelector().add("*");
        WsFactDataInfo factInfo = WsFactDataFactory.getLocalInstance(ctx).getWsFactDataInfo(pk, view.getSelector());
        if (factInfo == null) {
            return;
        }
        try {
            String odsTbl = factInfo.getWsScheme().getODSStoreTable(ctx);
            String schemeId = factInfo.getWsScheme().getBIProjectScheme().getId().toString();
            String deleteSQL = "delete  from " + odsTbl + " where  FwsfactDataID='" + pk.toString() + "'";
            JDBCODSTemplate.execute(ctx, schemeId, deleteSQL, null);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        super._delete(ctx, pk);
    }

    private Set getIDSet(IObjectPK[] pks) {
        HashSet<IObjectPK> set = new HashSet<IObjectPK>();
        for (int i = 0; i < pks.length; ++i) {
            set.add(pks[i]);
        }
        return set;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        List list;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        view.setFilter(f);
        view.getSelector().add("wsScheme.*");
        view.getSelector().add("wsScheme.mappings.wsField");
        view.getSelector().add("wsScheme.mappings.modelField");
        view.getSelector().add("wsScheme.mappings.id");
        view.getSelector().add("*");
        f.getFilterItems().add(new FilterItemInfo("id", (Object)this.getIDSet(arrayPK), CompareType.INCLUDE));
        WsFactDataCollection collection = WsFactDataFactory.getLocalInstance(ctx).getWsFactDataCollection(view);
        HashMap schemeID_FactDatas = new HashMap();
        for (int i = 0; i < collection.size(); ++i) {
            String schemeID = collection.get(i).getWsScheme().getBIProjectScheme().getId().toString();
            if (!schemeID_FactDatas.containsKey(schemeID_FactDatas)) {
                schemeID_FactDatas.put(schemeID, new LinkedList());
            }
            list = (List)schemeID_FactDatas.get(schemeID_FactDatas);
            list.add(new Integer(i));
        }
        Iterator iterator = schemeID_FactDatas.keySet().iterator();
        while (iterator.hasNext()) {
            String schemeId = iterator.next().toString();
            list = (List)schemeID_FactDatas.get(schemeId);
            StringBuffer sb = new StringBuffer();
            try {
                for (int i = 0; i < list.size(); ++i) {
                    WsFactDataInfo factDataInfo = collection.get((Integer)list.get(i));
                    String storeTable = factDataInfo.getWsScheme().getODSStoreTable(ctx);
                    String factDataID = factDataInfo.getId().toString();
                    String deleteSQL = "delete  from " + storeTable + " where  FwsfactDataID='" + factDataID + "';";
                    sb.append(deleteSQL);
                }
                JDBCODSTemplate.execute(ctx, schemeId, sb.toString(), null);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        super._delete(ctx, arrayPK);
    }

    private void insertFactData(Context ctx, String factDataID) throws Exception {
        boolean huasParentID;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        view.setFilter(f);
        view.getSelector().add("wsScheme.*");
        view.getSelector().add("wsScheme.mappings.wsField");
        view.getSelector().add("wsScheme.mappings.modelField");
        view.getSelector().add("wsScheme.mappings.id");
        view.getSelector().add("*");
        ObjectUuidPK pk = new ObjectUuidPK(factDataID);
        WsFactDataInfo factInfo = WsFactDataFactory.getLocalInstance(ctx).getWsFactDataInfo((IObjectPK)pk, view.getSelector());
        if (factInfo.getWsScheme().getModelID() == null) {
            return;
        }
        String templateTbl = this.getTagetTbl(factInfo.getWsScheme().getModelID(), ctx);
        if (templateTbl == null) {
            return;
        }
        if (factInfo == null) {
            return;
        }
        String odsTbl = factInfo.getWsScheme().getODSStoreTable(ctx);
        String schemeId = factInfo.getWsScheme().getBIProjectScheme().getId().toString();
        String select = "select * from " + odsTbl + " where  FwsfactDataID='" + factDataID + "'";
        Map key_Type = DBTableStructHelper.getTableColumnKey_Type(ctx, schemeId, templateTbl);
        LinkedList fields = new LinkedList();
        boolean isFact = factInfo.getWsScheme().getModelType() == 1;
        StringBuffer insertSQl = this.getInsertSQL(key_Type, templateTbl, isFact, fields);
        int maxID = this.getMaxID(factInfo.getWsScheme(), ctx, schemeId, templateTbl);
        ResultSetToTemplateImpl templateImpl = new ResultSetToTemplateImpl(ctx, key_Type, factInfo, fields, maxID, isFact);
        List list = null;
        list = (List)JDBCODSTemplate.executeQuery(ctx, schemeId, select, null, templateImpl);
        int modelType = factInfo.getWsScheme().getModelType();
        if (modelType == 1) {
            JDBCODSTemplate.executeBatch(ctx, schemeId, insertSQl.toString(), list);
        } else {
            JDBCEASTemplate.executeBatch(ctx, insertSQl.toString(), list);
        }
        boolean bl = huasParentID = isFact ? false : this.hasParentID(key_Type);
        if (huasParentID) {
            // empty if block
        }
        String updateSql = "update T_BI_MNG_WsFactData set FisAudit=1 ,FAuditorID=?,FAuditDate=?  where Fid='" + factDataID + "'";
        SqlParams sp = new SqlParams();
        sp.addString(ctx.getCaller().toString());
        sp.addDate(new Date(new java.util.Date().getTime()));
        DBUtilx.execute((String)updateSql, (SqlParams)sp, (Context)ctx);
    }

    private boolean hasParentID(Map map) {
        Iterator iterator = map.keySet().iterator();
        boolean i = false;
        boolean isContainParentID = false;
        while (iterator.hasNext()) {
            String fieldName = iterator.next().toString();
            if (!"FparentID".equalsIgnoreCase(fieldName)) continue;
            isContainParentID = true;
            break;
        }
        return isContainParentID;
    }

    private int getMaxID(WsExtractSchemeInfo info, Context ctx, String schemeID, String tbl) throws Exception {
        String sql = "select max(fid)+1 as maxID from " + tbl;
        int modelType = info.getModelType();
        Object obj = null;
        obj = modelType == 1 ? JDBCODSTemplate.executeQuery(ctx, schemeID, sql, null, new IResultSetHandle(){

            @Override
            public Object handle(ResultSet rowSet) throws Exception {
                if (rowSet.next()) {
                    return "" + rowSet.getInt("maxID");
                }
                return "0";
            }
        }) : JDBCEASTemplate.executeQuery(ctx, sql, null, new IResultSetHandle(){

            @Override
            public Object handle(ResultSet rowSet) throws Exception {
                if (rowSet.next()) {
                    return "" + rowSet.getInt("maxID");
                }
                return "0";
            }
        });
        return new Integer(obj.toString());
    }

    private TableTypeEnum getTemplateTableType(boolean flag) {
        return flag ? TableTypeEnum.FactDataOdsTable : TableTypeEnum.BaseDataTable;
    }

    private String getTagetTbl(String modelID, Context ctx) throws BOSException, UuidException, EASBizException {
        IObjectValue value = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(BOSUuid.read((String)modelID).getType(), (IObjectPK)new ObjectUuidPK(modelID));
        if (value.get("factDataModel") instanceof IObjectValue) {
            IObjectValue modle = (IObjectValue)value.get("factDataModel");
            return TableIndexFactory.getLocalInstance(ctx).getTableNameById(modle.get("id").toString(), this.getTemplateTableType(true));
        }
        if (value.get("masterData") instanceof IObjectValue) {
            IObjectValue modle = (IObjectValue)value.get("masterData");
            return TableIndexFactory.getLocalInstance(ctx).getTableNameById(modle.get("id").toString(), this.getTemplateTableType(false));
        }
        return null;
    }

    private StringBuffer getInsertSQL(Map key_Type, String tbl, boolean isFact, List list) throws SQLException {
        String fieldName;
        StringBuffer sb = new StringBuffer();
        sb.append("insert into ");
        sb.append(tbl);
        sb.append("(");
        Iterator iterator = key_Type.keySet().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            fieldName = iterator.next().toString();
            if ("fid".equalsIgnoreCase(fieldName) || "Fcompany".equalsIgnoreCase(fieldName) || "FReportSource".equalsIgnoreCase(fieldName) || (!isFact ? "FBaseDataID".equalsIgnoreCase(fieldName) || "FparentID".equalsIgnoreCase(fieldName) : "FFactDataID".equalsIgnoreCase(fieldName) || "FReportDate".equalsIgnoreCase(fieldName))) continue;
            if (i != 0) {
                sb.append(",");
            }
            ++i;
            sb.append(fieldName);
            list.add(fieldName);
        }
        if (isFact) {
            sb.append(",FID,FFactDataID,FReportDate,Fcompany,FReportSource");
        } else {
            sb.append(",FID,FBaseDataID,Fcompany,FReportSource");
        }
        sb.append(")VALUES (");
        iterator = key_Type.keySet().iterator();
        i = 0;
        while (iterator.hasNext()) {
            fieldName = iterator.next().toString();
            if ("fid".equalsIgnoreCase(fieldName) || "Fcompany".equalsIgnoreCase(fieldName) || "FReportSource".equalsIgnoreCase(fieldName) || (!isFact ? "FBaseDataID".equalsIgnoreCase(fieldName) || "FparentID".equalsIgnoreCase(fieldName) : "FFactDataID".equalsIgnoreCase(fieldName) || "FReportDate".equalsIgnoreCase(fieldName))) continue;
            if (i != 0) {
                sb.append(",");
            }
            sb.append("?");
            ++i;
        }
        if (isFact) {
            sb.append(",?,?,?");
        } else {
            sb.append(",?,?,?,?");
        }
        sb.append(");\n");
        return sb;
    }

    @Override
    protected boolean _checkFactData(Context ctx, String factDataID, boolean flag) throws BOSException, EASBizException {
        if (flag) {
            try {
                this.insertFactData(ctx, factDataID);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        try {
            this.deleteFactData(ctx, factDataID);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    private void deleteFactData(Context ctx, String factDataID) throws Exception {
        int modelType;
        String deleteSQl;
        String uploadID;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        view.setFilter(f);
        view.getSelector().add("wsScheme.*");
        view.getSelector().add("wsScheme.mappings.wsField");
        view.getSelector().add("wsScheme.mappings.modelField");
        view.getSelector().add("wsScheme.mappings.id");
        view.getSelector().add("*");
        ObjectUuidPK pk = new ObjectUuidPK(factDataID);
        WsFactDataInfo factInfo = WsFactDataFactory.getLocalInstance(ctx).getWsFactDataInfo((IObjectPK)pk, view.getSelector());
        String modelID = factInfo.getWsScheme().getModelID();
        String schemeId = factInfo.getWsScheme().getBIProjectScheme().getId().toString();
        String templateTbl = this.getTagetTbl(modelID, ctx);
        if (templateTbl == null) {
            return;
        }
        if (factInfo == null) {
            return;
        }
        if (factInfo.getBaseData() instanceof BaseDataInfo) {
            uploadID = factInfo.getBaseData().getId().toString();
            deleteSQl = "delete " + templateTbl + " where FBaseDataID='" + uploadID + "'";
            modelType = factInfo.getWsScheme().getModelType();
            if (modelType == 1) {
                JDBCODSTemplate.execute(ctx, schemeId, deleteSQl, null);
            } else {
                JDBCEASTemplate.execute(ctx, deleteSQl, null);
            }
        }
        if (factInfo.getFactData() instanceof FactDataInfo) {
            uploadID = factInfo.getFactData().getId().toString();
            deleteSQl = "delete " + templateTbl + " where FFactDataID='" + uploadID + "'";
            modelType = factInfo.getWsScheme().getModelType();
            if (modelType == 1) {
                JDBCODSTemplate.execute(ctx, schemeId, deleteSQl, null);
            } else {
                JDBCEASTemplate.execute(ctx, deleteSQl, null);
            }
        }
        String updateSql = "update T_BI_MNG_WsFactData set FisAudit=0  ,FAuditorID=null,FAuditDate=null where Fid='" + factDataID + "'";
        DBUtilx.execute((String)updateSql, null, (Context)ctx);
    }
}

