/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.ws.engine.util;

import com.kingdee.eas.framework.bireport.bimanager.util.UUID;
import java.io.Serializable;
import java.util.Random;
import org.apache.log4j.Logger;

public class UUIDUtil
implements Serializable {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.framework.bireport.bimanager.ws.engine.util.UUIDUtil");
    private static final long serialVersionUID = 846703324199283832L;
    private Object lock = new Object();
    private long seed = 0L;
    private long delim = 0L;
    private long sequence = 0L;
    private static Random randomNumberGenerator = new Random();
    private static UUIDUtil uuid = new UUIDUtil();

    public UUIDUtil() {
        this.seed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void seed() {
        Object object = this.lock;
        synchronized (object) {
            while (this.seed == 0L) {
                this.seed = randomNumberGenerator.nextInt(99999);
            }
            while (this.seed < 10000L) {
                this.seed *= 10L;
            }
            this.seed *= 100000000000000L;
            this.delim = (long)randomNumberGenerator.nextInt(9) * 10000000000000L;
            this.sequence = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long genUuid() {
        Object object = this.lock;
        synchronized (object) {
            ++this.sequence;
            return this.seed + this.delim + this.sequence;
        }
    }

    public long getSequence() {
        return this.sequence;
    }

    public static long uuid() {
        return UUIDUtil.uuid_positive();
    }

    public static long uuid_positive() {
        long id;
        while ((id = uuid.genUuid()) <= 0L) {
            uuid.seed();
        }
        return id;
    }

    public static String UUID() {
        return UUID.randomUUID().toString();
    }

    public static boolean validUuid(String uuid) {
        return uuid != null && uuid.matches("\\d+");
    }

    public static long parseUuid(String uuid, long def) {
        if (uuid != null && uuid.matches("\\d+")) {
            return Long.parseLong(uuid);
        }
        return def;
    }
}

