/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.ws.paramCtx.translate;

import com.kingdee.bos.Context;
import com.kingdee.eas.framework.bireport.bimanager.ws.paramCtx.translate.TranslateInfo;
import com.kingdee.eas.framework.bireport.bimanager.ws.paramCtx.util.Strings;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class ExpressionInfo {
    private Context ctx;
    public static final String context_flag = "Client_Context:";
    private Map properties = new HashMap();
    public ExpressionInfo pre;
    public ExpressionInfo next;
    private String expression = null;
    public List list = new LinkedList();
    public String value = null;
    private String[] prefix;

    public ExpressionInfo(String expression, Context ctx) {
        this.expression = expression;
        this.init();
        this.ctx = ctx;
    }

    public String getExpression() {
        return this.expression;
    }

    public void add(String expression) {
        if (expression.startsWith("@")) {
            expression = Strings.trim(expression);
            TranslateInfo info = new TranslateInfo(expression, this.ctx);
            this.list.add(info);
        } else {
            this.list.add(expression);
        }
    }

    public void print() {
        for (Object object : this.list) {
            System.out.println(object);
        }
    }

    public String tranlate2Str() {
        this.value = this.toString();
        return this.value;
    }

    public String toString() {
        if (this.list.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (Object object : this.list) {
            sb.append(object.toString());
        }
        return sb.toString();
    }

    private void init() {
        if (Strings.isEmpty(this.expression)) {
            return;
        }
        this.translateExpression();
    }

    public static void main(String[] args) {
        ExpressionInfo info = new ExpressionInfo("@xxx ddd@ddd (d)@aee()adfasf@@ @e3ee( ())cdd@d ddd(", null);
        info.print();
    }

    public String toStringAtApp() {
        if (this.list.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (Object object : this.list) {
            if (object instanceof TranslateInfo) {
                TranslateInfo info = (TranslateInfo)object;
                if (this.properties.containsKey(info.source)) {
                    sb.append(this.properties.get(info.source));
                    continue;
                }
            }
            sb.append(object);
        }
        return sb.toString();
    }

    public void translateExpression() {
        this.dealWithContext();
        char[] chars = this.expression.toCharArray();
        boolean isHasAtBefor = false;
        StringBuffer sb = null;
        int stringStart = 0;
        Stack<String> stack = new Stack<String>();
        for (int i = 0; i < chars.length; ++i) {
            if (!isHasAtBefor && chars[i] == '@') {
                if (chars.length != i + 1 && chars[i + 1] != '@') {
                    if (i != 0 && !isHasAtBefor && stringStart < i) {
                        this.add(this.expression.substring(stringStart, i));
                        stringStart = i;
                    }
                    isHasAtBefor = true;
                    sb = new StringBuffer();
                    sb.append(chars[i]);
                    continue;
                }
                if (i > 0 && chars[i - 1] == '@') continue;
            }
            if (!isHasAtBefor) continue;
            if (chars[i] == '@' && stack.isEmpty()) {
                this.add(sb.toString());
                stringStart = i + 1;
                isHasAtBefor = true;
                sb = new StringBuffer();
                sb.append(chars[i]);
                continue;
            }
            if (chars[i] == ' ') {
                if (sb.length() == 1) {
                    isHasAtBefor = false;
                    sb = null;
                    continue;
                }
                if (this.isHKNext(chars, i + 1)) continue;
                if (stack.size() == 0) {
                    stringStart = i;
                    this.add(sb.toString());
                    isHasAtBefor = false;
                    continue;
                }
            }
            sb.append(chars[i]);
            if ('(' == chars[i]) {
                stack.push("(");
            }
            if (')' == chars[i]) {
                stack.pop();
                if ((i == chars.length - 1 || chars[i + 1] != '.') && stack.size() == 0) {
                    stringStart = i + 1;
                    this.add(sb.toString());
                    isHasAtBefor = false;
                    continue;
                }
            }
            if (i != chars.length - 1 || !isHasAtBefor) continue;
            this.add(sb.toString());
            stringStart = i + 1;
            isHasAtBefor = false;
        }
        if (stringStart != this.expression.length()) {
            this.add(this.expression.substring(stringStart, this.expression.length()));
        }
    }

    private void dealWithContext() {
        int ctxStart = this.expression.indexOf(context_flag);
        if (ctxStart < 0) {
            return;
        }
        String ctx_str = this.expression.substring(ctxStart + context_flag.length(), this.expression.length());
        this.expression = this.expression.substring(0, ctxStart);
        String[] ctxs = ctx_str.split(";");
        for (int i = 0; i < ctxs.length; ++i) {
            int equalsStart = ctxs[i].indexOf("=");
            this.properties.put(ctxs[i].subSequence(0, equalsStart), ctxs[i].subSequence(equalsStart + 1, ctxs[i].length()));
        }
    }

    private boolean isHKNext(char[] chs, int index) {
        int length = chs.length;
        for (int i = index; i < length; ++i) {
            if (chs[i] == ' ') continue;
            return chs[i] == '(';
        }
        return false;
    }

    public String toSaveStr() {
        this.tranlate2Str();
        Iterator iterator = this.list.iterator();
        StringBuffer sb = new StringBuffer();
        boolean isFirst = true;
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (next instanceof String) continue;
            TranslateInfo t = (TranslateInfo)next;
            if (this.isSaveToDB(t.source)) {
                if (isFirst) {
                    sb.append(":");
                }
                sb.append(t.source).append("=").append(t.getValue());
            }
            isFirst = false;
        }
        String res = this.expression;
        if (sb.length() != 0) {
            res = res + "  Client_Context:" + sb.toString();
        }
        return res;
    }

    public String[] getMustTranslateStr() {
        if (this.prefix == null) {
            this.prefix = new String[]{"@User", "@Company", "@SysContext"};
        }
        return this.prefix;
    }

    private boolean isSaveToDB(String source) {
        for (int i = 0; i < this.getMustTranslateStr().length; ++i) {
            if (!source.startsWith(this.getMustTranslateStr()[i])) continue;
            return true;
        }
        return false;
    }
}

