/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.ws.util;

import com.kingdee.eas.framework.bireport.bimanager.ws.util.BizMethod;
import com.kingdee.eas.framework.bireport.bimanager.ws.util.BizParamInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class WSDLUtil {
    private static String wsdl_url = "http://localhost/CMHKWebServiceSetup/FoundationService.asmx?wsdl";
    static String[] meshodHierarchy = new String[]{"wsdl:definitions", "wsdl:portType"};
    static String[] paramTypeHierarchy = new String[]{"wsdl:definitions", "wsdl:types", "s:schema", "s:element"};
    static String[] params = new String[]{"s:complexType", "s:sequence", "s:element"};
    static boolean isDebuger = true;
    static String[] methodIsIgnore = new String[]{"GetDatabases", "GetTables", "GetTableColumns", "QueryBySql", "ExecBySql", "QueryByTable"};

    public static String getWSDLByURL(String str) throws Exception {
        URL url = new URL(str);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoOutput(true);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(65536);
        try (InputStream inputStream = connection.getInputStream();){
            int n;
            byte[] buf = new byte[65536];
            while ((n = inputStream.read(buf)) >= 0) {
                baos.write(buf, 0, n);
            }
        }
        return new String(baos.toByteArray(), "UTF-8");
    }

    private static InputStream getInputStreamByURL(String str) throws Exception {
        URL url = new URL(str);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoOutput(true);
        return connection.getInputStream();
    }

    public static List getBizMethoeds(String str) throws ParserConfigurationException, Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputStream inputStream = null;
        try {
            inputStream = WSDLUtil.getInputStreamByURL(str);
            Document doc = builder.parse(inputStream);
            Map operations = WSDLUtil.getWsdlOperation(doc);
            List params = WSDLUtil.getParamType(doc);
            List list = WSDLUtil.getMethodDescription(operations, params);
            return list;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (null != inputStream) {
                inputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getBizMethoedParams(String url, String methodName) throws ParserConfigurationException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        LinkedList list = new LinkedList();
        InputStream inputStream = null;
        try {
            inputStream = WSDLUtil.getInputStreamByURL(url);
            Document doc = builder.parse(inputStream);
            Map operations = WSDLUtil.getWsdlOperation(doc);
            List params = WSDLUtil.getParamType(doc);
            List list2 = WSDLUtil.getMethodDescription(operations, params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != inputStream) {
                inputStream.close();
            }
        }
        return list;
    }

    public static List getMethodDescription(Map map, List params) {
        LinkedList<BizMethod> result = new LinkedList<BizMethod>();
        for (String methodName : map.keySet()) {
            Object next = map.get(methodName);
            if (!(next instanceof Node)) continue;
            Node node = (Node)next;
            Node documentationNode = node.getChildNodes().item(1);
            Node MessageNode = WSDLUtil.getChildNodes(node.getChildNodes(), "wsdl:input");
            BizMethod method = new BizMethod();
            method.decription = documentationNode.getChildNodes().item(0).getNodeValue().replaceAll("\u4e1a\u52a1\u65b9\u6cd5\uff1a", "");
            method.methodName = methodName;
            String str = MessageNode.getAttributes().item(0).getNodeValue();
            BizParamInfo[] param = WSDLUtil.getParams(params, str);
            method.params = param;
            WSDLUtil.dispaly(MessageNode, 1);
            result.add(method);
        }
        return result;
    }

    private static BizParamInfo[] getParams(List params, String str) {
        String methodName = str.substring(4, str.length() - 6);
        for (int i = 0; i < params.size(); ++i) {
            String nodeValue;
            Node node = (Node)params.get(i);
            if (node.getAttributes().getLength() < 1 || !(nodeValue = node.getAttributes().item(0).getNodeValue()).endsWith(methodName)) continue;
            WSDLUtil.dispaly(node, 1);
            return WSDLUtil.getParams(node);
        }
        return null;
    }

    private static BizParamInfo[] getParams(Node node) {
        LinkedList list = new LinkedList();
        WSDLUtil.getNodeLoop(node, 0, params, list);
        Iterator iter = list.iterator();
        LinkedList<BizParamInfo> params = new LinkedList<BizParamInfo>();
        while (iter.hasNext()) {
            String type;
            Node next = (Node)iter.next();
            BizParamInfo param = new BizParamInfo();
            param.maxOccurs = next.getAttributes().item(0).getNodeValue();
            param.minOccurs = next.getAttributes().item(1).getNodeValue();
            param.name = next.getAttributes().item(2).getNodeValue();
            param.type = type = next.getAttributes().item(3).getNodeValue().substring(2);
            params.add(param);
            WSDLUtil.dispaly(next, 0);
        }
        if (params.size() == 0) {
            return null;
        }
        BizParamInfo[] res = new BizParamInfo[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            res[i] = (BizParamInfo)params.get(i);
        }
        return res;
    }

    private static void dispaly(Node node, int ii) {
        if (node.hasChildNodes()) {
            for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                WSDLUtil.dispaly(node.getChildNodes().item(i), ++ii);
            }
        }
    }

    private static Node getChildNodes(NodeList childNodes, String nodeName) {
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node item = childNodes.item(i);
            if (!nodeName.equalsIgnoreCase(item.getNodeName())) continue;
            return item;
        }
        return null;
    }

    public static String getHierarchyString(int index, String[] hierarchy) {
        if (index >= hierarchy.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return hierarchy[index];
    }

    public static Map getWsdlOperation(Document doc) {
        LinkedList list = new LinkedList();
        WSDLUtil.getNodeLoop(doc.getFirstChild(), 1, meshodHierarchy, list);
        HashMap<String, Node> map = new HashMap<String, Node>();
        NodeList nodes = ((Node)list.get(0)).getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            String namedItem;
            Node node = nodes.item(i);
            if (!"wsdl:operation".equalsIgnoreCase(node.getNodeName()) || WSDLUtil.isInMethodIsIgnore(namedItem = node.getAttributes().getNamedItem("name").getNodeValue())) continue;
            map.put(namedItem, node);
        }
        return map;
    }

    public static List getParamType(Document doc) {
        LinkedList list = new LinkedList();
        WSDLUtil.getNodeLoop(doc.getFirstChild(), 1, paramTypeHierarchy, list);
        return list;
    }

    public static boolean isInMethodIsIgnore(String str) {
        for (int i = 0; i < methodIsIgnore.length; ++i) {
            if (!methodIsIgnore[i].endsWith(str)) continue;
            return true;
        }
        return false;
    }

    public static void getNodeLoop(Node node, int index, String[] hierarchy, List ret) {
        NodeList nodes = node.getChildNodes();
        String str = WSDLUtil.getHierarchyString(index, hierarchy);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node item = nodes.item(i);
            if (!str.equalsIgnoreCase(item.getNodeName())) continue;
            if (index == hierarchy.length - 1) {
                ret.add(item);
                continue;
            }
            WSDLUtil.getNodeLoop(item, ++index, hierarchy, ret);
        }
    }

    public static void main(String[] args) {
    }
}

