/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.common.app.cache;

import com.kingdee.util.StringUtils;
import java.io.File;
import org.apache.log4j.Logger;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class ClusterEnvConfig {
    private static Logger logger = Logger.getLogger(ClusterEnvConfig.class);
    private static final String FILE_NAME = "domain.xml";
    private static final String filePath = ClusterEnvConfig.getFilePath();
    private String master_node;
    private String master_rpcport;
    private String bak_master_node;
    private String bak_rpcport;
    private static ClusterEnvConfig clusterCfg = new ClusterEnvConfig();

    private ClusterEnvConfig() {
        this.init();
    }

    public static ClusterEnvConfig getInstantce() {
        return clusterCfg;
    }

    private void init() {
        SAXReader saxReader = new SAXReader();
        try {
            Element memberNode;
            Document document = saxReader.read(new File(filePath));
            Element easNode = (Element)document.selectSingleNode("/domain/clustermanager/eascluster");
            if (easNode != null) {
                Attribute mpAtt;
                Attribute mnAtt = easNode.attribute("master_node");
                if (mnAtt != null) {
                    this.master_node = mnAtt.getText();
                }
                if ((mpAtt = easNode.attribute("rpcport")) != null) {
                    this.master_rpcport = mpAtt.getText();
                }
            }
            if ((memberNode = (Element)easNode.selectSingleNode("/domain/clustermanager/eascluster/masterbak/member")) != null) {
                Attribute bpAtt;
                Attribute bsAtt = memberNode.attribute("serverid");
                if (bsAtt != null) {
                    this.bak_master_node = bsAtt.getText();
                }
                if ((bpAtt = memberNode.attribute("rpcport")) != null) {
                    this.bak_rpcport = bpAtt.getText();
                }
            }
        }
        catch (DocumentException e) {
            logger.error((Object)e);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public String getBakTcpUrl() {
        String tcp = "";
        if (!StringUtils.isEmpty((String)this.bak_master_node) && !StringUtils.isEmpty((String)this.bak_rpcport)) {
            String ip = this.bak_master_node.split(":")[0];
            tcp = "tcp://" + ip + ":" + this.bak_rpcport;
        }
        return tcp;
    }

    public String getHostTcpUrl() {
        String tcp = "";
        if (!StringUtils.isEmpty((String)this.master_node) && !StringUtils.isEmpty((String)this.master_rpcport)) {
            String ip = this.master_node.split(":")[0];
            tcp = "tcp://" + ip + ":" + this.master_rpcport;
        }
        return tcp;
    }

    public boolean isHighAvailableEvn() {
        return !StringUtils.isEmpty((String)this.master_node) && !StringUtils.isEmpty((String)this.master_rpcport) && !StringUtils.isEmpty((String)this.bak_master_node) && !StringUtils.isEmpty((String)this.bak_rpcport);
    }

    public String getMaster_node() {
        return this.master_node;
    }

    public String getMaster_rpcport() {
        return this.master_rpcport;
    }

    public String getBak_master_node() {
        return this.bak_master_node;
    }

    public String getBak_rpcport() {
        return this.bak_rpcport;
    }

    private static String getFilePath() {
        String filePath = System.getProperty("EAS_HOME");
        if (!StringUtils.isEmpty((String)filePath)) {
            File file = new File(filePath);
            filePath = file.getAbsolutePath() + "/admin/config/" + FILE_NAME;
        } else {
            filePath = "W:/eas/Server/admin/config/domain.xml";
        }
        return filePath;
    }

    public static void main(String[] args) {
        ClusterEnvConfig.getInstantce();
    }
}

