/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.common.app.dao;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.BizOccrFilterSet;
import com.kingdee.eas.common.EASDBException;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Vector;

public class RefCheckersDAO {
    protected static Connection getConnection(Context ctx) throws SQLException {
        return EJBFactory.getConnection((Context)ctx);
    }

    public static String[] getCheckers(Context ctx, String bosType, Class inf) throws EASDBException {
        Vector<String> vec = new Vector<String>();
        Object[] checkers = null;
        String sql = "select FChecker from T_SYS_Checkers where FBosType= ? and FInterface= ?";
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement stat = null;
        try {
            conn = RefCheckersDAO.getConnection(ctx);
            stat = conn.prepareStatement(sql);
            stat.setString(1, bosType);
            stat.setString(2, inf.getName());
            rs = stat.executeQuery();
            while (rs.next()) {
                vec.addElement(rs.getString(1));
                checkers = new String[vec.size()];
                vec.copyInto(checkers);
            }
        }
        catch (SQLException e2) {
            try {
                throw new EASDBException(EASDBException.EXEC_SQL_ERROR, e2);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stat, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stat, (Connection)conn);
        return checkers;
    }

    public static String[] getCheckers(Context ctx, String bosType, Class inf, BizOccrFilterSet set) throws EASDBException {
        String[] chkrs = null;
        String sql = new StringBuffer().append("select FChecker from T_SYS_Checkers where FBosType = ? and FInterface= ? ").append(set.getSQL()).toString();
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement stat = null;
        try {
            conn = RefCheckersDAO.getConnection(ctx);
            stat = conn.prepareStatement(sql);
            stat.setString(1, bosType);
            stat.setString(2, inf.getName());
            rs = stat.executeQuery();
            ArrayList<String> al = new ArrayList<String>();
            while (rs.next()) {
                al.add(rs.getString(1));
            }
            chkrs = new String[al.size()];
            int n = chkrs.length;
            for (int i = 0; i < n; ++i) {
                chkrs[i] = (String)al.get(i);
            }
        }
        catch (SQLException e2) {
            try {
                throw new EASDBException(EASDBException.EXEC_SQL_ERROR, e2);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stat, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stat, (Connection)conn);
        return chkrs;
    }
}

