/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.common.app.dao;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.app.dao.EntryHeadInfo;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class ReferenceCheckSqlBuilder {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.common.app.dao.ReferenceCheckSqlBuilder");
    private static HashSet cuTableSet = null;
    private static boolean isCheckCUTable = false;
    private static HashMap entryHeadTableMap = null;
    private static boolean isCheckEntryHeadTable = false;

    private static Connection getConnection(Context ctx) throws SQLException {
        return EJBFactory.getConnection((Context)ctx);
    }

    public static void clear() {
        isCheckCUTable = false;
        isCheckEntryHeadTable = false;
    }

    private static void init(Context ctx) {
        ReferenceCheckSqlBuilder.initHasCUTableMap(ctx);
        ReferenceCheckSqlBuilder.initEntryHeadTableMap(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initEntryHeadTableMap(Context ctx) {
        if (isCheckEntryHeadTable) {
            return;
        }
        entryHeadTableMap = new HashMap();
        String sql = "select FENTRYTABLENAME,FHEADTABLENAME,FRELATIONFIELDNAME FROM T_SYS_ENTRYHEAD";
        Connection conn = null;
        Statement stat = null;
        ResultSet rs = null;
        try {
            conn = ReferenceCheckSqlBuilder.getConnection(ctx);
            stat = conn.createStatement();
            rs = stat.executeQuery(sql);
            while (rs.next()) {
                String entryName = rs.getString("FENTRYTABLENAME");
                String headName = rs.getString("FHEADTABLENAME");
                String relationName = rs.getString("FRELATIONFIELDNAME");
                if (entryName == null) continue;
                EntryHeadInfo info = new EntryHeadInfo();
                info.setEntryTableName(entryName);
                info.setHeadTableName(headName);
                info.setRelationFieldName(relationName);
                entryHeadTableMap.put(entryName.toLowerCase(), info);
            }
        }
        catch (SQLException e1) {
            try {
                logger.error((Object)("get has cu field table error:" + e1));
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stat, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stat, (Connection)conn);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stat, (Connection)conn);
        isCheckEntryHeadTable = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initHasCUTableMap(Context ctx) {
        if (isCheckCUTable) {
            return;
        }
        cuTableSet = new HashSet();
        String sql = " SELECT KSQL_COL_TABNAME from KSQL_USERCOLUMNS  where  KSQL_COL_NAME='FControlUnitID'";
        Connection conn = null;
        Statement stat = null;
        ResultSet rs = null;
        try {
            conn = ReferenceCheckSqlBuilder.getConnection(ctx);
            stat = conn.createStatement();
            rs = stat.executeQuery(sql);
            while (rs.next()) {
                String tableName = rs.getString("KSQL_COL_TABNAME");
                if (tableName == null) continue;
                cuTableSet.add(tableName.toLowerCase());
            }
        }
        catch (SQLException e1) {
            try {
                logger.error((Object)("get has cu field table error:" + e1));
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stat, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stat, (Connection)conn);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stat, (Connection)conn);
        isCheckCUTable = true;
    }

    public static EntryHeadInfo getEntryParentTable(String entryTableName) {
        return (EntryHeadInfo)entryHeadTableMap.get(entryTableName.toLowerCase());
    }

    public static boolean isNeedCUCheck(String sql4CU) {
        return sql4CU != null && !sql4CU.equals("");
    }

    public static boolean hasCUField(String tableName) {
        return tableName == null ? false : cuTableSet.contains(tableName.toLowerCase());
    }

    public static String getCheckSqlWithCU(Context ctx, String tableName, String fieldName, String sql4CU, String objID) {
        ReferenceCheckSqlBuilder.init(ctx);
        StringBuffer sb1 = new StringBuffer();
        sb1.append(" select ").append(fieldName).append(" from ").append(tableName).append(" where ").append(fieldName).append("='").append(objID).append("'");
        if (ReferenceCheckSqlBuilder.isNeedCUCheck(sql4CU)) {
            if (!ReferenceCheckSqlBuilder.hasCUField(tableName)) {
                EntryHeadInfo headInfo = ReferenceCheckSqlBuilder.getEntryParentTable(tableName);
                if (headInfo == null) {
                    return sb1.append(" and 1=2 ").toString();
                }
                StringBuffer sb = new StringBuffer();
                String hasScheme = sql4CU;
                if (sql4CU.indexOf("FControlUnitID") != -1) {
                    hasScheme = sql4CU.replaceFirst("FControlUnitID", headInfo.getHeadTableName() + ".FControlUnitID");
                }
                sb.append(" select ").append(tableName).append(".").append(fieldName).append(" as ").append(fieldName).append(" from ").append(tableName).append(" inner join ").append(headInfo.getHeadTableName()).append(" on ").append(tableName).append(".").append(headInfo.getRelationFieldName()).append(" = ").append(headInfo.getHeadTableName()).append(".FID").append(" ").append(" where ").append(tableName).append(".").append(fieldName).append("='").append(objID).append("' ").append(hasScheme);
                return sb.toString();
            }
            sb1.append(sql4CU);
            return sb1.toString();
        }
        return sb1.toString();
    }

    public static String getCheckSqlWithInCU(Context ctx, String tableName, String fieldName, String sql4CU, String idParamInfoStr, boolean selectAll) {
        ReferenceCheckSqlBuilder.init(ctx);
        StringBuffer sb1 = new StringBuffer();
        String selectField = fieldName + "," + tableName + ".fid";
        if (selectAll) {
            // empty if block
        }
        String sql = " select " + selectField + " from " + tableName + " where " + fieldName + " in (" + idParamInfoStr + ")";
        sb1.append(sql);
        if (ReferenceCheckSqlBuilder.isNeedCUCheck(sql4CU)) {
            if (!ReferenceCheckSqlBuilder.hasCUField(tableName)) {
                EntryHeadInfo headInfo = ReferenceCheckSqlBuilder.getEntryParentTable(tableName);
                if (headInfo == null) {
                    return sb1.append(" and 1=2 ").toString();
                }
                String hasScheme = sql4CU;
                if (sql4CU.indexOf("FControlUnitID") != -1) {
                    hasScheme = sql4CU.replaceFirst("FControlUnitID", headInfo.getHeadTableName() + ".FControlUnitID");
                }
                StringBuffer sb = new StringBuffer();
                sb.append(" select ").append(tableName).append(".").append(selectField).append(" from ").append(tableName).append(" inner join ").append(headInfo.getHeadTableName()).append(" on ").append(tableName).append(".").append(headInfo.getRelationFieldName()).append(" = ").append(headInfo.getHeadTableName()).append(".FID").append(" ").append(" where ").append(tableName).append(".").append(fieldName).append(" in (").append(idParamInfoStr).append(") ").append(hasScheme);
                return sb.toString();
            }
            sb1.append(sql4CU);
            return sb1.toString();
        }
        return sb1.toString();
    }
}

