/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.util;

import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import org.apache.log4j.Logger;

class TableEntityMapping {
    private Hashtable mapping = new Hashtable();
    private static Logger logger = Logger.getLogger(TableEntityMapping.class);

    public void addMapping(String tableName, BOSObjectType type) {
        assert (!StringUtils.isEmpty((String)tableName));
        assert (type != null);
        this.mapping.put(tableName, new TableInfo(type));
    }

    public Enumeration getTableNames() {
        return this.mapping.keys();
    }

    private TableInfo getMappingInfo(String tableName) {
        return (TableInfo)this.mapping.get(tableName);
    }

    public BOSObjectType getMappingType(String tableName) {
        TableInfo tableInfo = this.getMappingInfo(tableName);
        if (tableInfo != null) {
            return tableInfo.type;
        }
        return null;
    }

    public void addExcludedTable(String tableName, String refTableName) {
        TableInfo tableInfo = this.getMappingInfo(tableName);
        if (tableInfo != null && refTableName != null) {
            tableInfo.addExcludedTable(refTableName);
        } else {
            logger.info((Object)("bulid tableInfo error " + tableName + " refTableName:" + refTableName));
        }
    }

    public boolean isExcluded(String tableName, String refTableName) {
        return this.getMappingInfo(tableName).isExcluded(refTableName);
    }

    private static class TableInfo {
        private final BOSObjectType type;
        private HashSet excludedRefTables;

        public TableInfo(BOSObjectType type) {
            this.type = type;
            this.excludedRefTables = new HashSet();
        }

        public void addExcludedTable(String refTableName) {
            this.excludedRefTables.add(refTableName);
        }

        public boolean isExcluded(String refTableName) {
            return this.excludedRefTables.contains(refTableName);
        }
    }
}

