/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.util.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.data.ColumnCollection;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.CnToSpell;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class PinYinHelper {
    protected static Logger logger = Logger.getLogger(PinYinHelper.class);

    public static boolean generatePinYin(Context ctx, String entityName, String[] ids) throws BOSException, EASBizException {
        Set<String[]> pinYinProsSet = PinYinHelper.getPinYinProsSet(ctx, entityName);
        DataTableInfo tableInfo = PinYinHelper.getTableInfo(ctx, entityName);
        String tableName = tableInfo.getName();
        for (String[] pros : pinYinProsSet) {
            PinYinHelper.generatePinYin(ctx, tableName, pros[0], pros[1], pros[2], ids);
        }
        return true;
    }

    public static boolean generatePinYin(Context ctx, BOSObjectType bosType, String[] ids) throws BOSException, EASBizException {
        IMetaDataLoader mdLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = mdLoader.loadMetameta(bosType);
        String fullName = entity.getFullName();
        return PinYinHelper.generatePinYin(ctx, fullName, ids);
    }

    public static Set<String[]> getPinYinProsSet(Context ctx, String fullEntityName) {
        HashSet<String[]> pinYinProsSet = new HashSet<String[]>();
        String shortPinYin = "ShortPinYin";
        String pinYin = "PinYin";
        DataTableInfo tableInfo = PinYinHelper.getTableInfo(ctx, fullEntityName);
        ColumnCollection cols = tableInfo.getColumns();
        int size = cols.size();
        for (int i = 0; i < size; ++i) {
            ColumnInfo colInfo = cols.get(i);
            String colName = colInfo.getName();
            if (!colName.endsWith(shortPinYin)) continue;
            String[] pros = new String[3];
            String sourceFieldName = colName.substring(0, colName.indexOf(shortPinYin));
            String shortPinYinFieldName = colName;
            String pinYinFieldName = sourceFieldName + pinYin;
            ColumnInfo sourceCol = tableInfo.getColumnByName(sourceFieldName);
            if (sourceCol.isMultilingual()) {
                sourceFieldName = sourceFieldName + "_l2";
            }
            pros[0] = sourceFieldName;
            pros[1] = pinYinFieldName;
            pros[2] = shortPinYinFieldName;
            pinYinProsSet.add(pros);
        }
        return pinYinProsSet;
    }

    public static boolean initPinYin(Context ctx, String entityName) throws BOSException, EASBizException {
        return PinYinHelper.generatePinYin(ctx, entityName, null);
    }

    public static DataTableInfo getTableInfo(Context ctx, String fullEntityName) {
        IMetaDataLoader mdLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = (EntityObjectInfo)mdLoader.get(MetaDataTypeList.ENTITY, (IMetaDataPK)MetaDataPK.create((String)fullEntityName));
        return entity.getTable();
    }

    public static void generatePinYin(Context ctx, String table, String field, String pinYinField, String shortPinYinField) throws BOSException, EASBizException {
        PinYinHelper.generatePinYin(ctx, table, field, pinYinField, shortPinYinField, null);
    }

    public static void generatePinYin(Context ctx, String table, String field, String pinYinField, String shortPinYinField, String[] ids) throws BOSException, EASBizException {
        try {
            String sql = "select " + field + ",FId from  " + table;
            String idsFilterStr = "";
            if (ids != null && ids.length > 0) {
                idsFilterStr = " where fid in (" + ToolUtils.aryToStr((String[])ids) + ")";
            }
            sql = sql + idsFilterStr;
            IRowSet rs = DbUtil.executeQuery(ctx, sql);
            String updateSql = "update " + table + " set " + pinYinField + " = ? ," + shortPinYinField + "=? where fid = ?";
            String pinYin = "";
            String shortPinYin = "";
            String fieldValue = "";
            String id = "";
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            while (rs.next()) {
                id = rs.getString("FId");
                fieldValue = rs.getString(field);
                pinYin = CnToSpell.getSpell(fieldValue, false);
                shortPinYin = CnToSpell.getSpell(fieldValue, true);
                Object[] params = new Object[]{pinYin, shortPinYin, id};
                paramsList.add(params);
            }
            DbUtil.executeBatch(ctx, updateSql, paramsList);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }
}

