/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.agent.service.base.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.csinterface.agent.service.base.util.DataBaseType;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.DBUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class SQLUtil {
    private static Logger logger = Logger.getLogger(SQLUtil.class);

    public static void cleanup(ResultSet rs, Statement stmt, Connection cn) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception _) {
                logger.error((Object)"cleanup error", (Throwable)_);
            }
            rs = null;
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception _) {
                logger.error((Object)"cleanup error", (Throwable)_);
            }
            stmt = null;
        }
        if (cn != null) {
            try {
                cn.close();
            }
            catch (Exception _) {
                logger.error((Object)"cleanup error", (Throwable)_);
            }
            cn = null;
        }
    }

    public static final void cleanup(Connection cn) {
        SQLUtil.cleanup(null, null, cn);
    }

    public static final void cleanup(Statement stmt) {
        SQLUtil.cleanup(null, stmt, null);
    }

    public static final void cleanup(Statement stmt, Connection cn) {
        SQLUtil.cleanup(null, stmt, cn);
    }

    public static final void cleanup(ResultSet rs) {
        SQLUtil.cleanup(rs, null, null);
    }

    public static final void cleanup(ResultSet rs, Statement stmt) {
        SQLUtil.cleanup(rs, stmt, null);
    }

    public static final RowSet makeRowSet(ResultSet rs) throws SQLException {
        JdbcRowSet jrs = new JdbcRowSet();
        if (rs.getMetaData().getColumnCount() > 0) {
            jrs.populate(rs);
        }
        return jrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRowSet executeQuery(Connection con, String ksql) throws SQLException {
        Statement statement = null;
        try {
            IRowSet rsReturn;
            statement = con.createStatement();
            logger.debug((Object)("executeQuery ksql :" + ksql));
            ResultSet rs = statement.executeQuery(ksql);
            IRowSet iRowSet = rsReturn = (IRowSet)SQLUtil.makeRowSet(rs);
            return iRowSet;
        }
        finally {
            SQLUtil.cleanup(statement);
        }
    }

    public static String getTableName(String tabName) {
        if (StringUtils.isEmpty((String)tabName)) {
            throw new NullPointerException("tableName is empty !");
        }
        if (tabName.charAt(0) != '\"') {
            tabName = tabName.toUpperCase();
        }
        return tabName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRowSet executeQuery(DataBaseType dbType, String ip, int port, String dbName, String userName, String pwd, String ksql) throws SQLException {
        IRowSet iRowSet;
        Statement statement = null;
        Connection con = null;
        try {
            con = SQLUtil.getKSQLConnection(dbType, ip, port, dbName, userName, pwd);
            iRowSet = SQLUtil.executeQuery(con, ksql);
        }
        catch (Throwable throwable) {
            SQLUtil.cleanup(statement);
            SQLUtil.cleanup(con);
            throw throwable;
        }
        SQLUtil.cleanup(statement);
        SQLUtil.cleanup(con);
        return iRowSet;
    }

    public static void executeUpdate(Connection con, String ksql) throws SQLException {
        SQLUtil.executeUpdate(con, new String[]{ksql});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeUpdate(Connection con, String[] ksqls) throws SQLException {
        Statement statement = null;
        try {
            statement = con.createStatement();
            for (String ksql : ksqls) {
                if (StringUtils.isEmpty((String)ksql)) continue;
                statement.executeUpdate(ksql);
            }
        }
        finally {
            SQLUtil.cleanup(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeUpdate(DataBaseType dbType, String ip, int port, String dbName, String userName, String pwd, String[] ksqls) throws SQLException {
        Statement statement = null;
        Connection con = null;
        try {
            con = SQLUtil.getKSQLConnection(dbType, ip, port, dbName, userName, pwd);
            SQLUtil.executeUpdate(con, ksqls);
        }
        catch (Throwable throwable) {
            SQLUtil.cleanup(statement);
            SQLUtil.cleanup(con);
            throw throwable;
        }
        SQLUtil.cleanup(statement);
        SQLUtil.cleanup(con);
    }

    public static Connection getKSQLConnection(Context ctx) throws SQLException, SQLDataException {
        Connection conn = DBUtils.getConnection(ctx);
        return conn;
    }

    public static boolean isTableExists(Connection cn, String tableName) throws SQLException {
        boolean sql2;
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try {
            if (!StringUtils.isEmpty((String)tableName)) {
                String sql2 = "SELECT 1 FROM KSQL_USERTABLES WHERE EXISTS (SELECT 1  FROM KSQL_USERTABLES WHERE KSQL_TABNAME = ?)";
                stmt = cn.prepareStatement(sql2);
                stmt.setString(1, tableName.replace("\"", ""));
                rs = stmt.executeQuery();
            }
            sql2 = rs == null ? false : rs.next();
        }
        catch (SQLException sqle) {
            try {
                throw sqle;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return sql2;
    }

    public static String getDefinedDataType(String name, int length, int precision, int scale) {
        if ("CHAR".equalsIgnoreCase(name) || "VARCHAR".equalsIgnoreCase(name) || "NCHAR".equalsIgnoreCase(name) || "NVARCHAR".equalsIgnoreCase(name) || "CLOB".equalsIgnoreCase(name) || "BLOB".equalsIgnoreCase(name) || "NCLOB".equalsIgnoreCase(name) || "BINARY".equalsIgnoreCase(name) || "VARBINARY".equalsIgnoreCase(name)) {
            return name + "(" + length + ")";
        }
        if ("NUMERIC".equalsIgnoreCase(name)) {
            if (precision == 0) {
                precision = length - 1;
            }
            return "DECIMAL(" + precision + "," + scale + ")";
        }
        if ("INT".equalsIgnoreCase(name) || "DATETIME".equalsIgnoreCase(name)) {
            return name;
        }
        throw new RuntimeException("unsupported datatype: " + name);
    }

    public static Connection getKSQLConnection(DataBaseType dbType, String ip, int port, String dbName, String userName, String pwd) throws SQLException {
        try {
            Class.forName("com.kingdee.bos.sql.shell.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        String url = SQLUtil.getConnectionURL(dbType, ip, port, dbName);
        Properties properties = new Properties();
        properties.put("user", userName);
        properties.put("password", pwd);
        Connection conn = DriverManager.getConnection(url, properties);
        DriverManager.setLoginTimeout(300);
        return conn;
    }

    private static String getConnectionURL(DataBaseType dbType, String ip, int port, String dbName) {
        if (DataBaseType.SQLServer.equals((Object)dbType)) {
            return SQLUtil.getMSSQL(ip, port, dbName);
        }
        if (DataBaseType.Oracle.equals((Object)dbType)) {
            return SQLUtil.getOracle(ip, port, dbName);
        }
        if (DataBaseType.DB2.equals((Object)dbType)) {
            return SQLUtil.getDB2(ip, port, dbName);
        }
        return "Unsupport database type '" + (Object)((Object)dbType) + "'";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean existsColumn(Connection conn, String table, String column) throws SQLException {
        block8: {
            table = table.replaceAll("\"", "");
            resultSet = null;
            statement = null;
            try {
                sql = "SELECT KSQL_COL_NAME FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME=?";
                statement = conn.prepareStatement(sql);
                if (!StringUtils.isEmpty((String)table) && !StringUtils.isEmpty((String)column)) {
                    statement.setString(1, table);
                    resultSet = statement.executeQuery();
                }
                if (null != resultSet) {
                    while (resultSet.next()) {
                        if (!column.equalsIgnoreCase(resultSet.getString(1))) continue;
                        var6_7 = true;
                        break block8;
                    }
                }
                ** GOTO lbl-1000
            }
            catch (SQLException sqle) {
                try {
                    throw sqle;
                }
                catch (Throwable var7_9) {
                    SQLUtil.cleanup(resultSet, statement);
                    throw var7_9;
                }
            }
        }
        SQLUtil.cleanup(resultSet, statement);
        return var6_7;
lbl-1000:
        // 1 sources

        {
            var6_8 = false;
        }
        SQLUtil.cleanup(resultSet, statement);
        return var6_8;
    }

    private static String getMSSQL(String ip, int port, String dbName) {
        StringBuffer sb = new StringBuffer("jdbc:ksql:net.sourceforge.jtds.jdbc.Driver:dbtype=mssqlserver:jdbc:jtds:sqlserver");
        sb.append("://" + ip);
        sb.append(":" + port);
        sb.append(";DatabaseName=" + dbName);
        return sb.toString();
    }

    private static String getOracle(String ip, int port, String SID) {
        StringBuffer sb = new StringBuffer("jdbc:ksql:oracle.jdbc.driver.OracleDriver:dbtype=oracle9:trace=on:file=console:jdbc:oracle:thin");
        sb.append(":@" + ip);
        sb.append(":" + port);
        sb.append(":" + SID);
        return sb.toString();
    }

    private static String getDB2(String ip, int port, String dbName) {
        StringBuffer sb = new StringBuffer("jdbc:ksql:com.ibm.db2.jcc.DB2Driver:dbtype=db2:DBSchema=DB2ADMIN:jdbc:db2");
        sb.append("://" + ip);
        sb.append(":" + port);
        sb.append("/" + dbName);
        return sb.toString();
    }
}

