/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.agent.service.work.basedata.process;

import com.kingdee.eas.csinterface.agent.service.work.basedata.DataColumn;
import com.kingdee.eas.csinterface.agent.service.work.basedata.model.DataRow;
import com.kingdee.eas.csinterface.agent.service.work.basedata.model.DataTable;
import com.kingdee.eas.csinterface.agent.service.work.basedata.model.StructuredDataModel;
import com.kingdee.eas.csinterface.agent.service.work.basedata.model.StructuredTableData;
import com.kingdee.eas.csinterface.agent.service.work.basedata.process.IFlatStructuredTransform;
import com.kingdee.eas.csinterface.agent.service.work.basedata.provider.FlatData;
import java.util.Arrays;
import java.util.List;

public class FlatStructuredTransform
implements IFlatStructuredTransform {
    @Override
    public StructuredTableData transform(StructuredDataModel dataModel, FlatData flatData) throws Exception {
        if (dataModel == null) {
            throw new NullPointerException("dataModel is null!");
        }
        if (flatData == null) {
            throw new NullPointerException("flatData is null!");
        }
        DataTable[] dataTables = new DataTable[dataModel.getPriorityTables().length];
        for (int i = 0; i < dataTables.length; ++i) {
            dataTables[i] = new DataTable();
        }
        List dataRows = flatData.getDataRows();
        if (dataRows != null && dataRows.size() > 0) {
            DataColumn[] columnDefines = flatData.getColumnsDefine();
            int[] fColumnMapTables = this.prepareRelation(dataModel, flatData);
            for (int i = 0; i < dataRows.size(); ++i) {
                FlatData.FlatDataRow row = (FlatData.FlatDataRow)dataRows.get(i);
                this.processModelData(row, columnDefines, fColumnMapTables, dataModel, dataTables);
            }
        }
        StructuredTableData structuredTableData = new StructuredTableData(dataModel, dataTables);
        return structuredTableData;
    }

    private int[] prepareRelation(StructuredDataModel dataModel, FlatData flatData) throws Exception {
        DataColumn[] definedColumns = flatData.getColumnsDefine();
        StructuredDataModel.TableModel[] tableModels = dataModel.getPriorityTables();
        int[] fColumnMapTables = new int[definedColumns.length];
        Arrays.fill(fColumnMapTables, -1);
        for (int i = 0; i < definedColumns.length; ++i) {
            for (int j = 0; j < tableModels.length; ++j) {
                for (int k = 0; k < tableModels[j].columns.length; ++k) {
                    if (!definedColumns[i].equals(tableModels[j].columns[k])) continue;
                    fColumnMapTables[i] = j;
                    break;
                }
                if (fColumnMapTables[i] != -1) continue;
            }
            if (fColumnMapTables[i] != -1) continue;
            throw new Exception("\u6570\u636e\u6e90\u4e0e\u6570\u636e\u6a21\u578b\u6620\u5c04\u5173\u7cfb\u51fa\u9519: \u6570\u636e\u6e90\u7684\u5217'" + definedColumns[i].name + "'\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6570\u636e\u6a21\u578b\u8868");
        }
        return fColumnMapTables;
    }

    private void processModelData(FlatData.FlatDataRow row, DataColumn[] columnDefines, int[] fColumnMapTables, StructuredDataModel dataModel, DataTable[] dataTables) throws Exception {
        StructuredDataModel.TableModel[] modelTables = dataModel.getPriorityTables();
        int tableIndex = -1;
        DataRow[] tableDataRows = new DataRow[modelTables.length];
        for (int i = 0; i < fColumnMapTables.length; ++i) {
            Object value;
            tableIndex = fColumnMapTables[i];
            if (tableDataRows[tableIndex] == null) {
                tableDataRows[tableIndex] = new DataRow(modelTables[tableIndex]);
            }
            if ((value = row.get(i)) == null && tableDataRows[tableIndex].pkColumn.equals(columnDefines[i].name)) {
                throw new Exception("\u4e3b\u952e\u5217'" + columnDefines[i].name + "'\u7684\u503c\u4e3anull!");
            }
            tableDataRows[tableIndex].setValue(columnDefines[i].name, value);
        }
        DataRow[] realTableDataRows = new DataRow[modelTables.length];
        for (int i = 0; i < tableDataRows.length; ++i) {
            DataRow realDataRow = tableDataRows[i];
            if (i != 0) {
                dataTables[i].addRowNoCheck(tableDataRows[i]);
            }
            realTableDataRows[i] = realDataRow;
        }
    }
}

