/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.agent.service.work.basedata.provider;

import com.kingdee.eas.csinterface.agent.service.work.basedata.DataColumn;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class FlatData
implements Serializable {
    private static final long serialVersionUID = 1422571929892394225L;
    private DataColumn[] columns;
    private Map columnIndexMap = new HashMap();
    private List dataRows;

    private FlatData() {
    }

    public FlatData(DataColumn[] columns) throws Exception {
        this.columns = columns;
        HashSet<DataColumn> exist = new HashSet<DataColumn>();
        for (int i = 0; i < columns.length; ++i) {
            DataColumn column = columns[i];
            if (exist.contains(column)) {
                throw new Exception("\u5217\u5b9a\u4e49\u5b58\u5728\u91cd\u590d\u7684\u5217\u540d: name=" + column.name + ",alias=" + column.alias);
            }
            this.columnIndexMap.put(column.name, new Integer(i));
            exist.add(column);
        }
        this.dataRows = new ArrayList();
    }

    public FlatDataRow createFlatDataRow() {
        return new FlatDataRow(this);
    }

    public void addDataRow(FlatDataRow dataRow) {
        this.dataRows.add(dataRow);
    }

    public FlatDataRow getDataRow(int index) {
        return (FlatDataRow)this.dataRows.get(index);
    }

    public List getDataRows() {
        return this.dataRows;
    }

    public DataColumn[] getColumnsDefine() {
        return this.columns;
    }

    public static class FlatDataRow {
        private FlatData parent;
        private Object[] values;

        FlatDataRow(FlatData parent) {
            this.parent = parent;
            this.values = new Object[parent.columns.length];
        }

        public void set(int index, Object value) {
            this.values[index] = value;
        }

        public Object get(int index) {
            return this.values[index];
        }

        public void set(String name, Object value) {
            this.set((Integer)this.parent.columnIndexMap.get(name), value);
        }

        public Object get(String name) {
            return this.get((Integer)this.parent.columnIndexMap.get(name));
        }
    }
}

