/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.agent.service.work.basedata.thread;

import com.kingdee.util.marshal.IMarshalObject;
import com.kingdee.util.marshal.Marshaller;
import com.kingdee.util.marshal.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class DiskQueueBucket<E extends IMarshalObject> {
    private int size;
    private File queueDataFile;
    private final long maxPosition;
    private RandomAccessFile queueRaf;
    private FileChannel queueChannel;
    private long readPosition;
    private long writePosition;
    private boolean readyToWrite;
    private boolean readyToRead;

    public DiskQueueBucket(File queueDataDir, String fileName, long maxFileSize) {
        if (!queueDataDir.exists()) {
            queueDataDir.mkdirs();
        }
        this.queueDataFile = new File(queueDataDir, fileName);
        if (this.queueDataFile.exists()) {
            this.queueDataFile.delete();
        }
        try {
            this.queueDataFile.createNewFile();
            this.queueRaf = new RandomAccessFile(this.queueDataFile, "rw");
            this.queueChannel = this.queueRaf.getChannel();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.maxPosition = maxFileSize;
        this.setReadyToWrite();
    }

    public synchronized void setReadyToRead() {
        this.readyToRead = true;
        this.readyToWrite = false;
    }

    private void setReadyToWrite() {
        this.readyToWrite = true;
        this.readyToRead = false;
    }

    public synchronized boolean isReadyToRead() {
        return this.readyToRead;
    }

    public synchronized boolean isReadyToWrite() {
        return this.readyToWrite;
    }

    private boolean enoughWriteSpace(long needSpace) {
        long leftSpace = this.maxPosition - this.writePosition;
        return leftSpace > needSpace;
    }

    public synchronized boolean add(E e) {
        if (!this.readyToWrite) {
            throw new IllegalStateException("QueueBucket read error : bucket is not ready to write.");
        }
        try {
            ByteArrayOutputStream elementStream = new ByteArrayOutputStream();
            ObjectOutputStream objectStream = new ObjectOutputStream(elementStream);
            Marshaller marshaller = new Marshaller((ObjectOutput)objectStream);
            marshaller.writeObject(e);
            marshaller.flush();
            byte[] elementBytes = elementStream.toByteArray();
            int toWriteLen = 4 + elementBytes.length;
            if (!this.enoughWriteSpace(toWriteLen)) {
                this.setReadyToRead();
                return false;
            }
            this.queueChannel.position(this.writePosition);
            ByteBuffer buffer = ByteBuffer.allocate(toWriteLen);
            buffer.putInt(elementBytes.length);
            buffer.put(elementBytes);
            buffer.flip();
            this.queueChannel.write(buffer);
            ++this.size;
            this.writePosition += (long)toWriteLen;
            return true;
        }
        catch (IOException ioe) {
            throw new IllegalStateException("QueueBucket write error : \ncause by:\n" + ioe.getClass().getName() + (ioe.getMessage() == null ? "" : ":" + ioe.getMessage()));
        }
    }

    public synchronized E poll() {
        if (this.size <= 0) {
            return null;
        }
        if (!this.readyToRead) {
            throw new IllegalStateException("QueueBucket read error : bucket is not ready to read.");
        }
        ByteBuffer lengthBuffer = ByteBuffer.allocate(4);
        long currentReadPosition = this.readPosition;
        try {
            this.queueChannel.position(currentReadPosition);
            if (this.queueChannel.read(lengthBuffer) != 4) {
                throw new IllegalStateException("fileChannal read error : item length does not match!");
            }
            lengthBuffer.flip();
            int elementLength = lengthBuffer.getInt();
            ByteBuffer elementBuffer = ByteBuffer.allocate(elementLength);
            currentReadPosition += 4L;
            if (this.queueChannel.read(elementBuffer) != elementLength) {
                throw new IllegalStateException("fileChannal read error : item content length does not match the given length!");
            }
            ByteArrayInputStream elementStream = new ByteArrayInputStream(elementBuffer.array());
            ObjectInputStream objectStream = new ObjectInputStream(elementStream);
            Unmarshaller unmarshaller = new Unmarshaller((ObjectInput)objectStream);
            this.readPosition = currentReadPosition += (long)elementLength;
            --this.size;
            if (this.size <= 0) {
                this.reset();
            }
            try {
                return (E)((IMarshalObject)unmarshaller.readObject());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e.getMessage());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalStateException("fileChannal read error : " + e.getMessage());
        }
    }

    private void reset() {
        this.writePosition = 0L;
        this.readPosition = 0L;
        this.size = 0;
        this.setReadyToWrite();
    }

    public synchronized int size() {
        return this.size;
    }

    public void flush() {
        try {
            this.queueChannel.force(true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        try {
            this.queueChannel.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            this.queueRaf.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.queueDataFile.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

