/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.agent.servlet;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.csinterface.agent.EipUserFactory;
import com.kingdee.eas.csinterface.agent.EipUserInfo;
import com.kingdee.eas.csinterface.agent.IEipUser;
import com.kingdee.eas.csinterface.agent.base.Encoding;
import com.kingdee.eas.csinterface.agent.base.ResultInfo;
import com.kingdee.eas.csinterface.agent.service.work.basedata.BillDataStatus;
import com.kingdee.eas.csinterface.agent.service.work.basedata.provider.db.BufferedBillDataProvider;
import com.kingdee.eas.csinterface.agent.servlet.PacketsEncoder;
import com.kingdee.eas.csinterface.agent.servlet.RequestProcessor;
import com.kingdee.eas.csinterface.agent.servlet.processor.AgentUpdateServlet;
import com.kingdee.eas.csinterface.agent.servlet.processor.BaseDataServlet;
import com.kingdee.eas.csinterface.agent.servlet.processor.BaseDataSynServlet;
import com.kingdee.eas.csinterface.agent.servlet.processor.ClearDefineCacheServlet;
import com.kingdee.eas.csinterface.agent.servlet.processor.GetAttachmentServlet;
import com.kingdee.eas.csinterface.agent.servlet.processor.GetDataCenterListServlet;
import com.kingdee.eas.csinterface.agent.servlet.processor.LoginServlet;
import com.kingdee.eas.csinterface.agent.servlet.processor.MidBillDataServlet;
import com.kingdee.eas.csinterface.agent.servlet.processor.OpenAPILoginServlet;
import com.kingdee.eas.csinterface.agent.servlet.processor.WebAPIBaseDataServlet;
import com.kingdee.eas.csinterface.agent.servlet.processor.WebAPILoginServlet;
import com.kingdee.eas.csinterface.agent.servlet.processor.WebAPIMetadataServlet;
import com.kingdee.eas.csinterface.agent.servlet.processor.WebAPIServlet;
import com.kingdee.eas.csinterface.agent.servlet.processor.WebCustomerOpenAPIServlet;
import com.kingdee.eas.csinterface.agent.servlet.processor.WebOpenAPIServlet;
import com.kingdee.eas.csinterface.agent.util.WebUtil;
import com.kingdee.eas.csinterface.app.base.EIPLicenseCheckUtil;
import com.kingdee.eas.csinterface.base.cache.SessionUtil;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTableInfo;
import com.kingdee.eas.csinterface.basedatasyn.ITableStructure;
import com.kingdee.eas.csinterface.basedatasyn.TableStructureCollection;
import com.kingdee.eas.csinterface.basedatasyn.TableStructureFactory;
import com.kingdee.eas.csinterface.basedatasyn.TableStructureInfo;
import com.kingdee.eas.csinterface.json.JSONException;
import com.kingdee.eas.csinterface.json.JSONObject;
import com.kingdee.eas.csinterface.util.ClassUtil;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class EIPDispatcherServlet
extends HttpServlet {
    private static final long serialVersionUID = 6381989403168321041L;
    private static final Logger logger = Logger.getLogger(EIPDispatcherServlet.class);
    private Map<String, Class> processors;
    private Map<Class, Map<String, Method>> processorMethods;
    public static final String BASE_URI = "/easportal/eip";
    public static final String DEFAULT_PROCESS_METHOD = "process";
    public static final String SESSION_ID = "sessionId";
    private static List<String> processorPkgs = new ArrayList<String>();

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.initProcessors();
    }

    private synchronized void initProcessors() throws ServletException {
        if (this.processors != null) {
            return;
        }
        this.processors = new HashMap<String, Class>();
        this.processorMethods = new HashMap<Class, Map<String, Method>>();
        for (String pkg : processorPkgs) {
            List<Class> classList;
            try {
                classList = ClassUtil.findPackageClasses(pkg);
            }
            catch (IOException e) {
                throw new ServletException((Throwable)e);
            }
            for (Class cl : classList) {
                if (!RequestProcessor.class.isAssignableFrom(cl)) continue;
                RequestProcessor rp = (RequestProcessor)ClassUtil.getNewInstance(cl);
                if (rp == null) {
                    logger.warn((Object)(cl.getName() + " newInstance fail!"));
                    continue;
                }
                this.processors.put(rp.getTargetURI(), cl);
                this.processorMethods.put(cl, this.getProcessorMethods(cl));
            }
        }
    }

    private Map<String, Method> getProcessorMethods(Class cl) {
        HashMap<String, Method> methodsMap = new HashMap<String, Method>();
        Method[] methods = ClassUtil.findClassMethods(cl, new Class[]{Map.class, String.class}, String.class, 1);
        this.addMethod(methodsMap, methods);
        methods = ClassUtil.findClassMethods(cl, new Class[]{Map.class, InputStream.class}, String.class, 1);
        this.addMethod(methodsMap, methods);
        return methodsMap;
    }

    private void addMethod(Map<String, Method> methodsMap, Method[] methods) {
        for (Method method : methods) {
            methodsMap.put(method.getName(), method);
        }
    }

    private String getCookie(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null && cookies.length > 0) {
            for (Cookie cookie : cookies) {
                if (!name.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    public void service(ServletRequest req, ServletResponse resp) throws ServletException, IOException {
        String reqContent;
        byte[] requestBody;
        logger.error((Object)"EIP has receive a http request");
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        response.setHeader("Content-type", "text/html;charset=UTF-8");
        RequestProcessor processor = this.getMatchedRequestProcessor(request);
        if (processor == null) {
            this.sendNotFound(response);
            return;
        }
        String encodeCookieVal = this.getCookie(request, "encoding");
        Encoding encoding = Encoding.convert(encodeCookieVal);
        String sessionID = null;
        String encryptKey = "";
        Context context = null;
        if (!(processor instanceof LoginServlet || processor instanceof GetDataCenterListServlet || processor instanceof AgentUpdateServlet || processor instanceof WebAPIServlet || processor instanceof WebAPILoginServlet || processor instanceof WebAPIBaseDataServlet || processor instanceof WebOpenAPIServlet || processor instanceof GetAttachmentServlet || processor instanceof WebCustomerOpenAPIServlet || processor instanceof OpenAPILoginServlet || processor instanceof WebAPIMetadataServlet || processor instanceof ClearDefineCacheServlet)) {
            sessionID = this.getCookie(request, SESSION_ID);
            if (StringUtils.isEmpty((String)sessionID)) {
                this.sendNotLogin(response);
                return;
            }
            try {
                context = SessionUtil.getContextByToken(sessionID);
            }
            catch (BOSException e1) {
                e1.printStackTrace();
            }
            if (context == null) {
                this.sendNotLogin(response);
                return;
            }
            EipUserInfo eipUserInfo = this.checkEipUser(response, context, context.get((Object)"eipUserId"));
            if (encoding != null) {
                switch (encoding) {
                    case ENCRYPT: 
                    case GZIP_AND_ENCRYPT: {
                        try {
                            IUser userBizUnit = UserFactory.getLocalInstance((Context)context);
                            UserInfo userInfo = userBizUnit.getUserByID(context.getCaller());
                            encryptKey = userInfo.getPassword();
                            break;
                        }
                        catch (Exception e) {
                            throw new ServletException((Throwable)e);
                        }
                    }
                }
            }
            processor.setContext(context);
        }
        encryptKey = encryptKey == null ? "" : encryptKey;
        String charset = request.getParameter("charset");
        charset = StringUtils.isEmpty((String)charset) ? "UTF-8" : charset;
        processor.setRequest(request);
        processor.setResponse(response);
        processor.setCharset(charset);
        processor.setEncoding(encoding);
        processor.setEncryptKey(encryptKey);
        Map<String, Method> methodMap = this.processorMethods.get(processor.getClass());
        String methodName = request.getParameter("method");
        Method targetMethod = StringUtils.isEmpty((String)methodName) ? methodMap.get(DEFAULT_PROCESS_METHOD) : methodMap.get(methodName);
        if (targetMethod == null && !"saveTableStructure".equals(methodName)) {
            this.sendNotFound(response);
            return;
        }
        String baseDataSyn = new BaseDataSynServlet().getTargetURI();
        String baseData = new BaseDataServlet().getTargetURI();
        boolean needCheck = !StringUtils.isEmpty((String)methodName) && !StringUtils.equals((String)methodName, (String)baseData) && !StringUtils.equals((String)methodName, (String)baseDataSyn);
        try {
            if (needCheck) {
                EIPLicenseCheckUtil.checkLicenseEnough(context);
            }
        }
        catch (Exception e) {
            this.sendLicenseNotEnough(response, e.getMessage());
            return;
        }
        Object[] params = new Object[2];
        Map paramMap = req.getParameterMap();
        HashMap<String, Object> processedParamMap = new HashMap<String, Object>();
        Set paramKeySet = paramMap.keySet();
        for (String paramName : paramKeySet) {
            String[] paramVals = (String[])paramMap.get(paramName);
            if (paramVals != null && paramVals.length == 1) {
                processedParamMap.put(paramName, paramVals[0]);
                continue;
            }
            processedParamMap.put(paramName, paramVals);
        }
        Enumeration headers = request.getHeaderNames();
        String headKey = null;
        while (headers.hasMoreElements()) {
            headKey = headers.nextElement().toString();
            processedParamMap.put(headKey, request.getHeader(headKey));
        }
        params[0] = processedParamMap;
        String tansferEncoding = request.getHeader("Transfer-Encoding");
        if (processor instanceof MidBillDataServlet && "queryTransmit".equals(methodName)) {
            requestBody = PacketsEncoder.parseInputStream(encodeCookieVal, (InputStream)request.getInputStream(), encryptKey);
            if (String.class.equals(targetMethod.getParameterTypes()[1])) {
                reqContent = new String(requestBody, charset);
                params[1] = reqContent;
            } else {
                params[1] = new ByteArrayInputStream(requestBody);
            }
        } else if ("chunked".equals(tansferEncoding) || processor instanceof MidBillDataServlet) {
            params[1] = request.getInputStream();
        } else {
            requestBody = PacketsEncoder.parseInputStream(encodeCookieVal, (InputStream)request.getInputStream(), encryptKey);
            if (targetMethod == null || String.class.equals(targetMethod.getParameterTypes()[1])) {
                reqContent = new String(requestBody, charset);
                params[1] = reqContent;
            } else {
                params[1] = new ByteArrayInputStream(requestBody);
            }
        }
        String resultString = "";
        try {
            resultString = "saveTableStructure".equals(methodName) ? this.saveTableStructure((Map)params[0], (String)params[1], context) : (String)targetMethod.invoke((Object)processor, params);
            response.addCookie(new Cookie("encoding", encodeCookieVal));
            if (resultString != null) {
                byte[] responseBody = PacketsEncoder.encodeOuputStream(resultString.getBytes(charset), encryptKey, encodeCookieVal);
                response.getOutputStream().write(responseBody);
                response.flushBuffer();
            }
        }
        catch (Exception e) {
            this.processBaseDataSynPKTable(context, processor, targetMethod, params);
            if (e.getCause() != null && e.getCause() instanceof Error) {
                response.sendError(500);
                throw (Error)e.getCause();
            }
            logger.error((Object)e);
            response.setStatus(500);
            String statusMsg = null;
            if (e instanceof JSONException) {
                statusMsg = ResultInfo.STATUS_INVALID_DATA_FORMAT.toString();
            }
            if (statusMsg == null) {
                statusMsg = ResultInfo.STATUS_ERROR.getStatus().toString();
            }
            response.getOutputStream().write(statusMsg.getBytes(charset));
            response.getOutputStream().flush();
        }
    }

    public String saveTableStructure(Map<String, String> params, String reqJSON, Context ctx) throws Exception {
        logger.error((Object)reqJSON.toString());
        ITableStructure tableStructure = TableStructureFactory.getLocalInstance(ctx);
        TableStructureCollection coll = tableStructure.getTableStructureCollection();
        HashMap<String, TableStructureInfo> map = new HashMap<String, TableStructureInfo>();
        for (int i = 0; i < coll.size(); ++i) {
            TableStructureInfo info = coll.get(i);
            map.put(info.getIP() + info.getPort() + info.getInstance() + info.getTableName(), info);
        }
        JSONArray array = JSON.parseArray((String)reqJSON);
        TableStructureCollection colls = new TableStructureCollection();
        for (int i = 0; i < array.size(); ++i) {
            com.alibaba.fastjson.JSONObject jsonObject = array.getJSONObject(i);
            String ip = jsonObject.getString("IP");
            String port = jsonObject.getString("port");
            String instance = jsonObject.getString("instance");
            String tableName = jsonObject.getString("tableName");
            String colName = jsonObject.getString("colName");
            TableStructureInfo tableStructureInfo = (TableStructureInfo)map.get(ip + port + instance + tableName);
            if (tableStructureInfo == null) {
                tableStructureInfo = new TableStructureInfo();
                tableStructureInfo.setIP(ip);
                tableStructureInfo.setPort(Integer.parseInt(port));
                tableStructureInfo.setInstance(instance);
                tableStructureInfo.setTableName(tableName);
            }
            tableStructureInfo.setColumnModel(colName);
            colls.add(tableStructureInfo);
        }
        CoreBaseCollection objCol = new CoreBaseCollection();
        objCol.addObjectCollection((IObjectCollection)colls);
        tableStructure.save(objCol);
        return null;
    }

    public void processBaseDataSynPKTable(Context ctx, RequestProcessor processor, Method targetMethod, Object[] params) {
        if (processor instanceof BaseDataSynServlet && "transfer".equals(targetMethod.getName())) {
            String pageNum = (String)((Map)params[0]).get("pageNum");
            String baseDataSynTable = (String)((Map)params[0]).get("baseDataSynTable");
            String transmitSerialNumber = (String)((Map)params[0]).get("transmitSerialNumber");
            BaseDataSynTableInfo baseDataSynTableInfo = this.initUserData();
            BufferedBillDataProvider bufferDataProvider = new BufferedBillDataProvider(baseDataSynTableInfo);
            int chunkedNumber = Integer.parseInt(pageNum);
            try {
                bufferDataProvider.open(ctx);
                bufferDataProvider.feedback(transmitSerialNumber, chunkedNumber, 2, BillDataStatus.ack, true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public BaseDataSynTableInfo initUserData() {
        BaseDataSynTableInfo baseDataSynTableInfo = new BaseDataSynTableInfo();
        return baseDataSynTableInfo;
    }

    private EipUserInfo checkEipUser(HttpServletResponse response, Context context, Object eipUserId) throws IOException {
        EipUserInfo eipUserInfo = null;
        Exception e = null;
        try {
            if (eipUserId != null) {
                IEipUser eipUser = EipUserFactory.getLocalInstance(context);
                eipUserInfo = eipUser.getEipUserInfo(CommonUtil.convert2PK(eipUserId.toString()));
            }
        }
        catch (Exception _e) {
            e = _e;
        }
        if (e != null || eipUserInfo == null) {
            response.setStatus(401);
            ResultInfo resultInfo = new ResultInfo(ResultInfo.STATUS_NOT_LOGIN.getStatus(), "EIP\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728!");
            response.getWriter().write(new JSONObject(resultInfo).toString());
            return null;
        }
        return eipUserInfo;
    }

    private void sendNotLogin(HttpServletResponse response) throws IOException {
        response.setStatus(401);
        response.getWriter().write(new JSONObject(ResultInfo.STATUS_NOT_LOGIN).toString());
    }

    private void sendNotFound(HttpServletResponse response) throws IOException {
        response.setStatus(404);
        response.getWriter().write(new JSONObject(ResultInfo.STATUS_PAGE_NOT_FOUND).toString());
    }

    private void sendLicenseNotEnough(HttpServletResponse response, String info) throws IOException {
        JSONObject taskJsonObject = new JSONObject();
        try {
            ResultInfo resultInfo = (ResultInfo)ResultInfo.STATUS_ERROR.clone();
            resultInfo.setStatusMsg(info);
            taskJsonObject = new JSONObject(resultInfo);
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        response.setStatus(500);
        response.getWriter().write(taskJsonObject.toString());
    }

    private RequestProcessor getMatchedRequestProcessor(HttpServletRequest request) {
        String uri = request.getRequestURI();
        logger.info((Object)("[EIP]request URI : " + uri));
        uri = WebUtil.relative(BASE_URI, uri);
        uri = uri.startsWith("/") ? uri : "/" + uri;
        Class clazz = null;
        if (uri.startsWith("/webAPI/dataService")) {
            clazz = this.processors.get("/webAPI/dataService");
            request.setAttribute("interfaceId", (Object)uri.substring(uri.lastIndexOf("/") + 1));
        } else {
            clazz = uri.startsWith("/openapi/login") ? this.processors.get("/openapi/login") : (uri.startsWith("/openapi/metadata") ? this.processors.get("/openapi/metadata") : (uri.startsWith("/openapi/") ? this.processors.get("/openapi/") : (uri.startsWith("/customer/") ? this.processors.get("/customer/") : this.processors.get(uri))));
        }
        if (clazz != null) {
            return (RequestProcessor)ClassUtil.getNewInstance(clazz);
        }
        return null;
    }

    public String getServletInfo() {
        return "EIP Agent Request Dispatcher";
    }

    static {
        processorPkgs.add("com.kingdee.eas.csinterface.agent.servlet.processor");
    }
}

